/*
 * Decompiled with CFR 0.152.
 */
package laudoresource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import laudoresource.LaudoResourceTag;

public class LaudoResource
implements Serializable {
    public static final String BUCKET = "laudoresource";
    public static final String[] SISTEMAS = new String[]{"DESKTOP", "ONE"};
    public static final String[] TIPOS = new String[]{"XLSX", "CSV", "DOCX", "CERES"};
    public static final String[] EXCEL_COLUNAS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "Y", "Z", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AI", "AJ", "AK", "AL", "AM", "AN", "AO", "AP", "AQ", "AR", "AS", "AT", "AU", "AV", "AX", "AY", "AZ"};
    private long id;
    private String cliente;
    private String tipo;
    private String sistema;
    private boolean ativo;
    private String arquivo;
    private String tags;
    private String nome;
    private int numeroamostras;
    private int linhainicial;
    private String analise;
    private String descricao;

    public void formatarTags() {
        this.tags = "";
        if (this.tipo.equals("XLSX")) {
            for (String x : EXCEL_COLUNAS) {
                if (!this.tags.equals("")) {
                    this.tags = this.tags + ";";
                }
                this.tags = this.tags + x + "=";
            }
        }
    }

    public List<LaudoResourceTag> listTags() {
        ArrayList<LaudoResourceTag> listTags = new ArrayList<LaudoResourceTag>();
        for (String s : this.tags.split(";")) {
            String[] x = s.split("=");
            LaudoResourceTag t = new LaudoResourceTag();
            t.setTag(x[0]);
            if (x.length > 1) {
                t.setValor(x[1]);
            } else {
                t.setValor("");
            }
            listTags.add(t);
        }
        return listTags;
    }

    public void setValorTag(String tag, String value) {
        String taglist = "";
        String item = "";
        for (String s : this.tags.split(";")) {
            item = s.substring(0, s.indexOf("="));
            taglist = item.equals(tag) ? taglist + item + "=" + value + ";" : taglist + s + ";";
        }
        this.tags = taglist.substring(0, taglist.length() - 1);
    }

    public boolean equals(Object o) {
        try {
            LaudoResource tmp = (LaudoResource)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.nome;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCliente() {
        return this.cliente;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getSistema() {
        return this.sistema;
    }

    public void setSistema(String sistema) {
        this.sistema = sistema;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(String arquivo) {
        this.arquivo = arquivo;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome.replace("|", "");
    }

    public String getAnalise() {
        return this.analise;
    }

    public void setAnalise(String analise) {
        this.analise = analise;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public int getNumeroamostras() {
        return this.numeroamostras;
    }

    public void setNumeroamostras(int numeroamostras) {
        this.numeroamostras = numeroamostras;
    }

    public int getLinhainicial() {
        return this.linhainicial;
    }

    public void setLinhainicial(int linhainicial) {
        this.linhainicial = linhainicial;
    }
}

