/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import ceresonemodel.utils.Cripto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jets3t.service.S3Service;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3Aws {
    public static final String TEMP_BUCKECT = "cerestmp";
    public static final String PUBLIC_BUCKET = "ceresonepublic";

    public static void main(String[] args) {
        try {
            S3Service s3Service = S3Aws.getService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static S3Service getService() {
        String Access_Key_ID = "AKIA4DPSN5CK5JWV6NFK";
        String Secret_Access_Key = "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";
        AWSCredentials awsCredentials = new AWSCredentials(Access_Key_ID, Secret_Access_Key);
        RestS3Service s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
        return s3Service;
    }

    public static String[] getBukets() throws Exception {
        S3Bucket[] buckets = S3Aws.getService().listAllBuckets();
        String[] resultado = new String[buckets.length];
        for (int x = 0; x < buckets.length; ++x) {
            resultado[x] = buckets[x].getName();
        }
        return resultado;
    }

    public static String salvarPublico(byte[] data, String key, String contentType) throws Exception {
        try {
            S3Service s3Service = S3Aws.getService();
            S3Bucket bucket = s3Service.getBucket(PUBLIC_BUCKET);
            S3Object fileObject = new S3Object(key, data);
            fileObject.setContentType(contentType);
            s3Service.putObject(bucket, fileObject);
            S3Aws.tornarPublico(key, PUBLIC_BUCKET);
            return "https://s3-sa-east-1.amazonaws.com/ceresonepublic/" + key;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao salvar arquivo: " + e.getMessage());
        }
    }

    public static String salvarPublico(String arquivo, String contentType) throws Exception {
        try {
            S3Service s3Service = S3Aws.getService();
            S3Bucket bucket = s3Service.getBucket(PUBLIC_BUCKET);
            File f = new File(arquivo);
            String key = f.getName();
            S3Object fileObject = new S3Object(bucket, f);
            fileObject.setContentType(contentType);
            s3Service.putObject(bucket, fileObject);
            S3Aws.tornarPublico(key, PUBLIC_BUCKET);
            return "https://s3-sa-east-1.amazonaws.com/ceresonepublic/" + key;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao salvar arquivo: " + e.getMessage());
        }
    }

    public static void salvar(byte[] data, String key, String contentType, String bucketName) throws Exception {
        try {
            S3Service s3Service = S3Aws.getService();
            S3Bucket bucket = s3Service.getBucket(bucketName);
            S3Object fileObject = new S3Object(key, data);
            if (contentType != null) {
                fileObject.setContentType(contentType);
            }
            s3Service.putObject(bucket, fileObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao salvar arquivo: " + e.getMessage());
        }
    }

    public static void salvar(String arquivo, String key, String contentType, String bucketName) throws Exception {
        try {
            byte[] data = S3Aws.getBytesFromFile(arquivo);
            S3Aws.salvar(data, key, contentType, bucketName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao salvar arquivo: " + e.getMessage());
        }
    }

    public static void tornarPublico(String key, String bucketName) throws Exception {
        try {
            S3Service s3Service = S3Aws.getService();
            S3Object obj = s3Service.getObject(bucketName, key);
            AccessControlList acl = s3Service.getObjectAcl(bucketName, key);
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, Permission.PERMISSION_READ);
            obj.setAcl(acl);
            s3Service.putObjectAcl(bucketName, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao tornar publico: " + e.getMessage());
        }
    }

    public static void excluirPublico(String url, String bucketName) throws Exception {
        try {
            String key = url.replace("https://s3-sa-east-1.amazonaws.com/ceresonepublic/", "");
            S3Service s3Service = S3Aws.getService();
            s3Service.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao tornar publico: " + e.getMessage());
        }
    }

    public static void excluir(String key, String bucketName) throws Exception {
        try {
            S3Service s3Service = S3Aws.getService();
            s3Service.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao tornar publico: " + e.getMessage());
        }
    }

    public static String getUrl(String bucketName, String key) throws Exception {
        try {
            int duration = 10;
            Calendar cal = Calendar.getInstance();
            cal.add(12, duration);
            Date expiryDate = cal.getTime();
            S3Service s3Service = S3Aws.getService();
            String url = s3Service.createSignedGetUrl(bucketName, key, expiryDate);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao obter url: " + e.getMessage());
        }
    }

    public static String saveImageTemp(byte[] data) throws Exception {
        String id = S3Aws.gerarTempID() + ".jpg";
        S3Aws.salvar(data, id, "jpg", TEMP_BUCKECT);
        return S3Aws.getUrl(TEMP_BUCKECT, id);
    }

    public static String gerarTempID() {
        String rnd = Cripto.randomPass(6);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyyhhmmss");
        String id = simpleDateFormat.format(new Date());
        return rnd + "_" + id;
    }

    public static S3Object[] listarArquivos(String bucketName) throws Exception {
        S3Object[] objects = S3Aws.getService().listObjects(bucketName);
        return objects;
    }

    public static S3Object[] listarArquivos(String bucketName, String folderName) throws Exception {
        S3Object[] objects = S3Aws.getService().listObjects(bucketName, folderName, null);
        S3Aws.getService().listObjects(bucketName, folderName, folderName);
        return objects;
    }

    public static void criarPasta(String bucketName, String folderName) throws Exception {
        S3Service s = S3Aws.getService();
        S3Bucket bucket = new S3Bucket(bucketName);
        S3Object directoryObject = new S3Object(folderName, "");
        directoryObject.setContentType("application/x-directory");
        s.putObject(bucket, directoryObject);
    }

    public static void salvar(List<String> arquivos, String bucketName) {
        System.out.println("M\u00e9todo salvar iniciado.");
        try {
            JDialog dialog = new JDialog((Frame)null, "Enviando arquivos...", true);
            dialog.setUndecorated(true);
            dialog.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createBevelBorder(0));
            panel.setLayout(new BorderLayout(10, 10));
            JLabel label = new JLabel("Enviando arquivos para nuvem...", 0);
            panel.add((Component)label, "North");
            JProgressBar progressBar = new JProgressBar(0, arquivos.size());
            progressBar.setStringPainted(true);
            panel.add((Component)progressBar, "Center");
            dialog.add((Component)panel, "Center");
            dialog.setSize(300, 80);
            dialog.setLocationRelativeTo(null);
            Thread thread = new Thread(() -> {
                System.out.println("Thread de upload iniciada.");
                try {
                    System.out.println("Conex\u00e3o com o bucket S3 estabelecida.");
                    for (int i = 0; i < arquivos.size(); ++i) {
                        String arquivo = (String)arquivos.get(i);
                        System.out.println("Enviando arquivo: " + arquivo);
                        String sufixoAssinado = "_temp_assinado";
                        File f = new File(arquivo);
                        String key = f.getName();
                        key = key.replace(sufixoAssinado, "");
                        byte[] b = S3Aws.getBytesFromFile(f);
                        S3Aws.salvar(b, key, "application/pdf", bucketName);
                        System.out.println("Arquivo enviado com sucesso: " + arquivo);
                        int progress = i + 1;
                        SwingUtilities.invokeLater(() -> {
                            System.out.println("Atualizando barra de progresso: " + progress);
                            progressBar.setValue(progress);
                        });
                    }
                    SwingUtilities.invokeLater(dialog::dispose);
                    System.out.println("Processo conclu\u00eddo e di\u00e1logo fechado.");
                }
                catch (Exception e) {
                    System.out.println("Erro ao enviar arquivos: " + e.getMessage());
                    SwingUtilities.invokeLater(() -> {
                        dialog.dispose();
                        JOptionPane.showMessageDialog(null, "Erro ao enviar arquivos: " + e.getMessage(), "Erro", 0);
                    });
                }
            });
            thread.start();
            System.out.println("Thread de upload executada.");
            dialog.setVisible(true);
            System.out.println("Di\u00e1logo de progresso exibido.");
        }
        catch (Exception e) {
            System.out.println("Erro geral no m\u00e9todo salvar: " + e.getMessage());
        }
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("N\u00e3o \u00e9 poss\u00edvel ler arquivo " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static byte[] getBytesFromFile(String file) throws IOException {
        return S3Aws.getBytesFromFile(new File(file));
    }
}

