/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

public class RetiraAcento {
    private static final char[] FIRST_CHAR = " !'#$%&'()*+\\-./0123456789:;<->?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ E ,f'.++^%S<O Z  ''''.--~Ts>o ZY !C#$Y|$'(a<--(_o+23'u .,1o>113?AAAAAAACEEEEIIIIDNOOOOOXOUUUUyTsaaaaaaaceeeeiiiidnooooo/ouuuuyty".toCharArray();
    private static final char[] SECOND_CHAR = "  '         ,                                               \\                                   $  r'. + o  E      ''    M  e     #  =  'C.<  R .-..     ..>424     E E               E E     hs    e e         h     e e     h ".toCharArray();

    public static String normalize(String str) {
        char[] chars = str.toCharArray();
        StringBuffer ret = new StringBuffer(chars.length * 2);
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == ' ' || aChar == '\t') {
                ret.append(' ');
                continue;
            }
            if (aChar <= ' ' || aChar >= '\u0100') continue;
            if (FIRST_CHAR[aChar - 32] != ' ') {
                ret.append(FIRST_CHAR[aChar - 32]);
            }
            if (SECOND_CHAR[aChar - 32] == ' ') continue;
            ret.append(SECOND_CHAR[aChar - 32]);
        }
        return ret.toString();
    }

    public static String removeEspeciais(String str) {
        str = RetiraAcento.normalize(str);
        str.replace("+", "_");
        str.replace("'", "");
        str.replace("(", "");
        str.replace(")", "");
        str.replace("/", "_");
        str.replace("%", "");
        str.replace("\\", "_");
        str.replace("&", "e");
        str.replace(",", "");
        return str;
    }

    public static String formatarNomeLaudoPDF(String str) {
        String resultado = str.toLowerCase().replace(" ", "_");
        resultado = resultado.replaceAll("[^a-z_]", "");
        return resultado.replace("__", "_");
    }

    public static void main(String[] args) {
        System.out.println(RetiraAcento.removeEspeciais("BUSSADORI, GARCIA & CIA LTDA"));
    }
}

