/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.commons.lang3.StringEscapeUtils;

public class FormatadorHTML {
    public static void main(String[] args) {
        String s = "<html>\n  <head>\n    \n  </head>\n  <body>\n    <strong><span><font color=\"#006600\">10.0</font></span></strong>\n  </body>\n</html>";
        System.out.println(s);
        try {
            s = FormatadorHTML.extractTextFromBody(s);
            System.out.println(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String removeScape(String html) {
        return StringEscapeUtils.unescapeHtml4((String)html);
    }

    public static String removeScapeJava(String unicode) {
        return StringEscapeUtils.unescapeJava((String)unicode);
    }

    public static String addScape(String unicode) {
        return StringEscapeUtils.escapeHtml4((String)unicode);
    }

    public static String string2Base64(String texto) {
        return Base64.getEncoder().encodeToString(texto.getBytes());
    }

    public static String base642String(String texto) {
        byte[] decodedBytes = Base64.getDecoder().decode(texto);
        String decodedString = new String(decodedBytes);
        return decodedString;
    }

    public static String urlEncode(String texto) throws Exception {
        return URLEncoder.encode(texto, "UTF-8");
    }

    public static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        String regex = "^[A-Za-z0-9+_.-]+@(.+)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static String extractTextFromBody(String htmlText) {
        final StringBuilder sb = new StringBuilder();
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        Document doc = htmlKit.createDefaultDocument();
        ParserDelegator parser = new ParserDelegator();
        try {
            ((HTMLEditorKit.Parser)parser).parse(new StringReader(htmlText), new HTMLEditorKit.ParserCallback(){
                boolean inBody = false;

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrs, int pos) {
                    if (tag == HTML.Tag.BODY) {
                        this.inBody = true;
                    }
                }

                @Override
                public void handleEndTag(HTML.Tag tag, int pos) {
                    if (tag == HTML.Tag.BODY) {
                        this.inBody = false;
                    }
                }

                @Override
                public void handleText(char[] data, int pos) {
                    if (this.inBody) {
                        sb.append(data);
                    }
                }
            }, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString().trim();
    }
}

