/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public class Formatador {
    public void formata(JFormattedTextField campo, String mascara) {
        try {
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formata(JFormattedTextField campo, int tamanho) {
        try {
            String mascara = new String();
            for (int i = 0; i < tamanho; ++i) {
                mascara = mascara + "*";
            }
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataData(JFormattedTextField campo) {
        try {
            String mascara = "##/##/####";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataFone(JFormattedTextField campo) {
        try {
            String mascara = "(##)*####-####";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataCelularParaguai(JFormattedTextField campo) {
        try {
            String mascara = "(####)###-###";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataCEP(JFormattedTextField campo) {
        try {
            String mascara = "##.###-###";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataCPF(JFormattedTextField campo) {
        try {
            String mascara = "###.###.###-##";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataRUC(JFormattedTextField campo) {
        try {
            String mascara = "**######-#";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void formataCNPJ(JFormattedTextField campo) {
        try {
            String mascara = "##.###.###/####-##";
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.install(campo);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static void formataNumero(JFormattedTextField campo) {
        try {
            MaskFormatter formatter = new MaskFormatter();
            formatter.setValidCharacters(".0123456789");
            formatter.install(campo);
            campo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    tmp.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    String txt = tmp.getText().trim();
                    if (txt.equals("")) {
                        txt = String.valueOf(0);
                    }
                    tmp.setText(String.valueOf(Float.parseFloat(txt)));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void formataNumeroInteiro(JFormattedTextField campo) {
        try {
            MaskFormatter formatter = new MaskFormatter();
            formatter.setValidCharacters("0123456789");
            formatter.install(campo);
            campo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    tmp.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    String txt = tmp.getText().trim();
                    if (txt.equals("")) {
                        txt = String.valueOf(0);
                    }
                    tmp.setText(String.valueOf(Integer.parseInt(txt)));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void formataNumero(JFormattedTextField campo, int caracteres) {
        try {
            String mascara = "";
            for (int j = 0; j < caracteres; ++j) {
                mascara = mascara + "*";
            }
            MaskFormatter formatter = new MaskFormatter(mascara);
            formatter.setValidCharacters(".0123456789");
            formatter.install(campo);
            campo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    tmp.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    String txt = tmp.getText().trim();
                    if (txt.equals("")) {
                        txt = String.valueOf(0);
                    }
                    tmp.setText(String.valueOf(Float.parseFloat(txt)));
                }
            });
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void formataNumeroNegativo(JFormattedTextField campo, int caracteres) {
        try {
            String mascara = "";
            for (int j = 0; j < caracteres; ++j) {
                mascara = mascara + "*";
            }
            MaskFormatter formatter = new MaskFormatter(mascara);
            formatter.setValidCharacters("-.0123456789");
            formatter.install(campo);
            campo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    tmp.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    String txt = tmp.getText().trim();
                    if (txt.equals("")) {
                        txt = String.valueOf(0);
                    }
                    tmp.setText(String.valueOf(Float.parseFloat(txt)));
                }
            });
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void formataNumeroInteiro(JFormattedTextField campo, int caracteres) {
        try {
            String mascara = "";
            for (int j = 0; j < caracteres; ++j) {
                mascara = mascara + "*";
            }
            MaskFormatter formatter = new MaskFormatter(mascara);
            formatter.setValidCharacters("0123456789");
            formatter.install(campo);
            campo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    tmp.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                    String txt = tmp.getText().trim();
                    if (txt.equals("")) {
                        txt = String.valueOf(0);
                    }
                    tmp.setText(String.valueOf(Integer.parseInt(txt)));
                }
            });
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static String toCPF(String valor) {
        try {
            MaskFormatter formatador = new MaskFormatter("###.###.###-##");
            formatador.setValueContainsLiteralCharacters(false);
            String cpfFormatado = formatador.valueToString(valor);
            return cpfFormatado;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String toCNPJ(String valor) {
        try {
            MaskFormatter formatador = new MaskFormatter("##.###.###/####-##");
            formatador.setValueContainsLiteralCharacters(false);
            String cpfFormatado = formatador.valueToString(valor);
            return cpfFormatado;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void formataNumero(JFormattedTextField campo, int tamanho, int precisao) {
        int i;
        String mascara = new String();
        for (i = 0; i < tamanho; ++i) {
            mascara = mascara + "#";
        }
        if (precisao > 0) {
            mascara = mascara + ".";
            for (i = 0; i < precisao; ++i) {
                mascara = mascara + "#";
            }
        }
        try {
            MaskFormatter mask = new MaskFormatter(mascara);
            mask.setPlaceholderCharacter('0');
            mask.install(campo);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static float arredonda(int decimal, float valor) {
        String casas = "";
        for (int i = 0; i < decimal; ++i) {
            casas = casas + "0";
        }
        String s = casas.equals("") ? "###0" : "###0." + casas;
        DecimalFormat form = new DecimalFormat(s);
        valor = Float.parseFloat(form.format(valor).replace(',', '.'));
        return valor;
    }

    public static String getValueMaskFormat(String mascara, String valor) throws Exception {
        String cpValor = "";
        char[] ch = valor.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char x = ch[i];
            if (!Character.isDigit(ch[i])) continue;
            cpValor = cpValor + String.valueOf(ch[i]);
        }
        valor = cpValor;
        MaskFormatter mask = new MaskFormatter(mascara);
        mask.setValueContainsLiteralCharacters(false);
        return mask.valueToString(valor);
    }

    public static String apenasNumeros(String dadosLidos) {
        try {
            String tmp = "";
            char[] cs = dadosLidos.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                char c = cs[i];
                if (!Character.isDigit(c)) continue;
                tmp = tmp + String.valueOf(c);
            }
            return tmp;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isNumero(String input) {
        String pattern = "^-?\\d+(\\.\\d+)?$";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(input.replace(",", "."));
        return matcher.matches();
    }
}

