/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;

public class Estatistica {
    private double[] array;

    public double getPearson() {
        return this.getDesvioPadrao() / this.getMediaAritmetica() * 100.0;
    }

    public double getMediaAritmetica() {
        double total = 0.0;
        for (int counter = 0; counter < this.array.length; ++counter) {
            total += this.array[counter];
        }
        return total / (double)this.array.length;
    }

    public double getSomaDosElementos() {
        double total = 0.0;
        for (int counter = 0; counter < this.array.length; ++counter) {
            total += this.array[counter];
        }
        return total;
    }

    public double getSomaDosElementosAoQuadrado() {
        double total = 0.0;
        for (int counter = 0; counter < this.array.length; ++counter) {
            total += Math.pow(this.array[counter], 2.0);
        }
        return total;
    }

    public double getMediaAritmetica(double[] array) {
        double total = 0.0;
        for (int counter = 0; counter < array.length; ++counter) {
            total += array[counter];
        }
        return total / (double)array.length;
    }

    public double getSomaDosElementos(double[] array) {
        double total = 0.0;
        for (int counter = 0; counter < array.length; ++counter) {
            total += array[counter];
        }
        return total;
    }

    public void ordenar() {
        Arrays.sort(this.array);
    }

    public void imprimeArray() {
        System.out.print("\nElementos do Array: ");
        for (int count = 0; count < this.array.length; ++count) {
            System.out.print(this.array[count] + " ");
        }
    }

    public int buscaPor(int value) {
        return Arrays.binarySearch(this.array, (double)value);
    }

    public double getVariancia() {
        double p1 = 1.0 / Double.valueOf(this.array.length - 1);
        double p2 = this.getSomaDosElementosAoQuadrado() - Math.pow(this.getSomaDosElementos(), 2.0) / Double.valueOf(this.array.length);
        return p1 * p2;
    }

    public double getDesvioPadrao() {
        return Math.sqrt(this.getVariancia());
    }

    public double getMediana() {
        this.ordenar();
        int tipo = this.array.length % 2;
        if (tipo == 1) {
            return this.array[(this.array.length + 1) / 2 - 1];
        }
        int m = this.array.length / 2;
        return (this.array[m - 1] + this.array[m]) / 2.0;
    }

    public double getModa() {
        HashMap<Double, Integer> map = new HashMap<Double, Integer>();
        Double moda = 0.0;
        Integer numMaior = 0;
        for (int count = 0; count < this.array.length; ++count) {
            Integer i = (Integer)map.get(new Double(this.array[count]));
            if (i == null) {
                map.put(new Double(this.array[count]), new Integer(1));
                continue;
            }
            map.put(new Double(this.array[count]), new Integer(i + 1));
            Integer numAtual = i + 1;
            if (numAtual <= numMaior) continue;
            numMaior = numAtual;
            moda = new Double(this.array[count]);
        }
        return moda;
    }

    public double getCoefAssimetria() {
        return (this.getMediaAritmetica() - this.getModa()) / this.getDesvioPadrao();
    }

    public double[] getArray() {
        return this.array;
    }

    public void setArray(double[] array) {
        this.array = array;
    }

    public static float arredondar(float valor, int precisao) {
        if (Float.isNaN(valor)) {
            return 0.0f;
        }
        if (Float.isInfinite(valor)) {
            return 0.0f;
        }
        String casas = "";
        for (int i = 0; i < precisao; ++i) {
            casas = casas + "0";
        }
        String s = casas.equals("") ? "###0" : "###0." + casas;
        DecimalFormat form = new DecimalFormat(s);
        valor = Float.parseFloat(form.format(valor).replace(',', '.'));
        return valor;
    }

    public static double arredondar(double valor, int precisao) {
        if (Double.isNaN(valor)) {
            return 0.0;
        }
        if (Double.isInfinite(valor)) {
            return 0.0;
        }
        String casas = "";
        for (int i = 0; i < precisao; ++i) {
            casas = casas + "0";
        }
        String s = casas.equals("") ? "###0" : "###0." + casas;
        DecimalFormat form = new DecimalFormat(s);
        valor = Double.parseDouble(form.format(valor).replace(',', '.'));
        return valor;
    }

    public double getMaximo() {
        this.ordenar();
        return this.array[this.array.length - 1];
    }

    public double getMinimo() {
        this.ordenar();
        return this.array[0];
    }

    public static boolean isNumero(String texto) {
        try {
            Double.parseDouble(texto);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

