/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import ceresonemodel.base.Cidade;
import ceresonemodel.dao.DAO_CERES;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;

public class DadosAPI {
    public static HashMap viaRUC_PE(String RUC) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String numDoc = DadosAPI.retirarCaracteresEspeciais(RUC.trim());
            JsonObject rootObject = DadosAPI.pegandoDadosDaAPI("https://api.apis.net.pe/v1/ruc?numero=" + numDoc);
            results.put("nombre", rootObject.get("nombre").getAsString().trim());
            results.put("tipoDocumento", rootObject.get("tipoDocumento").getAsString().trim());
            results.put("numeroDocumento", rootObject.get("numeroDocumento").getAsString().trim());
            results.put("estado", rootObject.get("estado").getAsString().trim());
            results.put("condicion", rootObject.get("condicion").getAsString().trim());
            results.put("direccion", rootObject.get("direccion").getAsString().trim());
            results.put("ubigeo", rootObject.get("ubigeo").getAsString().trim());
            results.put("viaTipo", rootObject.get("viaTipo").getAsString().trim());
            results.put("viaNombre", rootObject.get("viaNombre").getAsString().trim());
            results.put("zonaCodigo", rootObject.get("zonaCodigo").getAsString().trim());
            results.put("zonaTipo", rootObject.get("zonaTipo").getAsString().trim());
            results.put("numero", rootObject.get("numero").getAsString().trim());
            results.put("interior", rootObject.get("interior").getAsString().trim());
            results.put("lote", rootObject.get("lote").getAsString().trim());
            results.put("dpto", rootObject.get("dpto").getAsString().trim());
            results.put("manzana", rootObject.get("manzana").getAsString().trim());
            results.put("kilometro", rootObject.get("kilometro").getAsString().trim());
            results.put("distrito", rootObject.get("distrito").getAsString().trim());
            results.put("provincia", rootObject.get("provincia").getAsString().trim());
            results.put("departamento", rootObject.get("departamento").getAsString().trim());
            results.put("apellidoPaterno", rootObject.get("apellidoPaterno").getAsString().trim());
            results.put("apellidoMaterno", rootObject.get("apellidoMaterno").getAsString().trim());
            results.put("nombres", rootObject.get("nombres").getAsString().trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static HashMap viaDNI_PE(String DNI) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String numDoc = DadosAPI.retirarCaracteresEspeciais(DNI.trim());
            JsonObject rootObject = DadosAPI.pegandoDadosDaAPI("https://api.apis.net.pe/v1/dni?numero=" + numDoc);
            results.put("nombre", rootObject.get("nombre").getAsString().trim());
            results.put("tipoDocumento", rootObject.get("tipoDocumento").getAsString().trim());
            results.put("numeroDocumento", rootObject.get("numeroDocumento").getAsString().trim());
            results.put("estado", rootObject.get("estado").getAsString().trim());
            results.put("condicion", rootObject.get("condicion").getAsString().trim());
            results.put("direccion", rootObject.get("direccion").getAsString().trim());
            results.put("ubigeo", rootObject.get("ubigeo").getAsString().trim());
            results.put("viaTipo", rootObject.get("viaTipo").getAsString().trim());
            results.put("viaNombre", rootObject.get("viaNombre").getAsString().trim());
            results.put("zonaCodigo", rootObject.get("zonaCodigo").getAsString().trim());
            results.put("zonaTipo", rootObject.get("zonaTipo").getAsString().trim());
            results.put("numero", rootObject.get("numero").getAsString().trim());
            results.put("interior", rootObject.get("interior").getAsString().trim());
            results.put("lote", rootObject.get("lote").getAsString().trim());
            results.put("dpto", rootObject.get("dpto").getAsString().trim());
            results.put("manzana", rootObject.get("manzana").getAsString().trim());
            results.put("kilometro", rootObject.get("kilometro").getAsString().trim());
            results.put("distrito", rootObject.get("distrito").getAsString().trim());
            results.put("provincia", rootObject.get("provincia").getAsString().trim());
            results.put("departamento", rootObject.get("departamento").getAsString().trim());
            results.put("apellidoPaterno", rootObject.get("apellidoPaterno").getAsString().trim());
            results.put("apellidoMaterno", rootObject.get("apellidoMaterno").getAsString().trim());
            results.put("nombres", rootObject.get("nombres").getAsString().trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static HashMap viaCNPJ(String CNPJ) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String parametro = DadosAPI.retirarCaracteresEspeciais(CNPJ.trim());
            JsonObject rootObject = DadosAPI.pegandoDadosDaAPI("https://www.receitaws.com.br/v1/cnpj/" + parametro);
            if (rootObject.get("status").getAsString().equals("OK")) {
                results.put("nome", rootObject.get("fantasia").getAsString().trim());
                results.put("telefone", rootObject.get("telefone").getAsString().trim());
                results.put("email", rootObject.get("email").getAsString().trim());
                results.put("bairro", rootObject.get("bairro").getAsString().trim());
                results.put("endereco", rootObject.get("logradouro").getAsString().trim());
                results.put("numero", rootObject.get("numero").getAsString().trim());
                results.put("cep", rootObject.get("cep").getAsString().trim());
                results.put("complemento", rootObject.get("complemento").getAsString().trim());
                results.put("razaoSocial", rootObject.get("nome").getAsString().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static HashMap viaCEP(String CEP, DAO_CERES dao) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            String parametro = DadosAPI.retirarCaracteresEspeciais(CEP.trim());
            JsonObject rootObject = DadosAPI.pegandoDadosDaAPI("http://viacep.com.br/ws/" + parametro + "/json");
            if (!rootObject.has("erro")) {
                results.put("cep", rootObject.get("cep").getAsString().trim());
                results.put("logradouro", rootObject.get("logradouro").getAsString().trim());
                results.put("complemento", rootObject.get("complemento").getAsString().trim());
                results.put("bairro", rootObject.get("bairro").getAsString().trim());
                results.put("localidade", rootObject.get("localidade").getAsString().trim());
                results.put("uf", rootObject.get("uf").getAsString().trim());
                results.put("ibge", rootObject.get("ibge").getAsString().trim());
                results.put("gia", rootObject.get("gia").getAsString().trim());
                results.put("ddd", rootObject.get("ddd").getAsString().trim());
                results.put("siafi", rootObject.get("siafi").getAsString().trim());
                Cidade cidade = Cidade.get(URLEncoder.encode(rootObject.get("localidade").getAsString().trim(), "UTF-8"), URLEncoder.encode(rootObject.get("uf").getAsString().trim(), "UTF-8"), dao);
                results.put("Cidade", cidade);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private static JsonObject pegandoDadosDaAPI(String linkDaAPI) {
        JsonObject temp = new JsonObject();
        try {
            URL url = new URL(linkDaAPI);
            URLConnection urlConnection = url.openConnection();
            InputStream is = urlConnection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder jsonSb = new StringBuilder();
            br.lines().forEach(l -> jsonSb.append(l.trim()));
            temp = new JsonParser().parse(jsonSb.toString()).getAsJsonObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }

    private static String retirarCaracteresEspeciais(String campo) {
        String temp = "";
        try {
            char[] caracteres = campo.toCharArray();
            StringBuilder sb = new StringBuilder();
            char[] cArray = caracteres;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character caracter = Character.valueOf(cArray[i]);
                if (!Character.isDigit(caracter.charValue())) continue;
                sb.append(caracter);
            }
            temp = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }
}

