/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;

public class CampoMoeda
extends JFormattedTextField {
    private float valor;

    public CampoMoeda() {
        try {
            this.valor = 0.0f;
            this.addKeyListener(new KeyMoeda());
            this.addFocusListener(new FocusMoeda());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erro ao criar campo de data", "Aten\u00e7\u00e3o!", 0);
        }
    }

    public float getValor() {
        try {
            this.valor = CampoMoeda.moedaToFloat(this.getText().trim());
            return this.valor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public void setValor(float valor) {
        this.valor = valor;
        this.setText(CampoMoeda.floatToMoeda(valor));
    }

    @Override
    public String toString() {
        return CampoMoeda.floatToMoeda(this.valor);
    }

    public static float moedaToFloat(String moeda) {
        if ((moeda = moeda.trim()).equals("")) {
            return 0.0f;
        }
        if (!(moeda.startsWith("R$") || moeda.startsWith("Gs") || moeda.startsWith("G"))) {
            return 0.0f;
        }
        moeda = CampoMoeda.limpaDados(moeda);
        char[] s = moeda.toCharArray();
        moeda = "";
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == '.') continue;
            moeda = moeda + String.valueOf(s[i]);
        }
        moeda = moeda.replace(',', '.');
        float tmp = Float.parseFloat(moeda);
        return tmp;
    }

    public static String floatToMoeda(float valor) {
        BigDecimal big = new BigDecimal(String.valueOf(valor));
        NumberFormat moeda = NumberFormat.getCurrencyInstance();
        return moeda.format(big);
    }

    public static String floatToMoeda(double valor) {
        BigDecimal big = new BigDecimal(String.valueOf(valor));
        NumberFormat moeda = NumberFormat.getCurrencyInstance();
        return moeda.format(big);
    }

    private static String limpaDados(String dados) {
        try {
            String tmp = "";
            char[] cs = dados.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                char c = cs[i];
                if (!Character.isDigit(c) && c != '.' && c != ',') continue;
                tmp = tmp + String.valueOf(c);
            }
            return tmp;
        }
        catch (Exception e) {
            return null;
        }
    }

    private class FocusMoeda
    implements FocusListener {
        FocusMoeda() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            try {
                JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                String txt = tmp.getText();
                if (txt.startsWith("R$") || txt.startsWith("Gs") || txt.startsWith("G")) {
                    return;
                }
                NumberFormat moeda = NumberFormat.getCurrencyInstance();
                if (txt.equals("")) {
                    tmp.setText(moeda.format(0.0));
                }
                tmp.setText(moeda.format(Float.parseFloat(tmp.getText().replace(',', '.'))));
            }
            catch (Exception e) {
                JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
                tmp.setText(String.valueOf(0));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            JFormattedTextField tmp = (JFormattedTextField)e.getSource();
            tmp.selectAll();
        }
    }

    private class KeyMoeda
    implements KeyListener {
        boolean trava;

        KeyMoeda() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            char c = evt.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
            String txt = tmp.getText();
            if (txt.indexOf(44) != -1) {
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            JFormattedTextField tmp = (JFormattedTextField)evt.getSource();
            String txt = tmp.getText();
            char c = evt.getKeyChar();
            if (Character.isLetter(c)) {
                evt.consume();
            }
            if (c == ',' && txt.indexOf(44) != -1) {
                evt.consume();
            }
        }
    }
}

