/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import ceresonemodel.utils.CampoData;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;

public class CampoDataHora
extends CampoData {
    public CampoDataHora() {
        try {
            MaskFormatter mask = new MaskFormatter("dd/MM/yyyy HH:mm");
            mask.install(this);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 112) {
                        CampoDataHora.this.setText(CampoData.dataHoraToString(new Date()));
                    }
                }
            });
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erro ao criar campo de data", "Aten\u00e7\u00e3o!", 0);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (!CampoDataHora.this.validar()) {
                    JOptionPane.showMessageDialog(null, "Campo Data preenchido de forma errada!", "Aten\u00e7\u00e3o!", 1);
                    ((JFormattedTextField)evt.getSource()).setText("");
                }
            }
        });
    }

    @Override
    public boolean validar() {
        try {
            String data = this.getText().trim();
            if (data.equals("/  /") || data.equals("") || data.equals("/  / :")) {
                return true;
            }
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            this.setValor(fData.parse(data));
            return fData.format(this.getValor()).equals(data);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Date getValor() {
        try {
            String data = this.getText().trim();
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            this.valor = fData.parse(data);
            return this.valor;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setValor(Date valor) {
        SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        if (valor == null) {
            this.setText("");
        } else {
            this.setText(fData.format(valor));
        }
        this.valor = valor;
    }
}

