/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.utils;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;

public class CampoData
extends JFormattedTextField {
    protected Date valor;

    public CampoData() {
        try {
            MaskFormatter mask = new MaskFormatter("##/##/####");
            mask.install(this);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 112 && CampoData.this.isEnabled() && CampoData.this.isEditable()) {
                        CampoData.this.setText(CampoData.dataToString(new Date()));
                    }
                }
            });
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erro ao criar campo de data", "Aten\u00e7\u00e3o!", 0);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (!CampoData.this.validar()) {
                    JOptionPane.showMessageDialog(null, "Campo Data preenchido de forma errada!", "Aten\u00e7\u00e3o!", 1);
                    ((JFormattedTextField)evt.getSource()).setText("");
                }
            }
        });
    }

    public boolean validar() {
        try {
            String data = this.getText().trim();
            if (data.equals("/  /") || data.equals("")) {
                return true;
            }
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy");
            this.setValor(fData.parse(data));
            return fData.format(this.getValor()).equals(data);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Date getValor() {
        try {
            String data = this.getText().trim();
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy");
            this.valor = fData.parse(data);
            return this.valor;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dataToString(Date data) {
        try {
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy");
            return fData.format(data);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String dataToString_MesAno(Date data) {
        try {
            SimpleDateFormat fData = new SimpleDateFormat("MM/yyyy");
            return fData.format(data);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String dataHoraToString(Date data) {
        try {
            SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            return fData.format(data);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date stringToData(String data) {
        try {
            SimpleDateFormat fData = data.length() > 8 ? new SimpleDateFormat("dd/MM/yyyy") : new SimpleDateFormat("dd/MM/yy");
            return fData.parse(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringSqlDataToData(String data) {
        try {
            SimpleDateFormat fData = new SimpleDateFormat("yyyy-MM-dd");
            return fData.parse(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValor(Date valor) {
        SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy");
        if (valor == null) {
            this.setText("");
        } else {
            this.setText(fData.format(valor));
        }
        this.valor = valor;
    }

    @Override
    public String toString() {
        SimpleDateFormat fData = new SimpleDateFormat("dd/MM/yyyy");
        String s = new String();
        if (this.getValor() != null) {
            s = fData.format(this.getValor());
        }
        return s;
    }

    public void setHoje() {
        Date data = new Date();
        data.setTime(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.setText(sdf.format(data));
    }

    public static Date getHoje() {
        Date data = new Date();
        data.setTime(System.currentTimeMillis());
        return data;
    }

    public static int getIdade(Date d) {
        try {
            Date hoje = new Date();
            hoje.setTime(System.currentTimeMillis());
            long x = hoje.getTime() - d.getTime();
            Date y = new Date(x);
            int anos = y.getYear() - 70;
            return anos;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Date somaData(int x) {
        Date hoje = new Date();
        Date nova_data = new Date(hoje.getTime() + 86400000L * (long)x);
        return nova_data;
    }

    public static Date somaData(Date data, int x) {
        Date nova_data = new Date(data.getTime() + 86400000L * (long)x);
        return nova_data;
    }

    public static Date subtraiData(Date data, int x) {
        Date nova_data = new Date(data.getTime() - (long)(86400000 * x));
        return nova_data;
    }

    public static Date somaUmMes(Date data) {
        SimpleDateFormat fAno = new SimpleDateFormat("yyyy");
        SimpleDateFormat fDia = new SimpleDateFormat("dd");
        SimpleDateFormat fMes = new SimpleDateFormat("MM");
        int mes = Integer.parseInt(fMes.format(data)) + 1;
        int ano = Integer.parseInt(fAno.format(data));
        if (mes > 12) {
            mes = 1;
            ++ano;
        }
        return CampoData.stringToData(fDia.format(data) + "/" + mes + "/" + ano);
    }

    public static Date somaMes(Date data, int meses) {
        if (data == null) {
            return null;
        }
        for (int x = 0; x < meses; ++x) {
            data = CampoData.somaUmMes(data);
        }
        return data;
    }

    public static int getDia(Date dataInic, Date dataFim) {
        return (int)((dataFim.getTime() - dataInic.getTime()) / 86400000L);
    }

    public static int getAno() {
        Date data = CampoData.getHoje();
        SimpleDateFormat fData = new SimpleDateFormat("yyyy");
        return Integer.parseInt(fData.format(data));
    }

    public static int getAnoCom2Digitos() {
        Date data = CampoData.getHoje();
        SimpleDateFormat fData = new SimpleDateFormat("yy");
        return Integer.parseInt(fData.format(data));
    }

    public static int getMes() {
        Date data = CampoData.getHoje();
        SimpleDateFormat fData = new SimpleDateFormat("MM");
        return Integer.parseInt(fData.format(data));
    }

    public static Date getPrimeiroDiaDoMes(Date data) {
        SimpleDateFormat fAno = new SimpleDateFormat("yyyy");
        SimpleDateFormat fDia = new SimpleDateFormat("dd");
        SimpleDateFormat fMes = new SimpleDateFormat("MM");
        int mes = Integer.parseInt(fMes.format(data));
        int ano = Integer.parseInt(fAno.format(data));
        return CampoData.stringToData("01/" + mes + "/" + ano);
    }

    public static Date getUltimoDiaDoMes(Date data) {
        SimpleDateFormat fAno = new SimpleDateFormat("yyyy");
        SimpleDateFormat fDia = new SimpleDateFormat("dd");
        SimpleDateFormat fMes = new SimpleDateFormat("MM");
        int mes = Integer.parseInt(fMes.format(data)) + 1;
        int ano = Integer.parseInt(fAno.format(data));
        return CampoData.somaData(CampoData.stringToData("01/" + mes + "/" + ano), -1);
    }

    public static boolean eMenor(Date data, Date comparacao) {
        data = CampoData.stringToData(CampoData.dataToString(data));
        comparacao = CampoData.stringToData(CampoData.dataToString(comparacao));
        return data.getTime() < comparacao.getTime();
    }

    public static boolean eMaior(Date data, Date comparacao) {
        data = CampoData.stringToData(CampoData.dataToString(data));
        comparacao = CampoData.stringToData(CampoData.dataToString(comparacao));
        return data.getTime() > comparacao.getTime();
    }

    public static Date somaData2(int x) {
        Date hoje = new Date();
        Date nova_data = new Date(hoje.getTime());
        return nova_data;
    }

    public static java.sql.Date dataToSQLData(Date data) {
        if (data == null) {
            return null;
        }
        return new java.sql.Date(data.getTime());
    }

    public static String dataToSQLString(Date data) {
        SimpleDateFormat fData = new SimpleDateFormat("yyyy-MM-dd");
        String s = new String();
        if (data != null) {
            s = fData.format(data);
        }
        return s;
    }

    public static String dataToSQLStringCeresServerFuso(Date data) {
        SimpleDateFormat fData = new SimpleDateFormat("yyyy-MM-dd");
        fData.setTimeZone(TimeZone.getTimeZone("GMT-3"));
        String s = "";
        if (data != null) {
            s = fData.format(data);
        }
        return s;
    }

    public static String dataHoraToSQLString(Date data) {
        try {
            SimpleDateFormat fData = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return fData.format(data);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date getDataDialog(String msg) {
        try {
            msg = msg + "\nFormato \"dd/MM/yyyy\"\nExemplo 01/01/" + CampoData.getAno();
            String input = JOptionPane.showInputDialog(msg, (Object)CampoData.dataToString(new Date()));
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd/MM/yyyy");
            return inputFormat.parse(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            String input = JOptionPane.showInputDialog("Insert Date in Form MM/dd/yy");
            SimpleDateFormat inputFormat = new SimpleDateFormat("MM/dd/yy");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd.MM.yy");
            Date date = inputFormat.parse(input);
            String formattedDate = outputFormat.format(date);
            JOptionPane.showMessageDialog(null, formattedDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

