/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.users;

import ceresonemodel.dao.DAO_CERES;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.users.Usuario;
import ceresonemodel.users.UsuarioGrupousUario;
import com.fasterxml.jackson.annotation.JsonFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Usuariogrupo
implements Serializable {
    private long id;
    private boolean ativo;
    private String nome;
    private String permissoes;
    private Long sig_id;

    public boolean equals(Object o) {
        try {
            Usuariogrupo tmp = (Usuariogrupo)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getNome();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<Usuario> getUsuarios(DAO_CERES dao_ceres, DAO_LAB dao_lab, boolean apenas_ativos) throws Exception {
        Usuario[] usuarios = null;
        UsuarioGrupousUario[] ucus = (UsuarioGrupousUario[])dao_lab.listObject(UsuarioGrupousUario[].class, "usuariogrupousuario?usuariogrupo=eq." + this.getId());
        if (ucus != null) {
            String query = "";
            ArrayList<String> tmp = new ArrayList<String>();
            for (UsuarioGrupousUario uc : ucus) {
                if (tmp.contains(uc.getLogin())) continue;
                tmp.add(uc.getLogin());
                if (query != "") {
                    query = query + ",";
                }
                query = query + "login.eq." + uc.getLogin();
            }
            if (tmp.size() == 0) {
                return new ArrayList<Usuario>();
            }
            query = "usuario?or=(" + query + ")";
            if (apenas_ativos) {
                query = query + "&ativo=eq.true";
            }
            query = query + "&order=nome";
            query = query.replace(" ", "%20");
            usuarios = (Usuario[])dao_ceres.listObject(Usuario[].class, query);
        }
        if (usuarios != null) {
            return Arrays.asList(usuarios);
        }
        return new ArrayList<Usuario>();
    }

    public String getPermissoes() {
        return this.permissoes;
    }

    public void setPermissoes(String permissoes) {
        this.permissoes = permissoes;
    }

    public List<String> valorPermissoes() {
        if (this.permissoes != null) {
            return Arrays.asList(this.permissoes.split(";"));
        }
        return new ArrayList<String>();
    }

    public void valorPermissoes(List<String> opcoes) {
        this.permissoes = "";
        for (String opcao : opcoes) {
            this.permissoes = this.permissoes + (this.permissoes.equals("") ? "" : ";");
            this.permissoes = this.permissoes + opcao;
        }
    }

    public Long getSig_id() {
        return this.sig_id;
    }

    public void setSig_id(Long sig_id) {
        this.sig_id = sig_id;
    }
}

