/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.users;

import ceresonemodel.dao.DAO_CERES;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.dao.DAO_SIG;
import ceresonemodel.fatura.FaturaCaixaTipo;
import ceresonemodel.fatura.FaturaCaixaTipoPermissao;
import ceresonemodel.users.Cliente;
import ceresonemodel.users.UsuarioGrupousUario;
import ceresonemodel.users.Usuariogrupo;
import ceresonemodel.utils.Cripto;
import ceresonemodel.utils.FormatadorHTML;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Usuario
implements Serializable {
    private String login;
    private String email;
    private String senha;
    private String urlimagem;
    private boolean ativo;
    private String nome;
    private boolean ceres;
    private boolean administrador;
    private boolean suporte;
    private boolean analista;
    private boolean loggedin;
    private String ultimapaginaacessada;
    private Date ultimoacesso;
    private boolean debug;
    private String art_username;
    private boolean permissao_financeiro;
    private String fone;
    private String permissao_ip;
    @JsonIgnore
    private List<Usuariogrupo> grupos = new ArrayList<Usuariogrupo>();
    @JsonIgnore
    private List<FaturaCaixaTipo> caixas = new ArrayList<FaturaCaixaTipo>();
    @JsonIgnore
    private Long sig_id;

    public static String criptografaSenha(String senha) {
        if (senha == null || senha.equals("")) {
            return null;
        }
        try {
            byte[] b = Cripto.digest(senha.getBytes(), "md5");
            senha = Cripto.byteArrayToHexString(b);
            return senha;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void carregaGrupos(DAO_LAB dao_lab) throws Exception {
        Usuariogrupo[] tmps = null;
        UsuarioGrupousUario[] ucus = (UsuarioGrupousUario[])dao_lab.listObject(UsuarioGrupousUario[].class, "usuariogrupousuario?login=eq." + FormatadorHTML.urlEncode(this.getLogin()));
        if (ucus != null) {
            String query = "";
            ArrayList<Long> tmp = new ArrayList<Long>();
            for (UsuarioGrupousUario uc : ucus) {
                if (tmp.contains(uc.getUsuariogrupo())) continue;
                tmp.add(uc.getUsuariogrupo());
                if (query != "") {
                    query = query + ",";
                }
                query = query + "id.eq." + uc.getUsuariogrupo();
            }
            if (tmp.size() > 0) {
                query = "usuariogrupo?or=(" + query + ")";
                query = query + "&ativo=eq.true";
                tmps = (Usuariogrupo[])dao_lab.listObject(Usuariogrupo[].class, query);
            }
        }
        this.grupos = tmps != null ? Arrays.asList(tmps) : new ArrayList<Usuariogrupo>();
    }

    public void carregaCaixas(DAO_LAB dao_lab) throws Exception {
        FaturaCaixaTipo[] tmps2;
        this.caixas = new ArrayList<FaturaCaixaTipo>();
        FaturaCaixaTipo[] tmps = null;
        FaturaCaixaTipoPermissao[] fctp = (FaturaCaixaTipoPermissao[])dao_lab.listObject(FaturaCaixaTipoPermissao[].class, "faturacaixatipopermissao?usuario=eq." + this.getLogin());
        if (fctp != null) {
            String query = "";
            ArrayList<Long> tmp = new ArrayList<Long>();
            for (FaturaCaixaTipoPermissao uc : fctp) {
                if (tmp.contains(uc.getCaixatipo())) continue;
                tmp.add(uc.getCaixatipo());
                if (query != "") {
                    query = query + ",";
                }
                query = query + "id.eq." + uc.getCaixatipo();
            }
            if (tmp.size() == 0) {
                this.caixas = new ArrayList<FaturaCaixaTipo>();
            }
            query = "faturacaixatipo?or=(" + query + ")";
            query = query + "&restrito=eq.true&bloquear=eq.false&desativado=eq.false";
            tmps = (FaturaCaixaTipo[])dao_lab.listObject(FaturaCaixaTipo[].class, query);
            Serializable[] serializableArray = tmps;
            int n = serializableArray.length;
            for (int i = 0; i < n; ++i) {
                Serializable x = serializableArray[i];
                this.caixas.add((FaturaCaixaTipo)x);
            }
        }
        for (FaturaCaixaTipo x : tmps2 = (FaturaCaixaTipo[])dao_lab.listObject(FaturaCaixaTipo[].class, "faturacaixatipo?restrito=eq.false&bloquear=eq.false&desativado=eq.false")) {
            this.caixas.add(x);
        }
    }

    public boolean equals(Object o) {
        try {
            Usuario tmp = (Usuario)o;
            return tmp.getLogin().equals(this.getLogin());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Comparator<Usuario> getComparador() {
        return (usuario1, usuario2) -> usuario1.getNome().compareTo(usuario2.getNome());
    }

    public String toString() {
        return this.getNome();
    }

    public List<Cliente> getClientes(DAO_CERES dao) throws Exception {
        if (this.isCeres()) {
            Cliente[] clientes = (Cliente[])dao.listObject(Cliente[].class, "cliente?ativo=eq.true&codlab_nome=neq.null&order=label");
            return Arrays.asList(clientes);
        }
        return dao.func_obter_clientes_por_usuario(this.login);
    }

    public void loadSig(DAO_SIG dao_sig) throws Exception {
        this.sig_id = dao_sig.func_get_user(this.login, this.nome, this.email, this.ativo);
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUrlimagem() {
        return this.urlimagem;
    }

    public void setUrlimagem(String urlimagem) {
        this.urlimagem = urlimagem;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean isCeres() {
        return this.ceres;
    }

    public void setCeres(boolean ceres) {
        this.ceres = ceres;
    }

    public boolean isAdministrador() {
        return this.administrador;
    }

    public void setAdministrador(boolean administrador) {
        this.administrador = administrador;
    }

    public boolean isSuporte() {
        return this.suporte;
    }

    public void setSuporte(boolean suporte) {
        this.suporte = suporte;
    }

    public boolean isAnalista() {
        return this.analista;
    }

    public void setAnalista(boolean analista) {
        this.analista = analista;
    }

    public boolean isLoggedin() {
        return this.loggedin;
    }

    public void setLoggedin(boolean loggedin) {
        this.loggedin = loggedin;
    }

    public String getUltimapaginaacessada() {
        return this.ultimapaginaacessada;
    }

    public void setUltimapaginaacessada(String ultimapaginaacessada) {
        this.ultimapaginaacessada = ultimapaginaacessada;
    }

    public Date getUltimoacesso() {
        return this.ultimoacesso;
    }

    public void setUltimoacesso(Date ultimoacesso) {
        this.ultimoacesso = ultimoacesso;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getArt_username() {
        return this.art_username;
    }

    public void setArt_username(String art_username) {
        this.art_username = art_username;
    }

    public List<Usuariogrupo> getGrupos() {
        return this.grupos;
    }

    public void setGrupos(List<Usuariogrupo> grupos) {
        this.grupos = grupos;
    }

    public List<FaturaCaixaTipo> getCaixas() {
        return this.caixas;
    }

    public void setCaixas(List<FaturaCaixaTipo> caixas) {
        this.caixas = caixas;
    }

    public long getSig_id() {
        return this.sig_id;
    }

    public void setSig_id(long sig_id) {
        this.sig_id = sig_id;
    }

    public boolean isPermissao_financeiro() {
        return this.permissao_financeiro;
    }

    public void setPermissao_financeiro(boolean permissao_financeiro) {
        this.permissao_financeiro = permissao_financeiro;
    }

    public String getFone() {
        return this.fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public String getPermissao_ip() {
        return this.permissao_ip;
    }

    public void setPermissao_ip(String permissao_ip) {
        this.permissao_ip = permissao_ip;
    }
}

