/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.users;

import ceresonemodel.dao.DAO_CERES;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.users.Usuario;
import ceresonemodel.utils.RetiraAcento;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Cliente
implements Serializable {
    public static final String ESSENTIAL = "Essential";
    public static final String BASIC = "Basic";
    public static final String STANDARD = "Standard";
    public static final String PLUS = "Plus";
    public static final String[] VERCOES = new String[]{"Essential", "Basic", "Standard", "Plus"};
    private String nome;
    private String label;
    private String persistence;
    private boolean ativo;
    private int analises;
    private boolean analisesilimitadas;
    private String buckets3;
    private String urllogo;
    private String urlheader;
    private String urllogo_mini;
    private String url_reports;
    private String jasper_mapa_cachimbagem;
    private String jasper_qtd_amostra_mapa_cachimbagem;
    private boolean destravarleituratodosanalistas;
    private String interfacefundo;
    private String interfaceloginlogo;
    private String laudomodelopadrao;
    private String interfacedashboardlogo;
    private boolean codlab_ativo;
    private String codlab_nome;
    private int dbv;
    private Date dbvdata;
    private String cnpj;
    private String cnpjapi;
    private boolean uloadlaudomanual;
    private boolean aprovacaofinanceiro;
    private boolean atividadeevento;
    private String ceres2_versao;
    private String dbname;
    private String ceres2_logo;
    private String ceres2_logo_mini;
    @JsonIgnore
    private List<Usuario> usuarios;
    @JsonIgnore
    private DAO_LAB dao;

    public boolean equals(Object o) {
        try {
            Cliente tmp = (Cliente)o;
            return tmp.getNome().equals(this.getNome());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String nome4DiretorioS3() {
        return RetiraAcento.removeEspeciais(this.nome.toLowerCase().replace(" ", "_"));
    }

    public void carregaUsuarios(DAO_CERES dao) throws Exception {
        this.usuarios = dao.func_obter_usuarios_por_cliente(this.getNome());
    }

    public static Cliente carregaCliente(String client_nome, DAO_CERES dao) {
        try {
            Cliente cliente = null;
            Cliente[] x = (Cliente[])dao.listObject(Cliente[].class, "cliente?nome=eq." + client_nome);
            if (x.length > 0) {
                cliente = x[0];
            }
            return cliente;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Usuario> pesquisaUsuarios(boolean apenas_analistas, String login, DAO_CERES dao_ceres) throws Exception {
        ArrayList<Usuario> users = new ArrayList<Usuario>();
        this.carregaUsuarios(dao_ceres);
        for (Usuario user : this.usuarios) {
            if (apenas_analistas && !user.isAnalista()) continue;
            if (!login.equals("")) {
                if (!user.getLogin().toUpperCase().contains(login.toUpperCase())) continue;
                users.add(user);
                continue;
            }
            users.add(user);
        }
        return users;
    }

    public String toString() {
        return this.getLabel();
    }

    public DAO_LAB getDao() {
        return this.dao;
    }

    public void setDao(DAO_LAB dao) {
        this.dao = dao;
    }

    public List<Usuario> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<Usuario> usuarios) {
        Collections.sort(usuarios, Usuario.getComparador());
        this.usuarios = usuarios;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPersistence() {
        return this.persistence;
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public int getAnalises() {
        return this.analises;
    }

    public void setAnalises(int analises) {
        this.analises = analises;
    }

    public boolean isAnalisesilimitadas() {
        return this.analisesilimitadas;
    }

    public void setAnalisesilimitadas(boolean analisesilimitadas) {
        this.analisesilimitadas = analisesilimitadas;
    }

    public String getBuckets3() {
        return this.buckets3;
    }

    public void setBuckets3(String buckets3) {
        this.buckets3 = buckets3;
    }

    public String getUrllogo() {
        return this.urllogo;
    }

    public void setUrllogo(String urllogo) {
        this.urllogo = urllogo;
    }

    public String getUrllogo_mini() {
        return this.urllogo_mini;
    }

    public void setUrllogo_mini(String urllogo_mini) {
        this.urllogo_mini = urllogo_mini;
    }

    public String getUrl_reports() {
        return this.url_reports;
    }

    public void setUrl_reports(String url_reports) {
        this.url_reports = url_reports;
    }

    public String getJasper_mapa_cachimbagem() {
        return this.jasper_mapa_cachimbagem;
    }

    public void setJasper_mapa_cachimbagem(String jasper_mapa_cachimbagem) {
        this.jasper_mapa_cachimbagem = jasper_mapa_cachimbagem;
    }

    public String getJasper_qtd_amostra_mapa_cachimbagem() {
        return this.jasper_qtd_amostra_mapa_cachimbagem;
    }

    public void setJasper_qtd_amostra_mapa_cachimbagem(String jasper_qtd_amostra_mapa_cachimbagem) {
        this.jasper_qtd_amostra_mapa_cachimbagem = jasper_qtd_amostra_mapa_cachimbagem;
    }

    public boolean isDestravarleituratodosanalistas() {
        return this.destravarleituratodosanalistas;
    }

    public void setDestravarleituratodosanalistas(boolean destravarleituratodosanalistas) {
        this.destravarleituratodosanalistas = destravarleituratodosanalistas;
    }

    public String getInterfacefundo() {
        return this.interfacefundo;
    }

    public void setInterfacefundo(String interfacefundo) {
        this.interfacefundo = interfacefundo;
    }

    public String getInterfaceloginlogo() {
        return this.interfaceloginlogo;
    }

    public void setInterfaceloginlogo(String interfaceloginlogo) {
        this.interfaceloginlogo = interfaceloginlogo;
    }

    public String getLaudomodelopadrao() {
        return this.laudomodelopadrao;
    }

    public void setLaudomodelopadrao(String laudomodelopadrao) {
        this.laudomodelopadrao = laudomodelopadrao;
    }

    public String getInterfacedashboardlogo() {
        return this.interfacedashboardlogo;
    }

    public void setInterfacedashboardlogo(String interfacedashboardlogo) {
        this.interfacedashboardlogo = interfacedashboardlogo;
    }

    public boolean isCodlab_ativo() {
        return this.codlab_ativo;
    }

    public void setCodlab_ativo(boolean codlab_ativo) {
        this.codlab_ativo = codlab_ativo;
    }

    public String getCodlab_nome() {
        return this.codlab_nome;
    }

    public void setCodlab_nome(String codlab_nome) {
        this.codlab_nome = codlab_nome;
    }

    public int getDbv() {
        return this.dbv;
    }

    public void setDbv(int dbv) {
        this.dbv = dbv;
    }

    public Date getDbvdata() {
        return this.dbvdata;
    }

    public void setDbvdata(Date dbvdata) {
        this.dbvdata = dbvdata;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getCnpjapi() {
        return this.cnpjapi;
    }

    public void setCnpjapi(String cnpjapi) {
        this.cnpjapi = cnpjapi;
    }

    public boolean isUloadlaudomanual() {
        return this.uloadlaudomanual;
    }

    public void setUloadlaudomanual(boolean uloadlaudomanual) {
        this.uloadlaudomanual = uloadlaudomanual;
    }

    public boolean isAprovacaofinanceiro() {
        return this.aprovacaofinanceiro;
    }

    public void setAprovacaofinanceiro(boolean aprovacaofinanceiro) {
        this.aprovacaofinanceiro = aprovacaofinanceiro;
    }

    public boolean isAtividadeevento() {
        return this.atividadeevento;
    }

    public void setAtividadeevento(boolean atividadeevento) {
        this.atividadeevento = atividadeevento;
    }

    public String getCeres2_versao() {
        return this.ceres2_versao;
    }

    public void setCeres2_versao(String ceres2_versao) {
        this.ceres2_versao = ceres2_versao;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getCeres2_logo() {
        return this.ceres2_logo;
    }

    public void setCeres2_logo(String ceres2_logo) {
        this.ceres2_logo = ceres2_logo;
    }

    public String getCeres2_logo_mini() {
        return this.ceres2_logo_mini;
    }

    public void setCeres2_logo_mini(String ceres2_logo_mini) {
        this.ceres2_logo_mini = ceres2_logo_mini;
    }

    public String getUrlheader() {
        return this.urlheader;
    }

    public void setUrlheader(String urlheader) {
        this.urlheader = urlheader;
    }
}

