/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.log;

import ceresonemodel.analise.Amostra;
import ceresonemodel.analise.Laudo;
import ceresonemodel.analise.Metodo;
import ceresonemodel.analise.PacotePreco;
import ceresonemodel.analise.Pedido;
import ceresonemodel.analise.Pedido_aditivo;
import ceresonemodel.analise.Rotina;
import ceresonemodel.analise.RotinaItem;
import ceresonemodel.cadastro.Pessoa;
import ceresonemodel.campos.AnaliseParametro;
import ceresonemodel.campos.CampoLancamentoAnaliseParametro;
import ceresonemodel.campos.CampoSupervisao;
import ceresonemodel.campos.MetodoParametro;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.fatura.Fatura;
import ceresonemodel.fatura.FaturaCaixaMovimento;
import ceresonemodel.fatura.FaturaParcela;
import ceresonemodel.log.Log;
import ceresonemodel.solucoes.Solucao;
import ceresonemodel.users.Usuario;
import ceresonemodel.utils.CampoData;
import ceresonemodel.utils.CampoMoeda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LogUtils {
    public static String LOGIN = "LOGIN";
    public static String PEDIDO = "PEDIDO";
    public static String AMOSTRA = "AMOSTRA";
    public static String FATURA = "FATURA";
    public static String PESSOA = "PESSOA";
    public static String CONFIG_ANALISE = "CONFIG_ANALISE";
    public static String AMOSTRA_EXCLUIDA = "AMOSTRA_EXCLUIDA";
    public static String CAIXA_MOVIMENTO_EXCLUIDO = "CAIXA_MOVIMENTO_EXCLUIDO";
    public static String SOLUCAO = "SOLUCAO";
    public static String ROTINA_METODO = "ROTINA_METODO";
    public static String ROTINA = "ROTINA";
    public static String AMOSTRA_LEITURA = "AMOSTRA_LEITURA";
    public static String LAUDO = "LAUDO";

    private static Log getLog(String usuario, DAO_LAB dao) throws Exception {
        Log log = new Log();
        log.setUsuario(usuario);
        log.setData(dao.func_server_time());
        log.setId(dao.getLogSeq());
        return log;
    }

    public static void login(String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setTipo(LOGIN);
            log.setLink("login=" + usuario);
            log.setLog("Login Usu\u00e1rio = <strong>" + usuario + "</strong>");
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logout(String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setTipo(LOGIN);
            log.setLink("login=" + usuario);
            log.setLog("Fechou o sistema (Logof) Usu\u00e1rio = <strong>" + usuario + "</strong>");
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void laudo_editar(Laudo laudo, List<CampoLancamentoAnaliseParametro> campos_laudo, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("laudo=" + laudo.getId());
            log.setTipo(LAUDO);
            String msg = "";
            msg = msg + "<strong> Laudo " + laudo.toString() + " editado! </strong>";
            if (campos_laudo != null) {
                msg = msg + LogUtils.getLogCampos("Campos complementares:", campos_laudo);
            }
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void laudo_cancelar(Laudo laudo, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("laudo=" + laudo.getId());
            log.setTipo(LAUDO);
            String msg = "";
            msg = msg + "<strong> Laudo " + laudo.toString() + " cancelado! </strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void laudo_subistituir(Laudo laudo, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("laudo=" + laudo.getId());
            log.setTipo(LAUDO);
            String msg = "";
            msg = msg + "<strong> Laudo " + laudo.toString() + " gerado! </strong>";
            msg = msg + "<br>Esse laudo subistitui o laudo " + laudo.getView_laudo_subistituido();
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void laudo_aprovar(Laudo laudo, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("laudo=" + laudo.getId());
            log.setTipo(LAUDO);
            String msg = "";
            msg = msg + "<strong> Laudo " + laudo.toString() + " aprovado! </strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void laudo_gerar(List<Laudo> laudos, List<Amostra> amostras, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            for (Laudo laudo : laudos) {
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("laudo=" + laudo.getId());
                log.setTipo(LAUDO);
                String msg = "";
                msg = msg + "<strong> Laudo " + laudo.toString() + " gerado! </strong>";
                msg = msg + "<br>An\u00e1lise: " + laudo.getView_analise_nome();
                msg = msg + "<br>Pedido: " + laudo.getView_pedido_numero_ano();
                msg = msg + ("<br>Data aprova\u00e7\u00e3o: " + laudo.getAprovacao() == null ? "N\u00e3o aprovado" : laudo.getAprovacao());
                msg = msg + "<br>Respons\u00e1vel: " + laudo.getView_responsavel_nome();
                if (amostras != null && !amostras.isEmpty()) {
                    msg = msg + "<br>Amostras: ";
                    for (Amostra amostra : amostras) {
                        msg = msg + amostra.toString() + " | ";
                    }
                }
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_incluir(Pedido pedido, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "";
            msg = msg + "<strong> Pedido " + pedido.toString() + " inclu\u00eddo! </strong>";
            msg = msg + "<br>An\u00e1lise: " + pedido.getView_analise_nome();
            msg = msg + "<br>Cliente: " + pedido.getView_cliente_nome();
            msg = msg + " | Solicitante: " + pedido.getView_solicitante_nome();
            msg = msg + " | Cobran\u00e7a: " + pedido.getView_cobranca_nome();
            msg = msg + "<br>Conv\u00eanio: " + pedido.getView_convenio_nome();
            msg = msg + "<br>Observas\u00e7\u00f5es: " + (pedido.getObservacao() == null ? "" : pedido.getObservacao());
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_alterar(Pedido pedido, List<Amostra> amostras, List<CampoLancamentoAnaliseParametro> lancamentos, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "";
            msg = msg + "<strong> Pedido " + pedido.toString() + " alterado! </strong>";
            msg = msg + "<br>An\u00e1lise: " + pedido.getView_analise_nome();
            msg = msg + "<br>Cliente: " + pedido.getView_cliente_nome();
            msg = msg + " | Solicitante: " + pedido.getView_solicitante_nome();
            msg = msg + " | Cobran\u00e7a: " + pedido.getView_cobranca_nome();
            msg = msg + "<br>Conv\u00eanio: " + pedido.getView_convenio_nome();
            msg = msg + "<br>Observas\u00e7\u00f5es: " + (pedido.getObservacao() == null ? "" : pedido.getObservacao());
            msg = msg + "<br>Entrada: " + pedido.getEntrada();
            msg = msg + "<br>Emiss\u00e3o: " + pedido.getEmissao();
            msg = msg + "<br>Previs\u00e3o: " + pedido.getPrevisao();
            msg = msg + "<br>Aprova\u00e7\u00e3o: " + pedido.getLiberadolab();
            msg = msg + "<br>Gera\u00e7\u00e3o: " + pedido.getGeracao();
            int numAmostras = 0;
            int numAmostrasCanceladas = 0;
            for (Amostra am : amostras) {
                if (am.getCancelamento() == null) {
                    ++numAmostras;
                    continue;
                }
                ++numAmostrasCanceladas;
            }
            msg = msg + "<br>N\u00ba de amostras: " + numAmostras;
            msg = msg + "<br>N\u00ba de amostras canceladas: " + numAmostrasCanceladas;
            msg = msg + "<br>Frete: " + CampoMoeda.floatToMoeda(pedido.getFrete());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(pedido.getDesconto());
            msg = msg + " | Valor Bruto: " + CampoMoeda.floatToMoeda(pedido.getValorbruto());
            msg = msg + " | Valor Total: " + CampoMoeda.floatToMoeda(pedido.getValor());
            msg = msg + "<br>Propriedade: " + (pedido.getView_fazenda_nome() == null ? "" : pedido.getView_fazenda_nome());
            msg = msg + " | Propriet\u00e1rio: " + (pedido.getView_fazenda_proprietario() == null ? "" : pedido.getView_fazenda_proprietario());
            msg = msg + "<br>Cultura: " + (pedido.getView_cultura_nome() == null ? "" : pedido.getView_cultura_nome());
            if (lancamentos != null) {
                msg = msg + LogUtils.getLogCampos("Campos adicionais:", lancamentos);
            }
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_aprovar(Pedido pedido, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "Pedido APROVADO = <strong>" + pedido.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_desaprovar(Pedido pedido, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "Pedido DESAPROVADO = <strong>" + pedido.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_cancelar(Pedido pedido, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "Pedido CANCELADO = <strong>" + pedido.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_atualiza_valor(Pedido pedido, List<Amostra> amostras, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "";
            msg = msg + "<strong> Pedido " + pedido.toString() + " alterado! </strong>";
            msg = msg + "<br>An\u00e1lise: " + pedido.getView_analise_nome();
            msg = msg + "<br>Conv\u00eanio: " + pedido.getView_convenio_nome();
            int numAmostras = 0;
            int numAmostrasCanceladas = 0;
            for (Amostra am : amostras) {
                if (am.getCancelamento() == null) {
                    ++numAmostras;
                    continue;
                }
                ++numAmostrasCanceladas;
            }
            msg = msg + "<br>N\u00ba de amostras: " + numAmostras;
            msg = msg + "<br>N\u00ba de amostras canceladas: " + numAmostrasCanceladas;
            msg = msg + "<br>Frete: " + CampoMoeda.floatToMoeda(pedido.getFrete());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(pedido.getDesconto());
            msg = msg + " | Bruto: " + CampoMoeda.floatToMoeda(pedido.getValorbruto());
            msg = msg + " | Total: " + CampoMoeda.floatToMoeda(pedido.getValor());
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_alterar_convenio(Pedido pedido, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(PEDIDO);
            String msg = "";
            msg = msg + "<strong> Pedido " + pedido.toString() + " conv\u00eanio alterado! </strong>";
            msg = msg + "<br>Conv\u00eanio: " + pedido.getView_convenio_nome();
            msg = msg + "<br>Frete: " + CampoMoeda.floatToMoeda(pedido.getFrete());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(pedido.getDesconto());
            msg = msg + " | Valor Bruto: " + CampoMoeda.floatToMoeda(pedido.getValorbruto());
            msg = msg + " | Valor Total: " + CampoMoeda.floatToMoeda(pedido.getValor());
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pedido_desbloquear_edicao(Pedido pedido, String usuario, DAO_LAB dao, Usuario admin) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pedido=" + pedido.getId());
            log.setTipo(FATURA);
            String msg = "Pedido DESBLOQUEADO para edi\u00e7\u00e3o = <strong>" + pedido.toString() + "</strong>";
            msg = msg + "<br>Aprova\u00e7\u00e3o do Administrador: <strong>" + admin.getLogin() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostra_incluir(Amostra amostra, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("amostra=" + amostra.getId());
            log.setTipo(AMOSTRA);
            String msg = "";
            msg = msg + "<strong> Amostra " + amostra.toString() + " inclu\u00edda! </strong>";
            msg = msg + "<br>An\u00e1lise: " + amostra.getView_analise_nome();
            msg = msg + "<br>Tipo de an\u00e1lise: " + amostra.getView_tipo_analise();
            msg = msg + "<br>Valor: " + amostra.getValor();
            msg = msg + "<br>Descri\u00e7\u00e3o: " + amostra.getDescricao();
            msg = msg + "<br>Profundidade: " + amostra.getView_profundidade_nome();
            msg = msg + "<br>Talh\u00e3o: " + amostra.getView_talhao_nome();
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostras_alterar(List<Amostra> amostras, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            for (Amostra amostra : amostras) {
                if (!amostra.isEditado()) continue;
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("amostra=" + amostra.getId());
                log.setTipo(AMOSTRA);
                String msg = "";
                msg = msg + "<strong> Amostra " + amostra.toString() + " alterada! </strong>";
                msg = msg + "<br>An\u00e1lise: " + amostra.getView_analise_nome();
                msg = msg + "<br>Tipo de an\u00e1lise: " + amostra.getView_tipo_analise();
                msg = msg + "<br>Valor: " + amostra.getValor();
                msg = msg + "<br>Descri\u00e7\u00e3o: " + amostra.getDescricao();
                msg = msg + "<br>Profundidade: " + amostra.getView_profundidade_nome();
                msg = msg + "<br>Talh\u00e3o: " + amostra.getView_talhao_nome();
                List<CampoLancamentoAnaliseParametro> lancamentos = amostra.getCamposLancamentoAnaliseParametro();
                if (lancamentos != null) {
                    msg = msg + LogUtils.getLogCampos("Campos complementares:", lancamentos);
                }
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostras_aprovar(List<Amostra> amostras, List<MetodoParametro> metodoParametros, List<AnaliseParametro> analiseParametros, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            for (Amostra amostra : amostras) {
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("amostra=" + amostra.getId());
                log.setTipo(AMOSTRA);
                String msg = "";
                msg = msg + "<strong> Amostra " + amostra.toString() + " aprovada na supervis\u00e3o! </strong>";
                msg = msg + LogUtils.getLogCamposSupervisao(amostra, metodoParametros, analiseParametros);
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostras_desaprovar(List<Amostra> amostras, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            for (Amostra amostra : amostras) {
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("amostra=" + amostra.getId());
                log.setTipo(AMOSTRA);
                String msg = "";
                msg = msg + "<strong> Amostra " + amostra.toString() + " desaprovada na supervis\u00e3o! </strong>";
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostra_leitura_alterar(List<CampoLancamentoAnaliseParametro> leituras, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            ArrayList<CampoLancamentoAnaliseParametro> campos_logs = new ArrayList<CampoLancamentoAnaliseParametro>();
            ArrayList<Long> amostras_id = new ArrayList<Long>();
            for (CampoLancamentoAnaliseParametro campo : leituras) {
                if (!campo.isEditado()) continue;
                campos_logs.add(campo);
                if (amostras_id.contains(campo.getView_filtro_id())) continue;
                amostras_id.add(campo.getView_filtro_id());
            }
            if (campos_logs.isEmpty()) {
                return;
            }
            String query = "view_amostra";
            String or = "or=(";
            for (Long amostra : amostras_id) {
                or = or + (or.equals("or=(") ? "" : ",");
                or = or + "id.eq." + amostra;
            }
            or = or + ")";
            query = query + "?" + or;
            List<Amostra> amostras = Arrays.asList((Amostra[])dao.listObject(Amostra[].class, query));
            Map<String, List<CampoLancamentoAnaliseParametro>> agrupados = campos_logs.stream().collect(Collectors.groupingBy(item -> item.getView_filtro() + "-" + item.getView_filtro_id()));
            for (Map.Entry<String, List<CampoLancamentoAnaliseParametro>> entry : agrupados.entrySet()) {
                String chave = entry.getKey();
                List<CampoLancamentoAnaliseParametro> grupo = entry.getValue();
                Amostra amostra = null;
                for (Amostra am : amostras) {
                    if (am.getId() != grupo.get(0).getView_filtro_id()) continue;
                    amostra = am;
                }
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("amostra_leitura=" + chave);
                log.setTipo(AMOSTRA_LEITURA);
                String msg = "Amostra LEITURAS ALTERADAS = <strong>" + amostra.toString() + (amostra.getAmostracontrole() == null ? "</strong>" : "*(" + amostra.getView_amostracontrole_nome()) + ")</strong>";
                msg = msg + LogUtils.getLogCampos("Campos:", grupo);
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pessoa_alterar(Pessoa pessoa, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pessoa=" + pessoa.getId());
            log.setTipo(PESSOA);
            String msg = "Pessoa ALTERADA = <strong>'" + usuario + "'</strong> alterou <strong>'" + pessoa.getNome() + "'</strong>";
            msg = msg + " | Pais: " + (pessoa.getPais() == null ? "" : pessoa.getPais());
            msg = msg + " | Tipo pessoa: " + (pessoa.getTipo() == null ? "" : pessoa.getTipo());
            msg = msg + " | CPF/CNJP: " + pessoa.getView_pessoa_cpf_cnpj();
            msg = msg + " | E-Mail: " + pessoa.getEmail();
            msg = msg + " | Cidade: " + (pessoa.getView_cidade_nome() == null ? "" : pessoa.getView_cidade_nome());
            msg = msg + " | Conv\u00eanio: " + (pessoa.getView_convenio_nome() == null ? "" : pessoa.getView_convenio_nome());
            msg = msg + " | Bloqueado: " + (pessoa.isBloqueado() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo fornecedor: " + (pessoa.isFornecedor() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo cliente: " + (pessoa.isCliente() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo cobran\u00e7a: " + (pessoa.isCobranca() ? "Sim" : "N\u00e3o");
            msg = msg + " | Enviar E-Mail: " + (pessoa.isEnviaremail() ? "Sim" : "N\u00e3o");
            msg = msg + " | DataCeres Padr\u00e3o: " + (pessoa.isDataceres_padrao() ? "Sim" : "N\u00e3o");
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pacotepreco_excluir(PacotePreco pacotePreco, String msg, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pacotepreco=" + pacotePreco.getId());
            log.setTipo(CONFIG_ANALISE);
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pessoa_incluir(Pessoa pessoa, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("pessoa=" + pessoa.getId());
            log.setTipo(PESSOA);
            String msg = "Pessoa INCLU\u00cdDA = <strong>'" + usuario + "'</strong> inclu\u00edu <strong>'" + pessoa.getNome() + "'</strong>";
            msg = msg + " | Pais: " + (pessoa.getPais() == null ? "" : pessoa.getPais());
            msg = msg + " | Tipo pessoa: " + (pessoa.getTipo() == null ? "" : pessoa.getTipo());
            msg = msg + " | CPF/CNJP: " + pessoa.getView_pessoa_cpf_cnpj();
            msg = msg + " | E-Mail: " + pessoa.getEmail();
            msg = msg + " | Cidade: " + (pessoa.getView_cidade_nome() == null ? "" : pessoa.getView_cidade_nome());
            msg = msg + " | Conv\u00eanio: " + (pessoa.getView_convenio_nome() == null ? "" : pessoa.getView_convenio_nome());
            msg = msg + " | Bloqueado: " + (pessoa.isBloqueado() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo fornecedor: " + (pessoa.isFornecedor() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo cliente: " + (pessoa.isCliente() ? "Sim" : "N\u00e3o");
            msg = msg + " | Tipo cobran\u00e7a: " + (pessoa.isCobranca() ? "Sim" : "N\u00e3o");
            msg = msg + " | Enviar E-Mail: " + (pessoa.isEnviaremail() ? "Sim" : "N\u00e3o");
            msg = msg + " | DataCeres Padr\u00e3o: " + (pessoa.isDataceres_padrao() ? "Sim" : "N\u00e3o");
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void faturaCaixaMovimento_excluir(FaturaCaixaMovimento movimento, String usuario, Usuario admin, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("faturacaixamovimento=" + movimento.getId());
            log.setTipo(CAIXA_MOVIMENTO_EXCLUIDO);
            String msg = "CaixaMovimento EXCLU\u00cdDO = <strong>'" + usuario + "'</strong> exclu\u00edu <strong>'" + movimento.getDescricao() + "'</strong> :";
            msg = msg + "<br> Valor: " + movimento.getValor();
            msg = msg + "<br> Caixa: " + movimento.getView_faturacaixatipo_nome();
            msg = msg + "<br> Usu\u00e1rio: " + admin.getLogin();
            if (movimento.getView_fatura_id() != null) {
                msg = msg + "<br> Fatura: " + movimento.getView_fatura_numero_ano();
            }
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostra_alterar(Amostra amostra, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("amostra=" + amostra.getId());
            log.setTipo(AMOSTRA);
            String msg = "Amostra ALTERADA = <strong>" + amostra.toString() + "</strong>";
            msg = msg + " | An\u00e1lise: " + amostra.getView_analise_nome();
            msg = msg + "<br>Tipo An\u00e1lise: " + amostra.getView_tipo_analise();
            msg = msg + "<br>Valor: " + CampoMoeda.floatToMoeda(amostra.getValor());
            msg = msg + "<br>Descri\u00e7\u00e3o: " + (amostra.getDescricao() == null ? "" : amostra.getDescricao());
            msg = msg + "<br>Profundidade: " + (amostra.getView_profundidade_nome() == null ? "" : amostra.getView_profundidade_nome());
            msg = msg + "<br>Talh\u00e3o: " + (amostra.getView_talhao_nome() == null ? "" : amostra.getView_talhao_nome());
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostra_cancelar(Amostra amostra, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("amostra=" + amostra.getId());
            log.setTipo(AMOSTRA);
            String msg = "Amostra CANCELADA = <strong>" + amostra.toString() + "</strong>";
            msg = msg + " | An\u00e1lise: " + amostra.getView_analise_nome();
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void amostra_tipo_analise(List<Amostra> amostras, List<Metodo> metodos, String usuario, DAO_LAB dao) {
        try {
            String query = "view_amostra";
            if (amostras.isEmpty()) {
                return;
            }
            String or = "or=(";
            for (Amostra amostra : amostras) {
                or = or + (or.equals("or=(") ? "" : ",");
                or = or + "id.eq." + amostra.getId();
            }
            or = or + ")";
            query = query + "?" + or;
            query = query + "&order=id";
            amostras = Arrays.asList((Amostra[])dao.listObject(Amostra[].class, query));
            String log_metodos = "<br>M\u00e9todos:<ul>";
            for (Metodo metodo : metodos) {
                log_metodos = log_metodos + " <li>" + metodo.getView_determinacao_nome() + " | " + metodo.getDescricao() + "</li>";
            }
            log_metodos = log_metodos + "</ul>";
            ArrayList<Object> logs = new ArrayList<Object>();
            for (Amostra amostra : amostras) {
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("amostra=" + amostra.getId());
                log.setTipo(AMOSTRA);
                String msg = "Amostra TIPO DE AN\u00c1LISE ALTERADA = <strong>" + amostra.toString() + "</strong>";
                msg = msg + " | An\u00e1lise: " + amostra.getView_analise_nome();
                msg = msg + "<br>Tipo An\u00e1lise: " + amostra.getView_tipo_analise();
                msg = msg + "<br>Valor: " + CampoMoeda.floatToMoeda(amostra.getValor());
                msg = msg + log_metodos;
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotina_incluir(Rotina rotina, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("rotina=" + rotina.getId());
            log.setTipo(ROTINA);
            String msg = "Rotina INCLUIDA = <strong>" + rotina.toString() + "</strong>";
            msg = msg + " | An\u00e1lise: " + rotina.getView_analise_nome();
            msg = msg + "<br>Data: " + CampoData.dataToString(rotina.getRotina_data());
            msg = msg + "<br>Descri\u00e7\u00e3o: " + (rotina.getDescricao() != null ? rotina.getDescricao() : "");
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotina_gerar(Rotina rotina, String usuario, DAO_LAB dao) {
        try {
            List<RotinaItem> ris = Arrays.asList((RotinaItem[])dao.listObject(RotinaItem[].class, "view_rotinaitem?rotina=eq." + rotina.getId()));
            rotina.loadResumo(dao, ris);
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("rotina=" + rotina.getId());
            log.setTipo(ROTINA);
            String msg = "Rotina GERADA = <strong>" + rotina.toString() + "</strong>";
            msg = msg + " | An\u00e1lise: " + rotina.getView_analise_nome();
            msg = msg + "<br>Descri\u00e7\u00e3o: " + (rotina.getDescricao() != null ? rotina.getDescricao() : "");
            msg = msg + "<hr>" + rotina.getResumo().replace("\n", "<br>") + "<hr>";
            log.setLog(msg);
            dao.includeObject(log, "log");
            LogUtils.rotinaitem_incluir(ris, usuario, dao);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotinaitem_incluir(List<RotinaItem> ris, String usuario, DAO_LAB dao) {
        try {
            ArrayList<Object> logs = new ArrayList<Object>();
            for (RotinaItem rotina_item : ris) {
                Log log = LogUtils.getLog(usuario, dao);
                log.setLink("rotinaitem=" + rotina_item.getId());
                log.setTipo(ROTINA_METODO);
                String msg = "M\u00e9todo da Rotina  INCLUIDO = <strong>" + rotina_item.toString() + "</strong>";
                msg = msg + " | An\u00e1lise: " + rotina_item.getView_analise_nome();
                msg = msg + "<br>Analista padr\u00e3o: " + (rotina_item.getView_analista_padrao() == null ? "" : rotina_item.getView_analista_padrao());
                msg = msg + "<br>Data: " + CampoData.dataToString(rotina_item.getData());
                log.setLog(msg);
                logs.add(log);
            }
            dao.includeObjects(logs, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotinaitem_alterar(RotinaItem rotina_item, String usuario, List<CampoLancamentoAnaliseParametro> lancamentos, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("rotinaitem=" + rotina_item.getId());
            log.setTipo(ROTINA_METODO);
            String msg = "M\u00e9todo da Rotina  ALTERADO = <strong>" + rotina_item.toString() + "</strong>";
            msg = msg + " | An\u00e1lise: " + rotina_item.getView_analise_nome();
            msg = msg + "<br>Analista: " + (rotina_item.getAnalista() == null ? "" : rotina_item.getAnalista());
            msg = msg + "<br>Data: " + CampoData.dataToString(rotina_item.getData());
            msg = msg + LogUtils.getLogCampos("Campos complementares:", lancamentos);
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotinaitem_aprovar(RotinaItem rotina_item, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("rotinaitem=" + rotina_item.getId());
            log.setTipo(ROTINA_METODO);
            String msg = "M\u00e9todo da Rotina APROVADO = <strong>" + rotina_item.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
            Rotina rotina = Rotina.carregaRotina(rotina_item.getRotina(), dao);
            if (rotina != null && rotina.getData_aprovacao() != null) {
                Log log_rotina = LogUtils.getLog(usuario, dao);
                log_rotina.setLink("rotina=" + rotina.getId());
                log_rotina.setTipo(ROTINA);
                String msg_rotina = "Rotina APROVADA = <strong>" + rotina_item.toString() + "</strong>";
                msg_rotina = msg_rotina + "<br>Todos os m\u00e9todos foram aprovados.";
                log_rotina.setLog(msg_rotina);
                dao.includeObject(log_rotina, "log");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rotinaitem_desaprovar(RotinaItem rotina_item, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("rotinaitem=" + rotina_item.getId());
            log.setTipo(ROTINA_METODO);
            String msg = "M\u00e9todo da Rotina DESAPROVADO = <strong>" + rotina_item.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
            Rotina rotina = Rotina.carregaRotina(rotina_item.getRotina(), dao);
            if (rotina != null && rotina.getData_aprovacao() == null) {
                Log log_rotina = LogUtils.getLog(usuario, dao);
                log_rotina.setLink("rotina=" + rotina.getId());
                log_rotina.setTipo(ROTINA);
                String msg_rotina = "Rotina DESAPROVADA = <strong>" + rotina_item.toString() + "</strong>";
                msg_rotina = msg_rotina + "<br>M\u00e9todo foi desaprovado: " + rotina_item.getView_metodo_nome();
                log_rotina.setLog(msg_rotina);
                dao.includeObject(log_rotina, "log");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_incluir(Fatura fatura, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura INCLU\u00cdDA = <strong>" + fatura.toString() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_cancelar(Fatura fatura, String usuario, DAO_LAB dao, Usuario admin) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura CANCELADA = <strong>" + fatura.toString() + "</strong>";
            msg = msg + "<br>Aprova\u00e7\u00e3o do Administrador: <strong>" + admin.getLogin() + "</strong>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_alterar(Fatura fatura, String usuario, List<Pedido> pedidos, List<FaturaParcela> parcelas, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura ALTERADA = <strong>" + fatura.toString() + "</strong>";
            msg = msg + "<br>Valores: Bruto: " + CampoMoeda.floatToMoeda(fatura.getValorbruto());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(fatura.getDesconto());
            msg = msg + " | L\u00edquido: " + CampoMoeda.floatToMoeda(fatura.getValorliquido());
            msg = msg + " | Saldo devedor: " + CampoMoeda.floatToMoeda(fatura.getSaldodevedor());
            msg = msg + " | Valor pago: " + CampoMoeda.floatToMoeda(fatura.getValorpago());
            msg = msg + "<br>Datas: Emiss\u00e3o: " + CampoData.dataToString(fatura.getData());
            msg = msg + " | Data pagamento: " + CampoData.dataToString(fatura.getDatapagamento());
            msg = msg + "<br>Observa\u00e7\u00f5es: " + (fatura.getObservacao() == null ? "" : fatura.getObservacao());
            msg = msg + "<br>Pedido(s) " + (pedidos != null ? Integer.valueOf(pedidos.size()) : "0") + ":";
            msg = msg + "<br>Parcelas(s) " + (parcelas != null ? Integer.valueOf(parcelas.size()) : "0") + ":";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_alterar_pedidos(Fatura fatura, String usuario, List<Pedido> pedidos, List<Pedido_aditivo> aditivos, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura PEDIDOS ALTERADOS = <strong>" + fatura.toString() + "</strong>";
            msg = msg + "<br>Valores: Bruto: " + CampoMoeda.floatToMoeda(fatura.getValorbruto());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(fatura.getDesconto());
            msg = msg + " | L\u00edquido: " + CampoMoeda.floatToMoeda(fatura.getValorliquido());
            msg = msg + " | Saldo devedor: " + CampoMoeda.floatToMoeda(fatura.getSaldodevedor());
            msg = msg + " | Valor pago: " + CampoMoeda.floatToMoeda(fatura.getValorpago());
            msg = msg + "<br>Datas: Emiss\u00e3o: " + CampoData.dataToString(fatura.getData());
            msg = msg + " | Data pagamento: " + CampoData.dataToString(fatura.getDatapagamento());
            msg = msg + "<br>Observa\u00e7\u00f5es: " + (fatura.getObservacao() == null ? "" : fatura.getObservacao());
            msg = msg + "<br>Pedido(s) " + (pedidos != null ? Integer.valueOf(pedidos.size()) : "0") + ":";
            if (pedidos != null) {
                for (Pedido pedido : pedidos) {
                    msg = msg + "<br>Pedido: " + pedido.toString();
                    msg = msg + " | An\u00e1lise: " + pedido.getView_analise_nome();
                    msg = msg + " | Cliente: " + pedido.getView_cliente_nome();
                    msg = msg + "<br>Conv\u00eanio: " + pedido.getView_convenio_nome();
                    msg = msg + "<br>Frete: " + CampoMoeda.floatToMoeda(pedido.getFrete());
                    msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(pedido.getDesconto());
                    msg = msg + " | Valor Bruto: " + CampoMoeda.floatToMoeda(pedido.getValorbruto());
                    msg = msg + " | Valor Total: " + CampoMoeda.floatToMoeda(pedido.getValor());
                    msg = msg + "<br>Propriedade: " + pedido.getView_fazenda_nome();
                    msg = msg + " | Propriet\u00e1rio: " + pedido.getView_fazenda_proprietario();
                    msg = msg + "<hr>";
                }
            }
            msg = msg + "<br>Aditivos(s) " + (aditivos != null ? Integer.valueOf(aditivos.size()) : "0") + ":";
            if (aditivos != null) {
                for (Pedido_aditivo pedido_aditivo : aditivos) {
                    msg = msg + "<br>Aditivo: " + pedido_aditivo.toString();
                    msg = msg + " | An\u00e1lise: " + pedido_aditivo.getView_analise_nome();
                    msg = msg + " | Cliente: " + pedido_aditivo.getView_cliente_nome();
                    msg = msg + "<br>Conv\u00eanio: " + pedido_aditivo.getView_convenio_nome();
                    msg = msg + " | Valor Total: " + CampoMoeda.floatToMoeda(pedido_aditivo.getValor());
                    msg = msg + "<br>Propriedade: " + pedido_aditivo.getView_fazenda_nome();
                    msg = msg + " | Propriet\u00e1rio: " + pedido_aditivo.getView_fazenda_proprietario();
                    msg = msg + "<hr>";
                }
            }
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_alterar_parcelas(Fatura fatura, String usuario, List<FaturaParcela> parcelas, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura PARCELAS ALTERADAS = <strong>" + fatura.toString() + "</strong>";
            msg = msg + "<br>Valores: Bruto: " + CampoMoeda.floatToMoeda(fatura.getValorbruto());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(fatura.getDesconto());
            msg = msg + " | L\u00edquido: " + CampoMoeda.floatToMoeda(fatura.getValorliquido());
            msg = msg + " | Saldo devedor: " + CampoMoeda.floatToMoeda(fatura.getSaldodevedor());
            msg = msg + " | Valor pago: " + CampoMoeda.floatToMoeda(fatura.getValorpago());
            msg = msg + "<br>Datas: Emiss\u00e3o: " + CampoData.dataToString(fatura.getData());
            msg = msg + " | Data pagamento: " + CampoData.dataToString(fatura.getDatapagamento());
            msg = msg + "<br>Observa\u00e7\u00f5es: " + (fatura.getObservacao() == null ? "" : fatura.getObservacao());
            msg = msg + "<br>Parcelas(s) " + (parcelas != null ? Integer.valueOf(parcelas.size()) : "0") + ":";
            if (parcelas != null) {
                for (FaturaParcela parcela : parcelas) {
                    msg = msg + "Parcela " + parcela.getNumeroparcela();
                    msg = msg + " | Vencimento: " + CampoData.dataToString(parcela.getDatavencimento());
                    msg = msg + " | Pagamento: " + CampoData.dataToString(parcela.getDatapagamento());
                    msg = msg + " | Valor: " + CampoMoeda.floatToMoeda(parcela.getValor());
                    msg = msg + " | Valor pago: " + CampoMoeda.floatToMoeda(parcela.getValor_pgt());
                    msg = msg + "<br>Boleto : " + (parcela.getView_boletoconfig_api() == null ? "" : parcela.getView_boletoconfig_api());
                    msg = msg + " | ID: " + (parcela.getBoletoid() == null ? "" : parcela.getBoletoid());
                    msg = msg + "<hr>";
                }
            }
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fatura_add_log_api(Fatura fatura, String usuario, List<Pedido> pedidos, List<FaturaParcela> parcelas, DAO_LAB dao, String log_api) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("fatura=" + fatura.getId());
            log.setTipo(FATURA);
            String msg = "Fatura LOG INTEGA\u00c7\u00d5ES (API) = <strong>" + fatura.toString() + "</strong>";
            msg = msg + "<br>Valores: Bruto: " + CampoMoeda.floatToMoeda(fatura.getValorbruto());
            msg = msg + " | Desconto: " + CampoMoeda.floatToMoeda(fatura.getDesconto());
            msg = msg + " | L\u00edquido: " + CampoMoeda.floatToMoeda(fatura.getValorliquido());
            msg = msg + " | Saldo devedor: " + CampoMoeda.floatToMoeda(fatura.getSaldodevedor());
            msg = msg + " | Valor pago: " + CampoMoeda.floatToMoeda(fatura.getValorpago());
            msg = msg + "<br>Datas: Emiss\u00e3o: " + CampoData.dataToString(fatura.getData());
            msg = msg + " | Data pagamento: " + CampoData.dataToString(fatura.getDatapagamento());
            msg = msg + "<br>Observa\u00e7\u00f5es: " + (fatura.getObservacao() == null ? "" : fatura.getObservacao());
            msg = msg + "<br>Pedido(s) " + (pedidos != null ? Integer.valueOf(pedidos.size()) : "0") + ":";
            msg = msg + "<br>Parcelas(s) " + (parcelas != null ? Integer.valueOf(parcelas.size()) : "0") + ":";
            msg = msg + "<hr>";
            msg = msg + "LOG:<br>" + log_api;
            msg = msg + "<hr>";
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void solucao_incluir(Solucao solucao, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("solucao=" + solucao.getId());
            log.setTipo(SOLUCAO);
            String msg = "Solu\u00e7\u00e3o INCLU\u00cdDA = <strong>" + solucao.toString() + "</strong>";
            msg = msg + "<br>Tipo: " + solucao.getView_solucaotipo_descricao();
            msg = msg + "<br>Cria\u00e7\u00e3o: " + CampoData.dataToString(solucao.getCriacao());
            msg = msg + "<br>Validade: " + CampoData.dataToString(solucao.getValidade());
            msg = msg + "<br>Observas\u00e7\u00f5es: " + (solucao.getObservacao() == null ? "" : solucao.getObservacao());
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void solucao_alterar(Solucao solucao, List<CampoLancamentoAnaliseParametro> lancamentos, String usuario, DAO_LAB dao) {
        try {
            Log log = LogUtils.getLog(usuario, dao);
            log.setLink("solucao=" + solucao.getId());
            log.setTipo(SOLUCAO);
            String msg = "Solu\u00e7\u00e3o ALTERADA = <strong>" + solucao.toString() + "</strong>";
            msg = msg + "<br>Tipo: " + solucao.getView_solucaotipo_descricao();
            msg = msg + "<br>Cria\u00e7\u00e3o: " + CampoData.dataToString(solucao.getCriacao());
            msg = msg + "<br>Validade: " + CampoData.dataToString(solucao.getValidade());
            msg = msg + "<br>Situa\u00e7\u00e3o: " + solucao.getSituacao();
            msg = msg + "<br>T\u00e9rmino: " + CampoData.dataToString(solucao.getTermino());
            msg = msg + "<br>Observas\u00e7\u00f5es: " + (solucao.getObservacao() == null ? "" : solucao.getObservacao());
            msg = msg + LogUtils.getLogCampos("Lan\u00e7amentos da Solu\u00e7\u00e3o:", lancamentos);
            log.setLog(msg);
            dao.includeObject(log, "log");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getLogCampos(String titulo_lancamentos, List<CampoLancamentoAnaliseParametro> lancamentos) {
        String saida = "";
        if (lancamentos == null) {
            return "";
        }
        for (CampoLancamentoAnaliseParametro lancamento : lancamentos) {
            saida = saida + (saida.equals("") ? "" : "<br>");
            saida = saida + lancamento.getView_parametro_nome() + ": " + (lancamento.getValor() != null ? "<strong>" + lancamento.getValor() + "</strong>" : "");
        }
        return saida.equals("") ? "" : "<br>" + titulo_lancamentos + "<hr>" + saida + "<hr>";
    }

    private static String getLogCamposSupervisao(Amostra amostra, List<MetodoParametro> metodoParametros, List<AnaliseParametro> analiseParametros) {
        String saida = "<hr>Resultados:";
        List<CampoSupervisao> lancamentos = amostra.getCamposSupervisao();
        if (lancamentos == null) {
            return "";
        }
        ArrayList<CampoSupervisao> valores = new ArrayList<CampoSupervisao>();
        ArrayList<CampoSupervisao> relacoes = new ArrayList<CampoSupervisao>();
        for (CampoSupervisao lancamento : lancamentos) {
            if (lancamento.isRelacao()) {
                relacoes.add(lancamento);
                continue;
            }
            if (!lancamento.isResultado()) continue;
            valores.add(lancamento);
        }
        for (CampoSupervisao lancamento : valores) {
            MetodoParametro mp = null;
            for (MetodoParametro metodoParametro : metodoParametros) {
                if (metodoParametro.getCampoconfiguracao().longValue() != lancamento.getCampoconfiguracao().longValue()) continue;
                mp = metodoParametro;
                break;
            }
            saida = saida + "<br>";
            saida = saida + mp.label() + ": <strong>" + amostra.getValorCampoSupervisao(lancamento.getCampoconfiguracao()) + "</strong>";
        }
        if (!relacoes.isEmpty()) {
            saida = saida + "<hr>Rela\u00e7\u00f5es:";
            for (CampoSupervisao lancamento : relacoes) {
                AnaliseParametro ap = null;
                for (AnaliseParametro analiseParametro : analiseParametros) {
                    if (analiseParametro.getCampoconfiguracao().longValue() != lancamento.getCampoconfiguracao().longValue()) continue;
                    ap = analiseParametro;
                    break;
                }
                saida = saida + "<br>";
                saida = saida + ap.toString() + ": <strong>" + amostra.getValorCampoSupervisao(lancamento.getCampoconfiguracao()) + "</strong>";
            }
        }
        return saida.equals("") ? "" : saida + "<hr>";
    }
}

