/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.log;

import ceresonemodel.analise.Amostra;
import ceresonemodel.analise.Laudo;
import ceresonemodel.analise.PacotePreco;
import ceresonemodel.analise.Pedido;
import ceresonemodel.analise.Rotina;
import ceresonemodel.analise.RotinaItem;
import ceresonemodel.cadastro.Pessoa;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.fatura.Fatura;
import ceresonemodel.fatura.FaturaCaixaMovimento;
import ceresonemodel.log.Log;
import ceresonemodel.log.LogUtils;
import ceresonemodel.solucoes.Solucao;
import ceresonemodel.users.Usuario;
import ceresonemodel.utils.FormatadorHTML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LogLoader {
    public static List<Log> get(Object source, DAO_LAB dao) throws Exception {
        String query = "log";
        if (Usuario.class.isInstance(source)) {
            Usuario x = (Usuario)source;
            String pesquisa = FormatadorHTML.urlEncode("login=" + x.getLogin());
            query = query + "?link=eq." + pesquisa;
        } else if (Pedido.class.isInstance(source)) {
            Pedido x = (Pedido)source;
            String pesquisa = FormatadorHTML.urlEncode("pedido=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (Amostra.class.isInstance(source)) {
            Amostra x = (Amostra)source;
            String pesquisa = FormatadorHTML.urlEncode("amostra=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (Pessoa.class.isInstance(source)) {
            Pessoa x = (Pessoa)source;
            String pesquisa = FormatadorHTML.urlEncode("pessoa=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (PacotePreco.class.isInstance(source)) {
            PacotePreco x = (PacotePreco)source;
            String pesquisa = FormatadorHTML.urlEncode("pacotepreco=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (FaturaCaixaMovimento.class.isInstance(source)) {
            FaturaCaixaMovimento x = (FaturaCaixaMovimento)source;
            String pesquisa = FormatadorHTML.urlEncode("faturacaixamovimento=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (Rotina.class.isInstance(source)) {
            Rotina x = (Rotina)source;
            String pesquisa = FormatadorHTML.urlEncode("rotina=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (RotinaItem.class.isInstance(source)) {
            RotinaItem x = (RotinaItem)source;
            String pesquisa = FormatadorHTML.urlEncode("rotinaitem=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (Fatura.class.isInstance(source)) {
            Fatura x = (Fatura)source;
            String pesquisa = FormatadorHTML.urlEncode("fatura=" + x.getId());
            query = query + "?" + pesquisa;
        } else if (Solucao.class.isInstance(source)) {
            Solucao x = (Solucao)source;
            String pesquisa = FormatadorHTML.urlEncode("solucao=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else if (Laudo.class.isInstance(source)) {
            Laudo x = (Laudo)source;
            String pesquisa = FormatadorHTML.urlEncode("laudo=" + x.getId());
            query = query + "?link=eq." + pesquisa;
        } else {
            return new ArrayList<Log>();
        }
        query = query + "&order=data";
        return Arrays.asList((Log[])dao.listObject(Log[].class, query));
    }

    public static List<Log> getAmostraLeituras(Long amostra, long rotinaitem, DAO_LAB dao) throws Exception {
        String query = "log?tipo=eq." + LogUtils.AMOSTRA_LEITURA;
        query = amostra == null ? query + "&link=ilike.amostra_leitura=" + rotinaitem + "-*" : query + "&link=eq.amostra_leitura=" + rotinaitem + "-" + amostra;
        query = query + "&order=data";
        return Arrays.asList((Log[])dao.listObject(Log[].class, query));
    }
}

