/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.laudomodelo;

import ceresonemodel.analise.GrupoPacote;
import ceresonemodel.dao.DAO_LAB;
import com.fasterxml.jackson.annotation.JsonFilter;
import java.io.Serializable;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Validador_grupopacotenivel
implements Serializable {
    private long campoconfiguracao;
    private String tipo;
    private String valor;
    private String minimo;
    private String maximo;

    public boolean equals(Object o) {
        try {
            Validador_grupopacotenivel tmp = (Validador_grupopacotenivel)o;
            return tmp.campoconfiguracao == this.campoconfiguracao;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNorma(long amostra_id, DAO_LAB dao) {
        try {
            String norma = "";
            GrupoPacote g = dao.fnc_grupopacote2amostra(amostra_id);
            if (g != null) {
                norma = g.getNorma();
            }
            return norma;
        }
        catch (Exception e) {
            return "erro";
        }
    }

    public static String getConclusao(long amostra_id, DAO_LAB dao) {
        try {
            GrupoPacote g = dao.fnc_grupopacote2amostra(amostra_id);
            if (g == null) {
                return "";
            }
            List<Validador_grupopacotenivel> validadores = dao.fnc_validador_grupopacotenivel(amostra_id, g.getId());
            boolean valido = true;
            for (Validador_grupopacotenivel validador : validadores) {
                System.out.print("validador: " + validador.tipo + ": " + validador.valor + " (" + validador.minimo + " - " + validador.maximo + ")");
                if (!validador.valido()) {
                    System.out.println(" = FALSE");
                    valido = false;
                    break;
                }
                System.out.println(" = TRUE");
            }
            return valido ? g.getConclusao() : g.getConclusao_falha();
        }
        catch (Exception e) {
            return "erro";
        }
    }

    private boolean valido() {
        if (this.tipo.equals("Selecao_Unica")) {
            if (this.minimo == null || this.minimo.isEmpty()) {
                return true;
            }
            return this.valor.equals(this.minimo);
        }
        if (this.tipo.equals("Calculo") || this.tipo.equals("Numerico")) {
            boolean val;
            boolean min = this.minimo != null && !this.minimo.isEmpty() && !this.minimo.equals("");
            boolean max = this.maximo != null && !this.maximo.isEmpty() && !this.maximo.equals("");
            boolean bl = val = this.valor != null && !this.valor.isEmpty() && !this.valor.equals("");
            if (!min && !max) {
                return true;
            }
            if (!val) {
                return true;
            }
            try {
                double dmin = min ? Double.parseDouble(this.minimo.replace(",", ".")) : -1.0;
                double dmax = max ? Double.parseDouble(this.maximo.replace(",", ".")) : -1.0;
                double dval = Double.parseDouble(this.valor.replace(",", "."));
                if (min && !max) {
                    return dval >= dmin;
                }
                if (min && max) {
                    return dval >= dmin && dval <= dmax;
                }
                if (!min && max) {
                    return dval <= dmax;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public long getCampoconfiguracao() {
        return this.campoconfiguracao;
    }

    public void setCampoconfiguracao(long campoconfiguracao) {
        this.campoconfiguracao = campoconfiguracao;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public String getMinimo() {
        return this.minimo;
    }

    public void setMinimo(String minimo) {
        this.minimo = minimo;
    }

    public String getMaximo() {
        return this.maximo;
    }

    public void setMaximo(String maximo) {
        this.maximo = maximo;
    }
}

