/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.laudomodelo;

import ceresonemodel.laudomodelo.LaudoModelo_campo;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class ModeloExportacao
implements Serializable {
    private long id;
    private Long analise;
    private boolean ativo;
    private String descricao;
    private String parametros;

    public String verificaInsert() throws Exception {
        if (this.descricao == null || this.descricao.equals("")) {
            return "Existem campos obrigat\u00f3rios que n\u00e3o foram preenchidos!\nDescri\u00e7\u00e3o.";
        }
        return null;
    }

    public boolean equals(Object o) {
        try {
            ModeloExportacao tmp = (ModeloExportacao)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    @JsonIgnore
    public void setCampos(List<LaudoModelo_campo> campos) {
        String s = "\u00ac";
        String tmp = "";
        for (LaudoModelo_campo campo : campos) {
            campo.setLabel(ModeloExportacao.valida(campo.getLabel()));
            campo.setGrupo(ModeloExportacao.valida(campo.getGrupo()));
            campo.setValor(ModeloExportacao.valida(campo.getValor()));
            campo.setValor_label(ModeloExportacao.valida(campo.getValor_label()));
            campo.setConversao(ModeloExportacao.valida(campo.getConversao()));
            campo.setDecimais(ModeloExportacao.valida(campo.getDecimais()));
            if (!tmp.equals("")) {
                tmp = tmp + "\u00a7";
            }
            tmp = tmp + campo.getLabel() + s + campo.getTipo() + s + campo.getGrupo() + s + campo.getValor() + s + campo.getValor_label() + s + campo.getConversao() + s + campo.getDecimais();
        }
        this.parametros = tmp;
    }

    private static String valida(String validar) {
        if (validar == null) {
            return null;
        }
        return validar.replace("\u00ac", "").replace("\u00a7", "");
    }

    @JsonIgnore
    public void updateCampoValorEmParametro(LaudoModelo_campo campo) {
        List<LaudoModelo_campo> campos = this.getCampos();
        for (LaudoModelo_campo c : campos) {
            if (!c.getLabel().equals(campo.getLabel())) continue;
            c.setValor(campo.getValor());
            c.setValor_label(campo.getValor_label());
            c.setConversao(campo.getConversao());
            c.setDecimais(campo.getDecimais());
        }
        this.setCampos(campos);
    }

    @JsonIgnore
    public void updateValorLabel(LaudoModelo_campo campo, String label) {
        List<LaudoModelo_campo> campos = this.getCampos();
        for (LaudoModelo_campo c : campos) {
            if (!c.getLabel().equals(campo.getLabel())) continue;
            c.setLabel(label);
            campo.setLabel(label);
            break;
        }
        this.setCampos(campos);
    }

    @JsonIgnore
    public List<LaudoModelo_campo> getCampos() {
        ArrayList<LaudoModelo_campo> campos = new ArrayList<LaudoModelo_campo>();
        if (this.parametros != null) {
            String[] linhas;
            for (String linha : linhas = this.parametros.split("\u00a7")) {
                String[] x = linha.split("\u00ac");
                LaudoModelo_campo campo = new LaudoModelo_campo();
                campo.setLabel(x[0]);
                campo.setTipo(x[1]);
                campo.setGrupo(x[2]);
                campo.setValor(x[3]);
                campo.setValor_label(x[4]);
                campo.setConversao(x[5]);
                campo.setDecimais(x[6]);
                campos.add(campo);
            }
        }
        return campos;
    }

    public String toString() {
        return this.getDescricao();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getParametros() {
        return this.parametros;
    }

    public void setParametros(String parametros) {
        this.parametros = parametros;
    }
}

