/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.laudomodelo;

import ceresonemodel.analise.Analise;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.laudomodelo.LaudoModelo_campo;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Laudomodelo_onedesk
implements Serializable {
    public static final String EXCEL = "EXCEL";
    public static final String JASPER = "JASPER";
    public static final String CSV = "CSV";
    public static final String TXT = "TXT";
    public static final String DOCX = "DOCX";
    public static final String NIVEL_DINAMICO = "N\u00edvel por cultura da amostra ";
    public static final String NIVEL_FIXO = "N\u00edvel por cultura fixa";
    public static final String NIVEL_GRUPOPACOTE = "N\u00edvel por Grupo (pacote de pre\u00e7o)";
    public static final String NIVEL_DESLIGADO = "N\u00edvel desativado";
    public static final String[] NIVEL_MODELOS = new String[]{"N\u00edvel desativado", "N\u00edvel por cultura da amostra ", "N\u00edvel por cultura fixa"};
    public static final String[] NIVEL_MODELOS_CONCLUSAO_ON = new String[]{"N\u00edvel desativado", "N\u00edvel por cultura da amostra ", "N\u00edvel por cultura fixa", "N\u00edvel por Grupo (pacote de pre\u00e7o)"};
    private long id;
    private Long analise;
    private boolean ativo;
    private String descricao;
    private String tipo;
    private String arquivo;
    private String parametros;
    private int numero_amostras;
    private String nao_solicitado_texto;
    private String simbolo_repeticao;
    private String nivel_tipo;
    private Long nivel_cultura;
    private boolean dinamico;
    private String parametros_dinamico;
    private String txt_header;
    private String txt_body;
    private String txt_extensao;
    private String jasper_pdf_anexo;
    private boolean assinatura_digital;
    private String view_cultura_nome;

    public String verificaInsert() throws Exception {
        if (this.descricao == null || this.descricao.equals("")) {
            return "Existem campos obrigat\u00f3rios que n\u00e3o foram preenchidos!\nDescri\u00e7\u00e3o.";
        }
        return null;
    }

    public boolean equals(Object o) {
        try {
            Laudomodelo_onedesk tmp = (Laudomodelo_onedesk)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    @JsonIgnore
    public static String[] getNivel(Analise analise) {
        ArrayList<String> niveis = new ArrayList<String>();
        niveis.add(NIVEL_DESLIGADO);
        niveis.add(NIVEL_FIXO);
        if (analise.isCultura()) {
            niveis.add(NIVEL_DINAMICO);
        }
        if (analise.isConclusao()) {
            niveis.add(NIVEL_GRUPOPACOTE);
        }
        String[] r = new String[niveis.size()];
        for (int i = 0; i < niveis.size(); ++i) {
            r[i] = (String)niveis.get(i);
        }
        return r;
    }

    @JsonIgnore
    public void setCampos(List<LaudoModelo_campo> campos) {
        String s = "\u00ac";
        String tmp = "";
        for (LaudoModelo_campo campo : campos) {
            campo.setLabel(Laudomodelo_onedesk.valida(campo.getLabel()));
            campo.setGrupo(Laudomodelo_onedesk.valida(campo.getGrupo()));
            campo.setValor(Laudomodelo_onedesk.valida(campo.getValor()));
            campo.setValor_label(Laudomodelo_onedesk.valida(campo.getValor_label()));
            campo.setConversao(Laudomodelo_onedesk.valida(campo.getConversao()));
            campo.setDecimais(Laudomodelo_onedesk.valida(campo.getDecimais()));
            if (!tmp.equals("")) {
                tmp = tmp + "\u00a7";
            }
            tmp = tmp + campo.getLabel() + s + campo.getTipo() + s + campo.getGrupo() + s + campo.getValor() + s + campo.getValor_label() + s + campo.getConversao() + s + campo.getDecimais();
        }
        this.parametros = tmp;
    }

    @JsonIgnore
    public void setCamposDinamicos(List<LaudoModelo_campo> campos) {
        String s = "\u00ac";
        String tmp = "";
        this.ajustaCamposDinamicos(campos);
        for (LaudoModelo_campo campo : campos) {
            campo.setLabel(Laudomodelo_onedesk.valida(campo.getLabel()));
            campo.setGrupo(Laudomodelo_onedesk.valida(campo.getGrupo()));
            campo.setValor(Laudomodelo_onedesk.valida(campo.getValor()));
            campo.setValor_label(Laudomodelo_onedesk.valida(campo.getValor_label()));
            campo.setConversao(Laudomodelo_onedesk.valida(campo.getConversao()));
            campo.setDecimais(Laudomodelo_onedesk.valida(campo.getDecimais()));
            if (!tmp.equals("")) {
                tmp = tmp + "\u00a7";
            }
            tmp = tmp + campo.getLabel() + s + campo.getTipo() + s + campo.getGrupo() + s + campo.getValor() + s + campo.getValor_label() + s + campo.getConversao() + s + campo.getDecimais();
        }
        this.parametros_dinamico = tmp;
    }

    private static String valida(String validar) {
        if (validar == null) {
            return null;
        }
        return validar.replace("\u00ac", "").replace("\u00a7", "");
    }

    @JsonIgnore
    public void updateCampoValorEmParametro(LaudoModelo_campo campo) {
        List<LaudoModelo_campo> campos = campo.isDinamico() ? this.getCamposDinamicos() : this.getCampos();
        for (LaudoModelo_campo c : campos) {
            if (!c.getLabel().equals(campo.getLabel())) continue;
            c.setValor(campo.getValor());
            c.setValor_label(campo.getValor_label());
            c.setConversao(campo.getConversao());
            c.setDecimais(campo.getDecimais());
        }
        if (campo.isDinamico()) {
            this.setCamposDinamicos(campos);
        } else {
            this.setCampos(campos);
        }
    }

    @JsonIgnore
    public void updateValorLabel(LaudoModelo_campo campo, String label) {
        List<LaudoModelo_campo> campos = campo.isDinamico() ? this.getCamposDinamicos() : this.getCampos();
        for (LaudoModelo_campo c : campos) {
            if (!c.getLabel().equals(campo.getLabel())) continue;
            c.setLabel(label);
            campo.setLabel(label);
            break;
        }
        if (campo.isDinamico()) {
            this.setCamposDinamicos(campos);
        } else {
            this.setCampos(campos);
        }
    }

    @JsonIgnore
    public List<LaudoModelo_campo> getCampos() {
        ArrayList<LaudoModelo_campo> campos = new ArrayList<LaudoModelo_campo>();
        if (this.parametros != null) {
            String[] linhas;
            for (String linha : linhas = this.parametros.split("\u00a7")) {
                String[] x = linha.split("\u00ac");
                LaudoModelo_campo campo = new LaudoModelo_campo();
                campo.setLabel(x[0]);
                campo.setTipo(x[1]);
                campo.setGrupo(x[2]);
                campo.setValor(x[3]);
                campo.setValor_label(x[4]);
                campo.setConversao(x[5]);
                campo.setDecimais(x[6]);
                campos.add(campo);
            }
        }
        return campos;
    }

    @JsonIgnore
    public List<LaudoModelo_campo> getCamposDinamicos() {
        ArrayList<LaudoModelo_campo> campos = new ArrayList<LaudoModelo_campo>();
        if (this.parametros_dinamico != null) {
            String[] linhas;
            for (String linha : linhas = this.parametros_dinamico.split("\u00a7")) {
                String[] x = linha.split("\u00ac");
                LaudoModelo_campo campo = new LaudoModelo_campo();
                campo.setLabel(x[0]);
                campo.setTipo(x[1]);
                campo.setGrupo(x[2]);
                campo.setValor(x[3]);
                campo.setValor_label(x[4]);
                campo.setConversao(x[5]);
                campo.setDecimais(x[6]);
                campo.setDinamico(true);
                campos.add(campo);
            }
        }
        return campos;
    }

    @JsonIgnore
    public void addLinhaCamposDinamicos(int linha, DAO_LAB dao) throws Exception {
        List<LaudoModelo_campo> campos = this.getCampos();
        List<LaudoModelo_campo> campos_din = this.getCamposDinamicos();
        for (LaudoModelo_campo campo : campos) {
            if (!campo.getGrupo().equals("Din\u00e2mico") && !campo.getGrupo().equals("Din\u00e2mico_Amostra_1")) continue;
            LaudoModelo_campo novo = new LaudoModelo_campo();
            novo.setGrupo("Linha_" + linha);
            novo.setLabel(campo.getLabel() + "_" + linha);
            novo.setTipo(campo.getTipo());
            novo.setDinamico(true);
            campos_din.add(novo);
        }
        this.setCamposDinamicos(campos_din);
        dao.updateObject(this, "laudomodelo_onedesk?id=eq." + this.getId());
    }

    @JsonIgnore
    public void addLinhaSemResultado(DAO_LAB dao) throws Exception {
        List<LaudoModelo_campo> campos = this.getCampos();
        List<LaudoModelo_campo> campos_din = this.getCamposDinamicos();
        for (LaudoModelo_campo campo_din : campos_din) {
            if (!campo_din.getGrupo().equals("Sem Resultados")) continue;
            return;
        }
        for (LaudoModelo_campo campo : campos) {
            if (!campo.getGrupo().equals("Din\u00e2mico") && !campo.getGrupo().equals("Din\u00e2mico_Amostra_1")) continue;
            LaudoModelo_campo novo = new LaudoModelo_campo();
            novo.setGrupo("Sem Resultados");
            novo.setLabel(campo.getLabel() + "_sem_resultado");
            novo.setTipo(campo.getTipo());
            novo.setDinamico(true);
            campos_din.add(novo);
        }
        this.setCamposDinamicos(campos_din);
        dao.updateObject(this, "laudomodelo_onedesk?id=eq." + this.getId());
    }

    @JsonIgnore
    public void removeLinhaCamposDinamicos(String linha, DAO_LAB dao) throws Exception {
        List<LaudoModelo_campo> campos = this.getCamposDinamicos();
        ArrayList<LaudoModelo_campo> campos_din = new ArrayList<LaudoModelo_campo>();
        for (LaudoModelo_campo campo : campos) {
            if (campo.getGrupo().equals(linha)) continue;
            campos_din.add(campo);
        }
        this.setCamposDinamicos(campos_din);
        dao.updateObject(this, "laudomodelo_onedesk?id=eq." + this.getId());
    }

    @JsonIgnore
    public void removeLinhaSemResultados(DAO_LAB dao) throws Exception {
        List<LaudoModelo_campo> campos = this.getCamposDinamicos();
        ArrayList<LaudoModelo_campo> campos_din = new ArrayList<LaudoModelo_campo>();
        for (LaudoModelo_campo campo : campos) {
            if (campo.getGrupo().equals("Sem Resultados")) continue;
            campos_din.add(campo);
        }
        this.setCamposDinamicos(campos_din);
        dao.updateObject(this, "laudomodelo_onedesk?id=eq." + this.getId());
    }

    private void ajustaCamposDinamicos(List<LaudoModelo_campo> campos) {
        int x = 1;
        String satual = null;
        Collections.sort(campos, LaudoModelo_campo.getComparadorGrupo());
        System.out.println("********************************************");
        for (int y = 0; y < campos.size(); ++y) {
            LaudoModelo_campo campo = campos.get(y);
            if (campo.getGrupo().equals("Sem Resultados")) {
                System.out.println("* campo: " + campo.getLabel() + " | " + campo.getGrupo());
                continue;
            }
            if (satual == null) {
                satual = campo.getGrupo();
            } else if (!satual.equals(campo.getGrupo())) {
                ++x;
                satual = campo.getGrupo();
            }
            String label = campo.getLabel().substring(0, campo.getLabel().indexOf("_")) + "_" + x;
            campo.setLabel(label);
            campo.setGrupo("Linha_" + x);
            System.out.println(x + " campo: " + campo.getLabel() + " | " + campo.getGrupo());
        }
        System.out.println("********************************************");
    }

    @JsonIgnore
    public String jasper_pdf_anexo_label() {
        if (this.jasper_pdf_anexo == null || this.jasper_pdf_anexo.equals("")) {
            return "n\u00e3o configurado";
        }
        return this.jasper_pdf_anexo.substring(this.jasper_pdf_anexo.lastIndexOf("/") + 1);
    }

    public String toString() {
        return this.getDescricao();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(String arquivo) {
        this.arquivo = arquivo;
    }

    public String getParametros() {
        return this.parametros;
    }

    public void setParametros(String parametros) {
        this.parametros = parametros;
    }

    public int getNumero_amostras() {
        return this.numero_amostras;
    }

    public void setNumero_amostras(int numero_amostras) {
        this.numero_amostras = numero_amostras;
    }

    public String getNivel_tipo() {
        return this.nivel_tipo;
    }

    public void setNivel_tipo(String nivel_tipo) {
        this.nivel_tipo = nivel_tipo;
    }

    public Long getNivel_cultura() {
        return this.nivel_cultura;
    }

    public void setNivel_cultura(Long nivel_cultura) {
        this.nivel_cultura = nivel_cultura;
    }

    public String getView_cultura_nome() {
        return this.view_cultura_nome;
    }

    public void setView_cultura_nome(String view_cultura_nome) {
        this.view_cultura_nome = view_cultura_nome;
    }

    public String getNao_solicitado_texto() {
        return this.nao_solicitado_texto;
    }

    public void setNao_solicitado_texto(String nao_solicitado_texto) {
        this.nao_solicitado_texto = nao_solicitado_texto;
    }

    public String getSimbolo_repeticao() {
        return this.simbolo_repeticao;
    }

    public void setSimbolo_repeticao(String simbolo_repeticao) {
        this.simbolo_repeticao = simbolo_repeticao;
    }

    public boolean isDinamico() {
        return this.dinamico;
    }

    public void setDinamico(boolean dinamico) {
        this.dinamico = dinamico;
    }

    public String getParametros_dinamico() {
        return this.parametros_dinamico;
    }

    public void setParametros_dinamico(String parametros_dinamico) {
        this.parametros_dinamico = parametros_dinamico;
    }

    public String getTxt_header() {
        return this.txt_header;
    }

    public void setTxt_header(String txt_header) {
        this.txt_header = txt_header;
    }

    public String getTxt_body() {
        return this.txt_body;
    }

    public void setTxt_body(String txt_body) {
        this.txt_body = txt_body;
    }

    public String getTxt_extensao() {
        return this.txt_extensao;
    }

    public void setTxt_extensao(String txt_extensao) {
        this.txt_extensao = txt_extensao;
    }

    public String getJasper_pdf_anexo() {
        return this.jasper_pdf_anexo;
    }

    public void setJasper_pdf_anexo(String jasper_pdf_anexo) {
        this.jasper_pdf_anexo = jasper_pdf_anexo;
    }

    public boolean isAssinatura_digital() {
        return this.assinatura_digital;
    }

    public void setAssinatura_digital(boolean assinatura_digital) {
        this.assinatura_digital = assinatura_digital;
    }
}

