/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.dao;

import ceresonemodel.dao.DAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Paginador {
    private int itens_por_pagina = 50;
    private int total_itens = -1;
    private int maximo_carregado = 0;
    private DAO dao;
    private Class clazz;
    private String query;

    public Paginador(DAO dao, int itens_por_pagina, String query, Class clazz) {
        this.itens_por_pagina = itens_por_pagina;
        this.query = query;
        this.dao = dao;
        this.clazz = clazz;
    }

    public Object[] getNext() throws Exception {
        if (this.total_itens == -1 || this.maximo_carregado < this.total_itens) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("Prefer", "count=exact");
            m.put("Range", this.maximo_carregado + "-" + (this.maximo_carregado + this.itens_por_pagina - 1));
            System.out.println("<<<>>>>: " + this.maximo_carregado + "-" + (this.maximo_carregado + this.itens_por_pagina - 1) + "---------------------------------------------");
            return (Object[])this.dao.listObject(this.clazz, this.query, m, this);
        }
        return null;
    }

    public void setRange(String range) {
        if (range.startsWith("*")) {
            this.total_itens = 0;
            this.maximo_carregado = 0;
        } else {
            this.total_itens = Integer.parseInt(range.split("/")[1]);
            this.maximo_carregado = Integer.parseInt(range.substring(range.indexOf("-") + 1, range.indexOf("/"))) + 1;
        }
    }

    public int getTotal_itens() {
        return this.total_itens;
    }

    public String getTotal_label() {
        return this.total_itens == -1 ? "Nenhum registro encontrado" : "Exibindo " + this.maximo_carregado + " de " + this.total_itens;
    }

    public boolean existeMaisRegistros() {
        return this.total_itens > 0 && this.maximo_carregado < this.total_itens;
    }

    public static Object load(DAO dao, Class clazz, String query, int itens_por_pagina) throws Exception {
        ArrayList<Object> retorno = null;
        try {
            ArrayList<Object> resultado = new ArrayList<Object>();
            Paginador paginador = new Paginador(dao, itens_por_pagina, query, clazz);
            resultado.addAll(Arrays.asList(paginador.getNext()));
            int max = paginador.getTotal_itens();
            while (resultado.size() < max) {
                List<Object> ls = Arrays.asList(paginador.getNext());
                for (Object l : ls) {
                    resultado.add(l);
                }
            }
            retorno = resultado;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao carregar dados!");
        }
        if (retorno != null) {
            return retorno;
        }
        return new ArrayList();
    }
}

