/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.dao;

import ceresonemodel.dao.Paginador;
import ceresonemodel.dao.Token;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public abstract class DAO {
    protected String urlBase = "";
    protected String email = "";
    protected String pass = "";
    protected static String token;
    protected static long token_expired;

    private String getToken() throws Exception {
        String old = token == null ? null : new String(token);
        try {
            if (token == null || System.currentTimeMillis() > token_expired) {
                token_expired = System.currentTimeMillis() + 1800000L;
                String body = "{\n    \"email\": \"" + this.email + "\",\n    \"pass\": \"" + this.pass + "\"\n}";
                String result = this.get("POST", "rpc/login", body, false);
                ObjectMapper objectMapper = new ObjectMapper();
                Token t = (Token)objectMapper.readValue(result, Token.class);
                token = t.getToken();
            }
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Erro ao obter um token! usando antigo");
            token = old;
            return token;
        }
    }

    protected String get(String method, String endpoint, String body, boolean token) throws Exception {
        return this.get(method, endpoint, body, token, null, null);
    }

    protected String get(String method, String endpoint, String body, boolean token, Map<String, String> headers, Paginador pg) throws Exception {
        String strCurrentLine;
        URL url = new URL(this.urlBase + endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (method.equals("PATCH")) {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        } else {
            connection.setRequestMethod(method);
        }
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "*/*");
        if (headers != null) {
            Set<String> chaves = headers.keySet();
            for (String chave : chaves) {
                if (chave == null) continue;
                connection.setRequestProperty(chave, headers.get(chave));
            }
        }
        if (token) {
            connection.setRequestProperty("Authorization", "Bearer " + this.getToken());
        }
        if (body != null) {
            connection.setDoOutput(true);
            PrintStream output = new PrintStream(connection.getOutputStream());
            output.println(body);
        }
        BufferedReader br = null;
        String result = "";
        try {
            br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (Exception x) {
            String strCurrentLine2;
            br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            String erro = "";
            while ((strCurrentLine2 = br.readLine()) != null) {
                erro = erro + "\n" + strCurrentLine2;
            }
            erro = erro.contains("\"message\":") ? erro.substring(erro.indexOf("\"message\":")).replace("}", "").replace("\\", "|").replace("\"", "") : erro;
            throw new Exception("Erro de dados:\n" + erro);
        }
        while ((strCurrentLine = br.readLine()) != null) {
            result = result + "\n" + strCurrentLine;
        }
        if (pg != null) {
            pg.setRange(connection.getHeaderField("content-range"));
        }
        return result;
    }

    public void post(String query, String body) throws Exception {
        this.get("POST", query, body, true, null, null);
    }

    public long getSeq() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String seq_json = this.get("POST", "rpc/getseq", null, true);
        long id = (Long)objectMapper.readValue(seq_json, Long.class);
        return id;
    }

    public long getLogSeq() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String seq_json = this.get("POST", "rpc/getlogseq", null, true);
        long id = (Long)objectMapper.readValue(seq_json, Long.class);
        return id;
    }

    public long getProximoNumero(int ano, String tabela) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String seq_json = this.get("GET", "rpc/proximonumero?pano=" + ano + "&ptabela=" + tabela, null, true);
        long id = (Long)objectMapper.readValue(seq_json, Long.class);
        return id;
    }

    public long getProximaamostra(int ano, long analise) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String seq_json = this.get("GET", "rpc/proximaamostra?pano=" + ano + "&panalise=" + analise, null, true);
        long id = (Long)objectMapper.readValue(seq_json, Long.class);
        return id;
    }

    public long getProximaamostra_controle(int ano, long analise) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String seq_json = this.get("GET", "rpc/proximaamostra_controle?pano=" + ano + "&panalise=" + analise, null, true);
        long id = (Long)objectMapper.readValue(seq_json, Long.class);
        return id;
    }

    public void includeObject(Object object, String query) throws Exception {
        this.verificaInsert(object);
        String json = this.getJson_Insert_Update(object);
        this.get("POST", query, json, true);
    }

    public void includeObjects(List<Object> objects, String query) throws Exception {
        String js = "[";
        for (Object object : objects) {
            js = js + (js.endsWith("[") ? "" : ",");
            this.verificaInsert(object);
            String json = this.getJson_Insert_Update(object);
            js = js + "\n" + json + "\n";
        }
        js = js + "]";
        this.get("POST", query, js, true);
    }

    public void updateObject(Object object, String query) throws Exception {
        this.verificaUpdate(object);
        String json = this.getJson_Insert_Update(object);
        this.get("PUT", query, json, true);
    }

    public void excludeObject(Object object, String query) throws Exception {
        String json = this.getJson_Insert_Update(object);
        this.get("DELETE", query, json, true);
    }

    public Object listObject(Class t, String query) throws Exception {
        return this.listObject(t, query, null, null);
    }

    public Object listObject(Class t, String query, Map headers, Paginador pg) throws Exception {
        String result = this.get("GET", query, null, true, headers, pg);
        result = new String(result.getBytes(), StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new StdDateFormat(TimeZone.getTimeZone("GMT-3"), Locale.US));
        Object x = objectMapper.readValue(result, t);
        return x;
    }

    public Object listObjectLight(Class t, String query) throws Exception {
        return this.listObjectLight(t, query, null, null);
    }

    public Object listObjectLight(Class t, String query, Map headers, Paginador pg) throws Exception {
        String result = this.get("GET", query, null, true, headers, pg);
        result = new String(result.getBytes(), StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new StdDateFormat(TimeZone.getTimeZone("GMT-3"), Locale.US));
        Class clazz = t;
        Field[] fs = clazz.getDeclaredFields();
        ArrayList<String> view_campos = new ArrayList<String>();
        for (Field f : fs) {
            if (!f.getName().startsWith("view_")) continue;
            view_campos.add(f.getName());
        }
        SimpleFilterProvider filter = new SimpleFilterProvider();
        filter.addFilter("insert_update_filter", SimpleBeanPropertyFilter.serializeAllExcept(new HashSet(view_campos)));
        objectMapper.setFilterProvider((FilterProvider)filter);
        Object x = objectMapper.readValue(result, t);
        return x;
    }

    protected String getJson_Insert_Update(Object objeto) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new StdDateFormat(TimeZone.getTimeZone("GMT-3"), Locale.US));
        Class<?> clazz = objeto.getClass();
        Field[] fs = clazz.getDeclaredFields();
        ArrayList<String> view_campos = new ArrayList<String>();
        for (Field f : fs) {
            if (!f.getName().startsWith("view_")) continue;
            view_campos.add(f.getName());
        }
        SimpleFilterProvider filter = new SimpleFilterProvider();
        filter.addFilter("insert_update_filter", SimpleBeanPropertyFilter.serializeAllExcept(new HashSet(view_campos)));
        objectMapper.setFilterProvider((FilterProvider)filter);
        String json = objectMapper.writeValueAsString(objeto);
        return json;
    }

    private void verificaInsert(Object objeto) throws Exception {
        Class<?> clazz = objeto.getClass();
        for (Method metodo : clazz.getMethods()) {
            if (!metodo.getName().equals("verificaInsert")) continue;
            Object[] parametros = new Class[0];
            String mensagem = (String)metodo.invoke(objeto, parametros);
            if (mensagem == null) break;
            throw new Exception(mensagem);
        }
    }

    private void verificaUpdate(Object objeto) throws Exception {
        Class<?> clazz = objeto.getClass();
        for (Method metodo : clazz.getMethods()) {
            if (!metodo.getName().equals("verificaUpdate")) continue;
            Object[] parametros = new Class[0];
            String mensagem = (String)metodo.invoke(objeto, parametros);
            if (mensagem == null) break;
            throw new Exception(mensagem);
        }
    }

    public String getJson(String query, Map<String, String> headers) throws Exception {
        return this.get("GET", query, null, true, headers, null);
    }
}

