/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.campos;

import ceresonemodel.campos.Campoconfiguracao;
import ceresonemodel.campos.CampoconfiguracaoParametro;
import ceresonemodel.dao.DAO_LAB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CampoInfo {
    public static final String TEXTO = "Texto";
    public static final String NUMERICO = "Numerico";
    public static final String CURVA_CALIBRACAO = "Curva_Calibracao";
    public static final String SELECAO_UNICA = "Selecao_Unica";
    public static final String CALCULO = "Calculo";
    public static final String SIM_NAO = "Sim_Nao";
    public static final String DATA = "Data";
    public static final String CONSTANTE = "Constante";
    public static final String SEQUENCIA = "Sequ\u00eancia";
    public static final String QRCODE = "QRCode";
    public static final String PRODUTO = "Produto";
    public static final String EQUIPAMENTO = "Equipamento";
    public static final String SOLUCAO = "Solucao";

    public static Campoconfiguracao get(long campo_id, DAO_LAB dao) throws Exception {
        String query = "campoconfiguracao?id=eq." + campo_id;
        List<Campoconfiguracao> campos = Arrays.asList((Campoconfiguracao[])dao.listObject(Campoconfiguracao[].class, query));
        if (campos == null || campos.isEmpty()) {
            return null;
        }
        return campos.get(0);
    }

    public static List<CampoconfiguracaoParametro> loadParametros(Campoconfiguracao campo, DAO_LAB dao) throws Exception {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        String query = "campoconfiguracaoparametro?campoconfiguracao=eq." + campo.getId();
        List<CampoconfiguracaoParametro> carregados = Arrays.asList((CampoconfiguracaoParametro[])dao.listObject(CampoconfiguracaoParametro[].class, query));
        List<CampoconfiguracaoParametro> padroes = CampoInfo.loadPadroes(campo);
        for (CampoconfiguracaoParametro padrao : padroes) {
            boolean encontrado = false;
            for (CampoconfiguracaoParametro carregado : carregados) {
                if (!padrao.getNome().equals(carregado.getNome())) continue;
                resultado.add(carregado);
                encontrado = true;
                break;
            }
            if (encontrado) continue;
            resultado.add(padrao);
        }
        return resultado;
    }

    public static CampoconfiguracaoParametro getParametro(long campo, String parametro, DAO_LAB dao) throws Exception {
        Campoconfiguracao cp = CampoInfo.get(campo, dao);
        if (cp == null) {
            return null;
        }
        List<CampoconfiguracaoParametro> prs = CampoInfo.loadParametros(cp, dao);
        if (prs == null || prs.isEmpty()) {
            return null;
        }
        for (CampoconfiguracaoParametro pr : prs) {
            if (!pr.getNome().equals(parametro)) continue;
            return pr;
        }
        return null;
    }

    public static void salvarParametros(Campoconfiguracao campo, List<CampoconfiguracaoParametro> parametros, DAO_LAB dao) throws Exception {
        dao.func_limpar_campoconfiguracaoparametro(campo.getId());
        for (CampoconfiguracaoParametro parametro : parametros) {
            parametro.setCampoconfiguracao(campo.getId());
            parametro.setId(dao.getSeq());
            dao.includeObject(parametro, "campoconfiguracaoparametro");
        }
    }

    public static String getValorParametro(String nome, List<CampoconfiguracaoParametro> parametros) {
        for (CampoconfiguracaoParametro parametro : parametros) {
            if (!parametro.getNome().equals(nome)) continue;
            return parametro.getValor().trim();
        }
        return "";
    }

    public static void setValorParametro(String nome, String valor, List<CampoconfiguracaoParametro> parametros) {
        for (CampoconfiguracaoParametro parametro : parametros) {
            if (!parametro.getNome().equals(nome)) continue;
            parametro.setValor(valor);
        }
    }

    public static List<CampoconfiguracaoParametro> loadPadroes(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        String tipo = campoConfiguracao.getTipo();
        if (tipo.equals(NUMERICO)) {
            return CampoInfo.loadPadroesNUMERICO(campoConfiguracao);
        }
        if (tipo.equals(TEXTO)) {
            return CampoInfo.loadPadroesTEXTO(campoConfiguracao);
        }
        if (tipo.equals(SELECAO_UNICA)) {
            return CampoInfo.loadPadroesSELECAO_UNICA(campoConfiguracao);
        }
        if (tipo.equals(SIM_NAO)) {
            return CampoInfo.loadPadroesSELECAO_UNICA(campoConfiguracao);
        }
        if (tipo.equals(CURVA_CALIBRACAO)) {
            return CampoInfo.loadPadroesCURVA_CALIBRACAO(campoConfiguracao);
        }
        if (tipo.equals(CALCULO)) {
            return CampoInfo.loadPadroesCALCULO(campoConfiguracao);
        }
        if (tipo.equals(DATA)) {
            return CampoInfo.loadPadroesDATA(campoConfiguracao);
        }
        if (tipo.equals(CONSTANTE)) {
            return CampoInfo.loadPadroesCONSTANTE(campoConfiguracao);
        }
        if (tipo.equals(SEQUENCIA)) {
            return CampoInfo.loadPadroesSEQUENCIA(campoConfiguracao);
        }
        if (tipo.equals(QRCODE)) {
            return CampoInfo.loadPadroesQRCODE(campoConfiguracao);
        }
        if (tipo.equals(PRODUTO)) {
            return CampoInfo.loadPadroesPRODUTO(campoConfiguracao);
        }
        if (tipo.equals(EQUIPAMENTO)) {
            return CampoInfo.loadPadroesPRODUTO(campoConfiguracao);
        }
        if (tipo.equals(SOLUCAO)) {
            return CampoInfo.loadPadroesSOLUCAO(campoConfiguracao);
        }
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesNUMERICO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prDecimal = new CampoconfiguracaoParametro();
        prDecimal.setCampoconfiguracao(campoConfiguracao.getId());
        prDecimal.setNome("casas_decimal");
        prDecimal.setValor("0");
        resultado.add(prDecimal);
        CampoconfiguracaoParametro prFaixaValores = new CampoconfiguracaoParametro();
        prFaixaValores.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaValores.setNome("faixa_valores");
        prFaixaValores.setValor("false");
        resultado.add(prFaixaValores);
        CampoconfiguracaoParametro prFaixaMin = new CampoconfiguracaoParametro();
        prFaixaMin.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaMin.setNome("faixa_min");
        prFaixaMin.setValor("0");
        resultado.add(prFaixaMin);
        CampoconfiguracaoParametro prFaixaMax = new CampoconfiguracaoParametro();
        prFaixaMax.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaMax.setNome("faixa_max");
        prFaixaMax.setValor("0");
        resultado.add(prFaixaMax);
        CampoconfiguracaoParametro prValorPadraoAtivo = new CampoconfiguracaoParametro();
        prValorPadraoAtivo.setCampoconfiguracao(campoConfiguracao.getId());
        prValorPadraoAtivo.setNome("valor_padrao_ativo");
        prValorPadraoAtivo.setValor("false");
        resultado.add(prValorPadraoAtivo);
        CampoconfiguracaoParametro prValorPadrao = new CampoconfiguracaoParametro();
        prValorPadrao.setCampoconfiguracao(campoConfiguracao.getId());
        prValorPadrao.setNome("valor_padrao");
        prValorPadrao.setValor("0");
        resultado.add(prValorPadrao);
        CampoconfiguracaoParametro prLQ = new CampoconfiguracaoParametro();
        prLQ.setCampoconfiguracao(campoConfiguracao.getId());
        prLQ.setNome("lq");
        prLQ.setValor("0");
        resultado.add(prLQ);
        CampoconfiguracaoParametro prLQV = new CampoconfiguracaoParametro();
        prLQV.setCampoconfiguracao(campoConfiguracao.getId());
        prLQV.setNome("exibir_lq");
        prLQV.setValor("L.Q.");
        resultado.add(prLQV);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesTEXTO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prTipo = new CampoconfiguracaoParametro();
        prTipo.setCampoconfiguracao(campoConfiguracao.getId());
        prTipo.setNome("tipo");
        prTipo.setValor("Simples");
        resultado.add(prTipo);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesCALCULO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prTipo = new CampoconfiguracaoParametro();
        prTipo.setCampoconfiguracao(campoConfiguracao.getId());
        prTipo.setNome("tipo");
        prTipo.setValor(NUMERICO);
        resultado.add(prTipo);
        CampoconfiguracaoParametro prDecimal = new CampoconfiguracaoParametro();
        prDecimal.setCampoconfiguracao(campoConfiguracao.getId());
        prDecimal.setNome("casas_decimal");
        prDecimal.setValor("0");
        resultado.add(prDecimal);
        CampoconfiguracaoParametro prLQ = new CampoconfiguracaoParametro();
        prLQ.setCampoconfiguracao(campoConfiguracao.getId());
        prLQ.setNome("lq");
        prLQ.setValor("0");
        resultado.add(prLQ);
        CampoconfiguracaoParametro prLQV = new CampoconfiguracaoParametro();
        prLQV.setCampoconfiguracao(campoConfiguracao.getId());
        prLQV.setNome("exibir_lq");
        prLQV.setValor("L.Q.");
        resultado.add(prLQV);
        CampoconfiguracaoParametro prFaixaValores = new CampoconfiguracaoParametro();
        prFaixaValores.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaValores.setNome("faixa_valores");
        prFaixaValores.setValor("false");
        resultado.add(prFaixaValores);
        CampoconfiguracaoParametro prFaixaMin = new CampoconfiguracaoParametro();
        prFaixaMin.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaMin.setNome("faixa_min");
        prFaixaMin.setValor("0");
        resultado.add(prFaixaMin);
        CampoconfiguracaoParametro prFaixaMax = new CampoconfiguracaoParametro();
        prFaixaMax.setCampoconfiguracao(campoConfiguracao.getId());
        prFaixaMax.setNome("faixa_max");
        prFaixaMax.setValor("0");
        resultado.add(prFaixaMax);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesSELECAO_UNICA(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro pr = new CampoconfiguracaoParametro();
        pr.setCampoconfiguracao(campoConfiguracao.getId());
        pr.setNome("opcoes");
        pr.setValor("");
        resultado.add(pr);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesSIM_NAO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prTipo = new CampoconfiguracaoParametro();
        prTipo.setCampoconfiguracao(campoConfiguracao.getId());
        prTipo.setNome("tipo");
        prTipo.setValor("Simples");
        resultado.add(prTipo);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesCURVA_CALIBRACAO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prDecimal = new CampoconfiguracaoParametro();
        prDecimal.setCampoconfiguracao(campoConfiguracao.getId());
        prDecimal.setNome("casas_decimal");
        prDecimal.setValor("0");
        resultado.add(prDecimal);
        CampoconfiguracaoParametro prTipo = new CampoconfiguracaoParametro();
        prTipo.setCampoconfiguracao(campoConfiguracao.getId());
        prTipo.setNome("tipo");
        prTipo.setValor("Direto");
        resultado.add(prTipo);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesDATA(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prTipo = new CampoconfiguracaoParametro();
        prTipo.setCampoconfiguracao(campoConfiguracao.getId());
        prTipo.setNome("tipo");
        prTipo.setValor("Simples");
        resultado.add(prTipo);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesCONSTANTE(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        CampoconfiguracaoParametro prDecimal = new CampoconfiguracaoParametro();
        prDecimal.setCampoconfiguracao(campoConfiguracao.getId());
        prDecimal.setNome("casas_decimal");
        prDecimal.setValor("0");
        resultado.add(prDecimal);
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesSEQUENCIA(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesQRCODE(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesPRODUTO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesEQUIPAMENTO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        return resultado;
    }

    private static List<CampoconfiguracaoParametro> loadPadroesSOLUCAO(Campoconfiguracao campoConfiguracao) {
        ArrayList<CampoconfiguracaoParametro> resultado = new ArrayList<CampoconfiguracaoParametro>();
        return resultado;
    }
}

