/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.cadastro;

import ceresonemodel.analise.ConvenioPreco;
import ceresonemodel.analise.ConvenioPrecoGrupo;
import ceresonemodel.analise.GrupoPacote;
import ceresonemodel.analise.PacotePreco;
import ceresonemodel.dao.DAO_LAB;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Convenio
implements Serializable {
    private long id;
    private String nome;
    private boolean ativo;
    @JsonIgnore
    private boolean editado = false;
    @JsonIgnore
    private List<ConvenioPreco> convenioPrecos = new ArrayList<ConvenioPreco>();
    @JsonIgnore
    private List<ConvenioPrecoGrupo> convenioPrecosGrupo = new ArrayList<ConvenioPrecoGrupo>();

    public boolean equals(Object o) {
        try {
            Convenio tmp = (Convenio)o;
            return tmp.id == this.id;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getNome();
    }

    public void carregaConvenioPrecos(DAO_LAB dao, List<PacotePreco> pacotes) throws Exception {
        this.convenioPrecos.clear();
        List<ConvenioPreco> cps = Arrays.asList((ConvenioPreco[])dao.listObject(ConvenioPreco[].class, "view_conveniopreco?convenio=eq." + this.getId() + "&order=view_pacotepreco_nome"));
        int indice = 0;
        for (PacotePreco pp : pacotes) {
            ConvenioPreco x = null;
            for (ConvenioPreco cp : cps) {
                if (pp.getId() != cp.getPacotepreco().longValue()) continue;
                x = cp;
                break;
            }
            if (x == null) {
                x = new ConvenioPreco();
                x.setId(-1L * (this.getId() + (long)(++indice)));
                x.setConvenio(this.getId());
                x.setPacotepreco(pp.getId());
                x.setValor(-1.0f);
                x.setView_pacotepreco_nome(pp.getDescricao());
            }
            this.convenioPrecos.add(x);
        }
    }

    public void carregaConvenioPrecosGrupo(DAO_LAB dao, List<GrupoPacote> grupos) throws Exception {
        this.convenioPrecosGrupo.clear();
        List<ConvenioPrecoGrupo> cpgs = Arrays.asList((ConvenioPrecoGrupo[])dao.listObject(ConvenioPrecoGrupo[].class, "view_convenioprecogrupo?convenio=eq." + this.getId() + "&order=view_grupopacote_nome"));
        int indice = 0;
        for (GrupoPacote gp : grupos) {
            ConvenioPrecoGrupo x = null;
            for (ConvenioPrecoGrupo cp : cpgs) {
                if (gp.getId() != cp.getGrupopacote().longValue()) continue;
                x = cp;
                break;
            }
            if (x == null) {
                x = new ConvenioPrecoGrupo();
                x.setId(-1L * (this.getId() + (long)(++indice)));
                x.setConvenio(this.getId());
                x.setGrupopacote(gp.getId());
                x.setValor(-1.0f);
                x.setView_grupopacote_nome(gp.getDescricao());
            }
            this.convenioPrecosGrupo.add(x);
        }
    }

    public ConvenioPreco getConvenioPreco(PacotePreco pacote) {
        for (ConvenioPreco cp : this.convenioPrecos) {
            if (cp.getPacotepreco().longValue() != pacote.getId()) continue;
            return cp;
        }
        return null;
    }

    public ConvenioPrecoGrupo getConvenioPrecoGrupo(GrupoPacote grupo) {
        for (ConvenioPrecoGrupo cp : this.convenioPrecosGrupo) {
            if (cp.getGrupopacote().longValue() != grupo.getId()) continue;
            return cp;
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public boolean isEditado() {
        return this.editado;
    }

    public void setEditado(boolean editado) {
        this.editado = editado;
    }

    public List<ConvenioPreco> getConvenioPrecos() {
        return this.convenioPrecos;
    }

    public void setConvenioPrecos(List<ConvenioPreco> convenioPrecos) {
        this.convenioPrecos = convenioPrecos;
    }

    public List<ConvenioPrecoGrupo> getConvenioPrecosGrupo() {
        return this.convenioPrecosGrupo;
    }

    public void setConvenioPrecosGrupo(List<ConvenioPrecoGrupo> convenioPrecosGrupo) {
        this.convenioPrecosGrupo = convenioPrecosGrupo;
    }
}

