/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.bot;

import ceresonemodel.bot.Protocolo;
import ceresonemodel.cadastro.Pessoa;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.utils.FormatadorHTML;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ProtocoloUtil {
    private static final long TEMPO_CACHE_MS = 180000L;
    private static final Map<String, CachedContato> cacheContatos = new HashMap<String, CachedContato>();

    public static void carregaContatosVinculados(List<Protocolo> protocolos, DAO_LAB dao_lab) {
        try {
            long agora = System.currentTimeMillis();
            cacheContatos.entrySet().removeIf(entry -> agora - ((CachedContato)entry.getValue()).carregadoEm > 180000L);
            if (protocolos != null && !protocolos.isEmpty()) {
                String query = "view_pessoa";
                String or = "or=(";
                HashSet<String> numerosParaBuscar = new HashSet<String>();
                for (Protocolo protocolo : protocolos) {
                    String numero = protocolo.getNumero_usuario().trim();
                    CachedContato cache = cacheContatos.get(numero);
                    if (cache != null && agora - cache.carregadoEm <= 180000L) {
                        protocolo.setView_contato_nome(cache.nome);
                        continue;
                    }
                    numerosParaBuscar.add(numero);
                }
                if (!numerosParaBuscar.isEmpty()) {
                    int i = 0;
                    for (String numero : numerosParaBuscar) {
                        if (i++ > 0) {
                            or = or + ",";
                        }
                        or = or + "celular3.eq." + FormatadorHTML.urlEncode(numero);
                    }
                    or = or + ")";
                    String string = query + "?" + or;
                    Pessoa[] pessoas = (Pessoa[])dao_lab.listObject(Pessoa[].class, string);
                    for (Pessoa pessoa : pessoas) {
                        String numero = pessoa.getCelular3();
                        String nome = pessoa.toString();
                        cacheContatos.put(numero, new CachedContato(nome, agora));
                    }
                    for (Protocolo protocolo : protocolos) {
                        String numero = protocolo.getNumero_usuario().trim();
                        CachedContato cache = cacheContatos.get(numero);
                        if (cache != null) {
                            protocolo.setView_contato_nome(cache.nome);
                            continue;
                        }
                        protocolo.setView_contato_nome(null);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CachedContato {
        String nome;
        long carregadoEm;

        CachedContato(String nome, long carregadoEm) {
            this.nome = nome;
            this.carregadoEm = carregadoEm;
        }
    }
}

