/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import calculo.CalculaExpressoes;
import ceresonemodel.campos.CampoLancamentoAnaliseParametro;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class RotinaItemAmostra
implements Serializable {
    private long id;
    private Date data_aprovacao;
    private Long amostra;
    private Long rotinaitem;
    private int ordem;
    private long view_amostra_numero;
    private long view_amostra_ano;
    private String view_amostra_numero_ano;
    private String view_amostra_descricao;
    private long view_amostracontrole;
    private String view_amostrcontrole_descricao;
    private long view_pedido;
    private String view_profundidade;
    private String view_talhao;
    private Date view_amostra_data_aprovacao;
    private Date view_rotinaitem_data_aprovacao;
    @JsonIgnore
    private List<CampoLancamentoAnaliseParametro> camposLancamento = new ArrayList<CampoLancamentoAnaliseParametro>();
    @JsonIgnore
    private List<CampoLancamentoAnaliseParametro> campos_considerados_calculos = new ArrayList<CampoLancamentoAnaliseParametro>();
    @JsonIgnore
    private String rotina_ordem;

    public boolean equals(Object o) {
        try {
            RotinaItemAmostra tmp = (RotinaItemAmostra)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getView_amostra_numero_ano();
    }

    public String label() {
        String tmp = this.getView_amostra_descricao() != null ? this.getView_amostra_descricao() : "";
        tmp = tmp + (this.getView_profundidade() != null && !this.getView_profundidade().equals("") ? " - " + this.getView_profundidade() : "");
        tmp = tmp + (this.getView_talhao() != null && !this.getView_talhao().equals("") ? " - " + this.getView_talhao() : "");
        return tmp;
    }

    public void recalcular() {
        ArrayList<CampoLancamentoAnaliseParametro> campo_tmp = new ArrayList<CampoLancamentoAnaliseParametro>();
        campo_tmp.addAll(this.camposLancamento);
        campo_tmp.addAll(this.campos_considerados_calculos);
        this.camposLancamento = CalculaExpressoes.ordenarCalculos(this.camposLancamento);
        for (CampoLancamentoAnaliseParametro campo : this.camposLancamento) {
            if (!campo.getView_tipo().equals("Calculo")) continue;
            System.out.println("calculando " + this.toString() + " ->" + campo.getView_parametro_nome());
            String string = CalculaExpressoes.calculaExpressao(campo, campo_tmp);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getData_aprovacao() {
        return this.data_aprovacao;
    }

    public void setData_aprovacao(Date data_aprovacao) {
        this.data_aprovacao = data_aprovacao;
    }

    public Long getAmostra() {
        return this.amostra;
    }

    public void setAmostra(Long amostra) {
        this.amostra = amostra;
    }

    public Long getRotinaitem() {
        return this.rotinaitem;
    }

    public void setRotinaitem(Long rotinaitem) {
        this.rotinaitem = rotinaitem;
    }

    public int getOrdem() {
        return this.ordem;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }

    public String getView_amostra_numero_ano() {
        return this.view_amostra_numero_ano;
    }

    public void setView_amostra_numero_ano(String view_amostra_numero_ano) {
        this.view_amostra_numero_ano = view_amostra_numero_ano;
    }

    public String getView_amostra_descricao() {
        return this.view_amostra_descricao;
    }

    public void setView_amostra_descricao(String view_amostra_descricao) {
        this.view_amostra_descricao = view_amostra_descricao;
    }

    public long getView_amostracontrole() {
        return this.view_amostracontrole;
    }

    public void setView_amostracontrole(long view_amostracontrole) {
        this.view_amostracontrole = view_amostracontrole;
    }

    public String getView_amostrcontrole_descricao() {
        return this.view_amostrcontrole_descricao;
    }

    public void setView_amostrcontrole_descricao(String view_amostrcontrole_descricao) {
        this.view_amostrcontrole_descricao = view_amostrcontrole_descricao;
    }

    public List<CampoLancamentoAnaliseParametro> getCamposLancamento() {
        return this.camposLancamento;
    }

    public void setCamposLancamento(List<CampoLancamentoAnaliseParametro> camposLancamento) {
        this.camposLancamento = camposLancamento;
    }

    public long getView_pedido() {
        return this.view_pedido;
    }

    public void setView_pedido(long view_pedido) {
        this.view_pedido = view_pedido;
    }

    public List<CampoLancamentoAnaliseParametro> getCampos_considerados_calculos() {
        return this.campos_considerados_calculos;
    }

    public void setCampos_considerados_calculos(List<CampoLancamentoAnaliseParametro> campos_considerados_calculos) {
        this.campos_considerados_calculos = campos_considerados_calculos;
    }

    public String getView_profundidade() {
        return this.view_profundidade;
    }

    public void setView_profundidade(String view_profundidade) {
        this.view_profundidade = view_profundidade;
    }

    public String getView_talhao() {
        return this.view_talhao;
    }

    public void setView_talhao(String view_talhao) {
        this.view_talhao = view_talhao;
    }

    public long getView_amostra_numero() {
        return this.view_amostra_numero;
    }

    public void setView_amostra_numero(long view_amostra_numero) {
        this.view_amostra_numero = view_amostra_numero;
    }

    public long getView_amostra_ano() {
        return this.view_amostra_ano;
    }

    public void setView_amostra_ano(long view_amostra_ano) {
        this.view_amostra_ano = view_amostra_ano;
    }

    public Date getView_amostra_data_aprovacao() {
        return this.view_amostra_data_aprovacao;
    }

    public void setView_amostra_data_aprovacao(Date view_amostra_data_aprovacao) {
        this.view_amostra_data_aprovacao = view_amostra_data_aprovacao;
    }

    public Date getView_rotinaitem_data_aprovacao() {
        return this.view_rotinaitem_data_aprovacao;
    }

    public void setView_rotinaitem_data_aprovacao(Date view_rotinaitem_data_aprovacao) {
        this.view_rotinaitem_data_aprovacao = view_rotinaitem_data_aprovacao;
    }

    public String getRotina_ordem() {
        return this.rotina_ordem;
    }

    public void setRotina_ordem(String rotina_ordem) {
        this.rotina_ordem = rotina_ordem;
    }
}

