/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import ceresonemodel.analise.RotinaItemAmostra;
import ceresonemodel.campos.Rotinaitem_resumo_campoconfiguracoes;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.users.Usuario;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class RotinaItem
implements Serializable {
    private long id;
    private String analista;
    private Date data;
    private Date data_aprovacao;
    private String descricao;
    private int numeroduplicatas;
    private int quantidade;
    private Long analise;
    private Long metodo;
    private Long rotina;
    private Long metodopreparacao;
    private String view_rotina_numero_ano;
    private String view_metodo_nome;
    private String view_analista_padrao;
    private boolean view_metodo_acreditado;
    private int view_capacidade_tipo;
    private int view_capacidade_valor;
    private int view_metodo_ordem;
    private String view_analise_nome;
    private boolean view_analise_travar_leitura;
    @JsonIgnore
    private String resumo;

    public boolean equals(Object o) {
        try {
            RotinaItem tmp = (RotinaItem)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.view_rotina_numero_ano + " - " + this.view_metodo_nome;
    }

    @JsonIgnore
    public boolean leitura_bloqueada(Usuario usuario) {
        if (this.view_analise_travar_leitura) {
            if (usuario.isAdministrador() || usuario.isCeres()) {
                return false;
            }
            return !usuario.getLogin().equals(this.analista);
        }
        return false;
    }

    @JsonIgnore
    public boolean leitura_habilitada(Usuario usuario) {
        return !this.leitura_bloqueada(usuario);
    }

    @JsonIgnore
    public List<Rotinaitem_resumo_campoconfiguracoes> getResumoCampos(DAO_LAB dao) throws Exception {
        String query = "view_rotinaitem_resumo_campoconfiguracoes?rotinaitem=eq." + this.getId();
        return Arrays.asList((Rotinaitem_resumo_campoconfiguracoes[])dao.listObject(Rotinaitem_resumo_campoconfiguracoes[].class, query));
    }

    public void loadResumo(DAO_LAB dao) {
        try {
            this.resumo = this.getView_metodo_nome();
            this.resumo = this.resumo + (this.getView_analista_padrao() == null || this.getView_analista_padrao().equals("") ? "" : " - An\u00e1lista: " + this.getView_analista_padrao());
            this.resumo = this.resumo + "\n";
            String query = "view_rotinaitemamostra?rotinaitem=eq." + this.getId() + "&order=ordem";
            List<RotinaItemAmostra> ams = Arrays.asList((RotinaItemAmostra[])dao.listObject(RotinaItemAmostra[].class, query));
            ArrayList<RotinaItemAmostra> amostras = new ArrayList<RotinaItemAmostra>();
            ArrayList<RotinaItemAmostra> amostras_controles = new ArrayList<RotinaItemAmostra>();
            for (RotinaItemAmostra am : ams) {
                if (am.getView_amostracontrole() > 0L) {
                    amostras_controles.add(am);
                    continue;
                }
                amostras.add(am);
            }
            long ultimaAmostra = 0L;
            long anteriorAmostra = 0L;
            int contador = 0;
            for (RotinaItemAmostra am : amostras) {
                ++contador;
                if (amostras.size() == 1) {
                    this.resumo = this.resumo + am.getView_amostra_numero();
                    continue;
                }
                if (contador == amostras.size()) {
                    if (am.getView_amostra_numero() > ultimaAmostra + 1L) {
                        this.resumo = this.resumo + " \u00e0 " + ultimaAmostra;
                        this.resumo = this.resumo + " - " + am.getView_amostra_numero();
                        continue;
                    }
                    if (am.getView_amostra_numero() != ultimaAmostra + 1L) continue;
                    this.resumo = this.resumo + " \u00e0 " + am.getView_amostra_numero();
                    continue;
                }
                if (ultimaAmostra == 0L) {
                    this.resumo = this.resumo + am.getView_amostra_numero();
                    anteriorAmostra = am.getView_amostra_numero();
                } else if (am.getView_amostra_numero() > ultimaAmostra + 1L) {
                    if (ultimaAmostra != anteriorAmostra) {
                        this.resumo = this.resumo + " \u00e0 " + ultimaAmostra + " - " + am.getView_amostra_numero();
                        anteriorAmostra = am.getView_amostra_numero();
                    } else {
                        this.resumo = this.resumo + " - " + am.getView_amostra_numero();
                        anteriorAmostra = am.getView_amostra_numero();
                    }
                }
                ultimaAmostra = am.getView_amostra_numero();
            }
            this.resumo = this.resumo + "\nTotal de amostras: " + amostras.size();
            if (amostras_controles != null && !amostras_controles.isEmpty()) {
                String controles = "";
                for (RotinaItemAmostra controle : amostras_controles) {
                    controles = controles + (controles.equals("") ? "" : " | ");
                    controles = controles + controle.getOrdem() + ": " + controle.getView_amostra_numero();
                }
                this.resumo = this.resumo + "\nControles: " + controles;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAnalista() {
        return this.analista;
    }

    public void setAnalista(String analista) {
        this.analista = analista;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Date getData_aprovacao() {
        return this.data_aprovacao;
    }

    public void setData_aprovacao(Date data_aprovacao) {
        this.data_aprovacao = data_aprovacao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public int getNumeroduplicatas() {
        return this.numeroduplicatas;
    }

    public void setNumeroduplicatas(int numeroduplicatas) {
        this.numeroduplicatas = numeroduplicatas;
    }

    public int getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(int quantidade) {
        this.quantidade = quantidade;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public Long getMetodo() {
        return this.metodo;
    }

    public void setMetodo(Long metodo) {
        this.metodo = metodo;
    }

    public Long getRotina() {
        return this.rotina;
    }

    public void setRotina(Long rotina) {
        this.rotina = rotina;
    }

    public Long getMetodopreparacao() {
        return this.metodopreparacao;
    }

    public void setMetodopreparacao(Long metodopreparacao) {
        this.metodopreparacao = metodopreparacao;
    }

    public String getView_rotina_numero_ano() {
        return this.view_rotina_numero_ano;
    }

    public void setView_rotina_numero_ano(String view_rotina_numero_ano) {
        this.view_rotina_numero_ano = view_rotina_numero_ano;
    }

    public String getView_metodo_nome() {
        return this.view_metodo_nome;
    }

    public void setView_metodo_nome(String view_metodo_nome) {
        this.view_metodo_nome = view_metodo_nome;
    }

    public String getView_analista_padrao() {
        return this.view_analista_padrao;
    }

    public void setView_analista_padrao(String view_analista_padrao) {
        this.view_analista_padrao = view_analista_padrao;
    }

    public boolean isView_metodo_acreditado() {
        return this.view_metodo_acreditado;
    }

    public void setView_metodo_acreditado(boolean view_metodo_acreditado) {
        this.view_metodo_acreditado = view_metodo_acreditado;
    }

    public int getView_capacidade_tipo() {
        return this.view_capacidade_tipo;
    }

    public void setView_capacidade_tipo(int view_capacidade_tipo) {
        this.view_capacidade_tipo = view_capacidade_tipo;
    }

    public int getView_capacidade_valor() {
        return this.view_capacidade_valor;
    }

    public void setView_capacidade_valor(int view_capacidade_valor) {
        this.view_capacidade_valor = view_capacidade_valor;
    }

    public String getResumo() {
        return this.resumo;
    }

    public void setResumo(String resumo) {
        this.resumo = resumo;
    }

    public int getView_metodo_ordem() {
        return this.view_metodo_ordem;
    }

    public void setView_metodo_ordem(int view_metodo_ordem) {
        this.view_metodo_ordem = view_metodo_ordem;
    }

    public String getView_analise_nome() {
        return this.view_analise_nome;
    }

    public void setView_analise_nome(String view_analise_nome) {
        this.view_analise_nome = view_analise_nome;
    }

    public boolean isView_analise_travar_leitura() {
        return this.view_analise_travar_leitura;
    }

    public void setView_analise_travar_leitura(boolean view_analise_travar_leitura) {
        this.view_analise_travar_leitura = view_analise_travar_leitura;
    }
}

