/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import ceresonemodel.analise.AmostraControle;
import ceresonemodel.analise.RotinaItem;
import ceresonemodel.campos.RotinaAmostra;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.utils.CampoData;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Rotina
implements Serializable {
    private long id;
    private int ano;
    private Date data_aprovacao;
    private Date data_liberado;
    private String descricao;
    private long numero;
    private Date rotina_data;
    private int total_amostras;
    private Long analise;
    private boolean preparacao;
    private int ordenacao;
    private boolean priorizar_urgentes;
    private Date cancelado;
    private String tipo_intervalo;
    private String view_analise_nome;
    private boolean view_analise_nematoide;
    private boolean view_analise_fazenda;
    private boolean view_analise_talhao;
    private int view_quantidade_metodos;
    @JsonIgnore
    private String resumo;

    public boolean equals(Object o) {
        try {
            Rotina tmp = (Rotina)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getNumero() > 0L ? this.getNumero() + "/" + this.getAno() : "?";
    }

    public static Rotina carregaRotina(long rotina_id, DAO_LAB dao) {
        try {
            Rotina rotina = null;
            Rotina[] x = (Rotina[])dao.listObject(Rotina[].class, "view_rotina?id=eq." + rotina_id);
            if (x.length > 0) {
                rotina = x[0];
            }
            return rotina;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadResumo(DAO_LAB dao, List<RotinaItem> ris) {
        try {
            this.resumo = "Cria\u00e7\u00e3o: " + CampoData.dataToString(this.rotina_data) + "\n";
            this.resumo = this.resumo + "Quantidade de m\u00e9todos: " + ris.size() + "\n";
            this.resumo = this.resumo + "Amostras: ";
            ArrayList<Long> rotinaitem_ids = new ArrayList<Long>();
            for (RotinaItem ri : ris) {
                rotinaitem_ids.add(ri.getId());
            }
            List<RotinaAmostra> ras = dao.fnc_rotima_amostras(rotinaitem_ids);
            ArrayList<RotinaAmostra> amostras = new ArrayList<RotinaAmostra>();
            ArrayList<RotinaAmostra> amostras_controles = new ArrayList<RotinaAmostra>();
            List<AmostraControle> am_controles = Arrays.asList((AmostraControle[])dao.listObject(AmostraControle[].class, "amostracontrole?analise=eq." + this.getAnalise()));
            for (RotinaAmostra am : ras) {
                if (am.getAmostracontrole() != null && am.getAmostracontrole() > 0L) {
                    for (AmostraControle am_controle : am_controles) {
                        if (am.getAmostracontrole().longValue() != am_controle.getId()) continue;
                        am.setView_amostracontrole_nome(am_controle.getDescricao());
                        break;
                    }
                    amostras_controles.add(am);
                    continue;
                }
                amostras.add(am);
            }
            long ultimaAmostra = 0L;
            long anteriorAmostra = 0L;
            int contador = 0;
            for (RotinaAmostra am : amostras) {
                ++contador;
                int am_numero = Integer.parseInt(am.getNumero());
                if (amostras.size() == 1) {
                    this.resumo = this.resumo + am.getNumero();
                    continue;
                }
                if (contador == amostras.size()) {
                    if ((long)am_numero > ultimaAmostra + 1L) {
                        this.resumo = this.resumo + " \u00e0 " + ultimaAmostra;
                        this.resumo = this.resumo + " - " + am.getNumero();
                        continue;
                    }
                    if ((long)am_numero != ultimaAmostra + 1L) continue;
                    this.resumo = this.resumo + " \u00e0 " + am.getNumero();
                    continue;
                }
                if (ultimaAmostra == 0L) {
                    this.resumo = this.resumo + am.getNumero();
                    anteriorAmostra = Long.parseLong(am.getNumero());
                } else if ((long)am_numero > ultimaAmostra + 1L) {
                    if (ultimaAmostra != anteriorAmostra) {
                        this.resumo = this.resumo + " \u00e0 " + ultimaAmostra + " - " + am.getNumero();
                        anteriorAmostra = Long.parseLong(am.getNumero());
                    } else {
                        this.resumo = this.resumo + " - " + am.getNumero();
                        anteriorAmostra = Long.parseLong(am.getNumero());
                    }
                }
                ultimaAmostra = Long.parseLong(am.getNumero());
            }
            this.resumo = this.resumo + "\nTotal de amostras: " + amostras.size();
            if (amostras_controles != null && !amostras_controles.isEmpty()) {
                String controles = "";
                for (RotinaAmostra controle : amostras_controles) {
                    controles = controles + (controles.equals("") ? "" : " | ");
                    controles = controles + controle.getOrdem() + ": " + controle.getNumero() + "(" + controle.getView_amostracontrole_nome() + ")";
                }
                this.resumo = this.resumo + "\nControles: " + controles;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getAno() {
        return this.ano;
    }

    public void setAno(int ano) {
        this.ano = ano;
    }

    public Date getData_aprovacao() {
        return this.data_aprovacao;
    }

    public void setData_aprovacao(Date data_aprovacao) {
        this.data_aprovacao = data_aprovacao;
    }

    public Date getData_liberado() {
        return this.data_liberado;
    }

    public void setData_liberado(Date data_liberado) {
        this.data_liberado = data_liberado;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public long getNumero() {
        return this.numero;
    }

    public void setNumero(long numero) {
        this.numero = numero;
    }

    public Date getRotina_data() {
        return this.rotina_data;
    }

    public void setRotina_data(Date rotina_data) {
        this.rotina_data = rotina_data;
    }

    public int getTotal_amostras() {
        return this.total_amostras;
    }

    public void setTotal_amostras(int total_amostras) {
        this.total_amostras = total_amostras;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public boolean isPreparacao() {
        return this.preparacao;
    }

    public void setPreparacao(boolean preparacao) {
        this.preparacao = preparacao;
    }

    public int getOrdenacao() {
        return this.ordenacao;
    }

    public void setOrdenacao(int ordenacao) {
        this.ordenacao = ordenacao;
    }

    public boolean isPriorizar_urgentes() {
        return this.priorizar_urgentes;
    }

    public void setPriorizar_urgentes(boolean priorizar_urgentes) {
        this.priorizar_urgentes = priorizar_urgentes;
    }

    public String getTipo_intervalo() {
        return this.tipo_intervalo;
    }

    public void setTipo_intervalo(String tipo_intervalo) {
        this.tipo_intervalo = tipo_intervalo;
    }

    public String getView_analise_nome() {
        return this.view_analise_nome;
    }

    public void setView_analise_nome(String view_analise_nome) {
        this.view_analise_nome = view_analise_nome;
    }

    public boolean isView_analise_nematoide() {
        return this.view_analise_nematoide;
    }

    public void setView_analise_nematoide(boolean view_analise_nematoide) {
        this.view_analise_nematoide = view_analise_nematoide;
    }

    public boolean isView_analise_fazenda() {
        return this.view_analise_fazenda;
    }

    public void setView_analise_fazenda(boolean view_analise_fazenda) {
        this.view_analise_fazenda = view_analise_fazenda;
    }

    public boolean isView_analise_talhao() {
        return this.view_analise_talhao;
    }

    public void setView_analise_talhao(boolean view_analise_talhao) {
        this.view_analise_talhao = view_analise_talhao;
    }

    public int getView_quantidade_metodos() {
        return this.view_quantidade_metodos;
    }

    public void setView_quantidade_metodos(int view_quantidade_metodos) {
        this.view_quantidade_metodos = view_quantidade_metodos;
    }

    public Date getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Date cancelado) {
        this.cancelado = cancelado;
    }

    public String getResumo() {
        return this.resumo;
    }

    public void setResumo(String resumo) {
        this.resumo = resumo;
    }
}

