/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import ceresonemodel.analise.Analise;
import ceresonemodel.analise.Pedido_resumo;
import ceresonemodel.analise.Pedido_tipos_analise_resumo;
import ceresonemodel.cadastro.Fazenda;
import ceresonemodel.cadastro.Pessoa;
import ceresonemodel.campos.AmostraLancamento;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.laudomodelo.LaudoModelo_onedesk_pedido;
import ceresonemodel.laudomodelo.Laudomodelo_onedesk;
import ceresonemodel.utils.CampoData;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Pedido
implements Serializable {
    private long id;
    private long numero;
    private int ano;
    private Date emissao;
    private Date entrada;
    private Date previsao;
    private Date liberadolab;
    private Date geracao;
    private Date alocacao;
    private Date cancelamento;
    private Date dtaprovacao;
    private Date dtaprovacaofinanceiro;
    private Date envio;
    private Date obsdata;
    private String justificativa;
    private String observacao;
    private boolean processando;
    private boolean amostrasremotas;
    private boolean aprovadofinanceiro;
    private String obscliente;
    private String obsresponsavel;
    private float frete;
    private float desconto;
    private float valor;
    private float valorbruto;
    private String results;
    private String laudoresouce_modelos;
    private Long responsavel;
    private Long analise;
    private Long cliente;
    private Long solicitante;
    private Long cobranca;
    private Long recebimentoamostra;
    private Long orcamento;
    private Long fazenda;
    private Long cultura;
    private Long frota;
    private Long mecanismofrota;
    private Long oleomarca;
    private Long oleo;
    private Long fatura;
    private Long convenio;
    private Long integracao;
    private Long solicitacao;
    private String dataceres_log;
    private String dataceres_id;
    private Date dataceres_envio;
    private boolean dataceres_aguardar_pagamento;
    private Date integracao_envio;
    private String integracao_log;
    private String locker;
    private String view_numero_ano;
    private String view_cliente_nome;
    private String view_solicitante_nome;
    private String view_cobranca_nome;
    private String view_cultura_nome;
    private String view_fazenda_nome;
    private String view_fazenda_proprietario;
    private String view_analise_nome;
    private boolean view_analise_cultrua;
    private boolean view_analise_fazenda;
    private boolean view_analise_profundidade;
    private boolean view_analise_talhao;
    private boolean view_analise_nematoide;
    private String view_analise_dataceres_id;
    private String view_recebimentoamostra_numero_ano;
    private String view_responsavel_nome;
    private String view_orcamento_numero_ano;
    private String view_fatura_numero_ano;
    private Date view_fatura_datapagamento;
    private String view_convenio_nome;
    private String view_integracao_nome;
    private String view_integracao_token;
    private String view_laudos;
    private boolean view_analise_laudoporamostra;
    private float view_valor_aditivos;
    private float view_fatura_valorliquido;
    private float view_fatura_valorbruto;
    private float view_fatura_frete;
    private float view_fatura_desconto;
    private float view_fatura_valorpago;
    @JsonIgnore
    private List<Laudomodelo_onedesk> laudos_modelo = new ArrayList<Laudomodelo_onedesk>();
    @JsonIgnore
    private List<Pedido_tipos_analise_resumo> tipos_analise_resumo = new ArrayList<Pedido_tipos_analise_resumo>();
    @JsonIgnore
    private Pedido_resumo resumo;
    @JsonIgnore
    private Pessoa cliente_obj;
    @JsonIgnore
    private Pessoa solicitante_obj;
    @JsonIgnore
    private Pessoa cobranca_obj;
    @JsonIgnore
    private Fazenda fazenda_obj;
    @JsonIgnore
    private String status;

    public void carregaObj(DAO_LAB dao) {
        try {
            List<Pessoa> clientes = Arrays.asList((Pessoa[])dao.listObject(Pessoa[].class, "view_pessoa?id=eq." + this.getCliente()));
            this.cliente_obj = clientes.get(0);
            if (this.solicitante.longValue() == this.cliente.longValue()) {
                this.solicitante_obj = clientes.get(0);
            } else {
                List<Pessoa> solicitantes = Arrays.asList((Pessoa[])dao.listObject(Pessoa[].class, "view_pessoa?id=eq." + this.getSolicitante()));
                this.solicitante_obj = solicitantes.get(0);
            }
            if (this.cobranca.longValue() == this.cliente.longValue()) {
                this.cobranca_obj = clientes.get(0);
            } else {
                List<Pessoa> cobrancas = Arrays.asList((Pessoa[])dao.listObject(Pessoa[].class, "view_pessoa?id=eq." + this.getCobranca()));
                this.cobranca_obj = cobrancas.get(0);
            }
            List<Fazenda> fazendas = Arrays.asList((Fazenda[])dao.listObject(Fazenda[].class, "view_fazenda?id=eq." + this.getFazenda()));
            if (fazendas != null && !fazendas.isEmpty()) {
                this.fazenda_obj = fazendas.get(0);
            }
            ArrayList<Pedido> pedidos = new ArrayList<Pedido>();
            pedidos.add(this);
            Pedido_resumo.loadResumos4Pedidos(pedidos, dao);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String verificaInsert() throws Exception {
        if (this.cliente == null || this.convenio == null || this.analise == null) {
            return "Existem campos obrigat\u00f3rios que n\u00e3o foram preenchidos!\nAn\u00e1lise, Cliente ou Conv\u00eanio.";
        }
        String calcularValor = this.calculaValor();
        if (calcularValor != null) {
            return calcularValor;
        }
        if (this.emissao == null) {
            this.emissao = new Date();
        }
        if (this.entrada == null) {
            this.entrada = new Date();
        }
        if (this.solicitante == null) {
            this.solicitante = this.cliente;
            this.view_solicitante_nome = this.view_cliente_nome;
        }
        if (this.cobranca == null) {
            this.cobranca = this.cliente;
            this.view_cobranca_nome = this.view_cliente_nome;
        }
        return null;
    }

    public String verificaUpdate() throws Exception {
        String calcularValor = this.calculaValor();
        if (calcularValor != null) {
            return calcularValor;
        }
        return null;
    }

    private String calculaValor() throws Exception {
        if (this.frete < 0.0f || this.desconto < 0.0f) {
            return "Valores em Frete / Desconto n\u00e3o pode ser negativos!";
        }
        this.valor = this.valorbruto - this.desconto + this.frete;
        this.valor = this.valor <= 0.0f ? 0.0f : this.valor;
        return null;
    }

    public boolean equals(Object o) {
        try {
            Pedido tmp = (Pedido)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getNumero() > 0L ? this.getNumero() + "/" + this.getAno() : "?";
    }

    public String situacao() {
        String resultado = "";
        if (this.cancelamento == null && this.liberadolab != null) {
            resultado = resultado + "Aprovado: " + CampoData.dataToString(this.liberadolab) + " \n";
        }
        if (this.cancelamento != null) {
            resultado = resultado + "Cancelado: " + CampoData.dataToString(this.cancelamento) + " \n";
        }
        if (this.cancelamento == null && this.envio != null) {
            resultado = resultado + "Enviado: " + CampoData.dataToString(this.envio) + " \n";
        }
        if (this.fatura == null) {
            resultado = resultado + "N\u00e3o faturado. \n";
        }
        if (this.fatura != null) {
            resultado = resultado + "Fatura: " + this.view_fatura_numero_ano + (this.view_fatura_datapagamento != null ? " Data Pgt: " + CampoData.dataToString(this.view_fatura_datapagamento) : "") + " \n";
        }
        return resultado;
    }

    public void checaGeracao(DAO_LAB dao) throws Exception {
        this.setGeracao(dao.fnc_atualiza_geracao_pedido(this.id));
    }

    public void loadResumo(DAO_LAB dao) throws Exception {
        ArrayList<Pedido> ps = new ArrayList<Pedido>();
        ps.add(this);
        Pedido_resumo.loadResumos4Pedidos(ps, dao);
    }

    public void carregaLaudoModelos(DAO_LAB dao_lab) throws Exception {
        Laudomodelo_onedesk[] tmps = null;
        LaudoModelo_onedesk_pedido[] lms_pedido = (LaudoModelo_onedesk_pedido[])dao_lab.listObject(LaudoModelo_onedesk_pedido[].class, "laudomodelo_onedesk_pedido?pedido=eq." + this.getId());
        if (lms_pedido != null) {
            String query = "";
            ArrayList<Long> tmp = new ArrayList<Long>();
            for (LaudoModelo_onedesk_pedido uc : lms_pedido) {
                if (tmp.contains(uc.getLaudomodelo_onedesk())) continue;
                tmp.add(uc.getLaudomodelo_onedesk());
                if (query != "") {
                    query = query + ",";
                }
                query = query + "id.eq." + uc.getLaudomodelo_onedesk();
            }
            if (tmp.size() > 0) {
                query = "laudomodelo_onedesk?or=(" + query + ")";
                tmps = (Laudomodelo_onedesk[])dao_lab.listObject(Laudomodelo_onedesk[].class, query);
            }
        }
        if (tmps != null) {
            this.laudos_modelo = new ArrayList<Laudomodelo_onedesk>();
            this.laudos_modelo.addAll(Arrays.asList(tmps));
        } else {
            this.setLaudos_modelo(new ArrayList<Laudomodelo_onedesk>());
        }
    }

    public void salvarLaudosPadroes(DAO_LAB dao) throws Exception {
        Pessoa p = new Pessoa();
        p.setId(this.getCliente());
        p.carregaLaudoModelos(dao);
        List<Laudomodelo_onedesk> modelos = new ArrayList<Laudomodelo_onedesk>();
        for (Laudomodelo_onedesk laudo : p.getLaudos_modelo()) {
            if (laudo.getAnalise().longValue() != this.getAnalise().longValue()) continue;
            modelos.add(laudo);
        }
        if (modelos.isEmpty()) {
            Analise a = new Analise();
            a.setId(this.getAnalise());
            a.carregaLaudoModelos(dao);
            List<Laudomodelo_onedesk> ps_analise = a.getLaudos_modelo();
            if (ps_analise != null && !ps_analise.isEmpty()) {
                modelos = ps_analise;
            }
        }
        for (Laudomodelo_onedesk laudo : modelos) {
            LaudoModelo_onedesk_pedido x = new LaudoModelo_onedesk_pedido();
            x.setId(dao.getSeq());
            x.setPedido(this.getId());
            x.setLaudomodelo_onedesk(laudo.getId());
            dao.includeObject(x, "laudomodelo_onedesk_pedido");
        }
    }

    public boolean podeImportar() {
        return this.cliente != null && this.cliente != 0L && this.fazenda != null && this.fazenda != 0L && this.analise != null && this.analise != 0L && this.convenio != null && this.convenio != 0L;
    }

    public static Pedido carregaPedido(long pedido_id, DAO_LAB dao) {
        try {
            Pedido pedido = null;
            Pedido[] x = (Pedido[])dao.listObject(Pedido[].class, "view_pedido?id=eq." + pedido_id);
            if (x.length > 0) {
                pedido = x[0];
            }
            return pedido;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<AmostraLancamento> getAmostrasLancamento(DAO_LAB dao) throws Exception {
        List<AmostraLancamento> amostras_lancamento = Arrays.asList((AmostraLancamento[])dao.listObject(AmostraLancamento[].class, "view_amostralancamento?view_pedido_id=eq." + this.getId()));
        if (amostras_lancamento != null) {
            return amostras_lancamento;
        }
        return new ArrayList<AmostraLancamento>();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getNumero() {
        return this.numero;
    }

    public void setNumero(long numero) {
        this.numero = numero;
    }

    public int getAno() {
        return this.ano;
    }

    public void setAno(int ano) {
        this.ano = ano;
    }

    public Date getEmissao() {
        return this.emissao;
    }

    public void setEmissao(Date emissao) {
        this.emissao = emissao;
    }

    public Date getEntrada() {
        return this.entrada;
    }

    public void setEntrada(Date entrada) {
        this.entrada = entrada;
    }

    public Date getPrevisao() {
        return this.previsao;
    }

    public void setPrevisao(Date previsao) {
        this.previsao = previsao;
    }

    public Date getLiberadolab() {
        return this.liberadolab;
    }

    public void setLiberadolab(Date liberadolab) {
        this.liberadolab = liberadolab;
    }

    public Date getGeracao() {
        return this.geracao;
    }

    public void setGeracao(Date geracao) {
        this.geracao = geracao;
    }

    public Date getAlocacao() {
        return this.alocacao;
    }

    public void setAlocacao(Date alocacao) {
        this.alocacao = alocacao;
    }

    public Date getCancelamento() {
        return this.cancelamento;
    }

    public void setCancelamento(Date cancelamento) {
        this.cancelamento = cancelamento;
    }

    public Date getDtaprovacao() {
        return this.dtaprovacao;
    }

    public void setDtaprovacao(Date dtaprovacao) {
        this.dtaprovacao = dtaprovacao;
    }

    public Date getDtaprovacaofinanceiro() {
        return this.dtaprovacaofinanceiro;
    }

    public void setDtaprovacaofinanceiro(Date dtaprovacaofinanceiro) {
        this.dtaprovacaofinanceiro = dtaprovacaofinanceiro;
    }

    public Date getEnvio() {
        return this.envio;
    }

    public void setEnvio(Date envio) {
        this.envio = envio;
    }

    public Date getObsdata() {
        return this.obsdata;
    }

    public void setObsdata(Date obsdata) {
        this.obsdata = obsdata;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean isProcessando() {
        return this.processando;
    }

    public void setProcessando(boolean processando) {
        this.processando = processando;
    }

    public boolean isAmostrasremotas() {
        return this.amostrasremotas;
    }

    public void setAmostrasremotas(boolean amostrasremotas) {
        this.amostrasremotas = amostrasremotas;
    }

    public boolean isAprovadofinanceiro() {
        return this.aprovadofinanceiro;
    }

    public void setAprovadofinanceiro(boolean aprovadofinanceiro) {
        this.aprovadofinanceiro = aprovadofinanceiro;
    }

    public float getFrete() {
        return this.frete;
    }

    public void setFrete(float frete) {
        this.frete = frete;
    }

    public float getDesconto() {
        return this.desconto;
    }

    public void setDesconto(float desconto) {
        this.desconto = desconto;
    }

    public String getObscliente() {
        return this.obscliente;
    }

    public void setObscliente(String obscliente) {
        this.obscliente = obscliente;
    }

    public String getObsresponsavel() {
        return this.obsresponsavel;
    }

    public void setObsresponsavel(String obsresponsavel) {
        this.obsresponsavel = obsresponsavel;
    }

    public float getValor() {
        return this.valor;
    }

    public void setValor(float valor) {
        this.valor = valor;
    }

    public float getValorbruto() {
        return this.valorbruto;
    }

    public void setValorbruto(float valorbruto) {
        this.valorbruto = valorbruto;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public String getView_numero_ano() {
        return this.view_numero_ano;
    }

    public void setView_numero_ano(String view_numero_ano) {
        this.view_numero_ano = view_numero_ano;
    }

    public String getView_cliente_nome() {
        return this.view_cliente_nome;
    }

    public void setView_cliente_nome(String view_cliente_nome) {
        this.view_cliente_nome = view_cliente_nome;
    }

    public String getView_solicitante_nome() {
        return this.view_solicitante_nome;
    }

    public void setView_solicitante_nome(String view_solicitante_nome) {
        this.view_solicitante_nome = view_solicitante_nome;
    }

    public String getView_cobranca_nome() {
        return this.view_cobranca_nome;
    }

    public void setView_cobranca_nome(String view_cobranca_nome) {
        this.view_cobranca_nome = view_cobranca_nome;
    }

    public String getView_cultura_nome() {
        return this.view_cultura_nome;
    }

    public void setView_cultura_nome(String view_cultura_nome) {
        this.view_cultura_nome = view_cultura_nome;
    }

    public String getView_fazenda_nome() {
        return this.view_fazenda_nome;
    }

    public void setView_fazenda_nome(String view_fazenda_nome) {
        this.view_fazenda_nome = view_fazenda_nome;
    }

    public String getView_fazenda_proprietario() {
        return this.view_fazenda_proprietario;
    }

    public void setView_fazenda_proprietario(String view_fazenda_proprietario) {
        this.view_fazenda_proprietario = view_fazenda_proprietario;
    }

    public String getView_analise_nome() {
        return this.view_analise_nome;
    }

    public void setView_analise_nome(String view_analise_nome) {
        this.view_analise_nome = view_analise_nome;
    }

    public boolean isView_analise_cultrua() {
        return this.view_analise_cultrua;
    }

    public void setView_analise_cultrua(boolean view_analise_cultrua) {
        this.view_analise_cultrua = view_analise_cultrua;
    }

    public boolean isView_analise_fazenda() {
        return this.view_analise_fazenda;
    }

    public void setView_analise_fazenda(boolean view_analise_fazenda) {
        this.view_analise_fazenda = view_analise_fazenda;
    }

    public boolean isView_analise_talhao() {
        return this.view_analise_talhao;
    }

    public void setView_analise_talhao(boolean view_analise_talhao) {
        this.view_analise_talhao = view_analise_talhao;
    }

    public boolean isView_analise_nematoide() {
        return this.view_analise_nematoide;
    }

    public void setView_analise_nematoide(boolean view_analise_nematoide) {
        this.view_analise_nematoide = view_analise_nematoide;
    }

    public String getView_recebimentoamostra_numero_ano() {
        return this.view_recebimentoamostra_numero_ano;
    }

    public void setView_recebimentoamostra_numero_ano(String view_recebimentoamostra_numero_ano) {
        this.view_recebimentoamostra_numero_ano = view_recebimentoamostra_numero_ano;
    }

    public String getView_responsavel_nome() {
        return this.view_responsavel_nome;
    }

    public void setView_responsavel_nome(String view_responsavel_nome) {
        this.view_responsavel_nome = view_responsavel_nome;
    }

    public String getView_orcamento_numero_ano() {
        return this.view_orcamento_numero_ano;
    }

    public void setView_orcamento_numero_ano(String view_orcamento_numero_ano) {
        this.view_orcamento_numero_ano = view_orcamento_numero_ano;
    }

    public String getView_fatura_numero_ano() {
        return this.view_fatura_numero_ano;
    }

    public void setView_fatura_numero_ano(String view_fatura_numero_ano) {
        this.view_fatura_numero_ano = view_fatura_numero_ano;
    }

    public Date getView_fatura_datapagamento() {
        return this.view_fatura_datapagamento;
    }

    public void setView_fatura_datapagamento(Date view_fatura_datapagamento) {
        this.view_fatura_datapagamento = view_fatura_datapagamento;
    }

    public String getView_convenio_nome() {
        return this.view_convenio_nome;
    }

    public void setView_convenio_nome(String view_convenio_nome) {
        this.view_convenio_nome = view_convenio_nome;
    }

    public String getView_integracao_nome() {
        return this.view_integracao_nome;
    }

    public void setView_integracao_nome(String view_integracao_nome) {
        this.view_integracao_nome = view_integracao_nome;
    }

    public String getView_integracao_token() {
        return this.view_integracao_token;
    }

    public void setView_integracao_token(String view_integracao_token) {
        this.view_integracao_token = view_integracao_token;
    }

    public String getView_laudos() {
        return this.view_laudos;
    }

    public void setView_laudos(String view_laudos) {
        this.view_laudos = view_laudos;
    }

    public Long getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Long responsavel) {
        this.responsavel = responsavel;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public Long getCliente() {
        return this.cliente;
    }

    public void setCliente(Long cliente) {
        this.cliente = cliente;
    }

    public Long getCobranca() {
        return this.cobranca;
    }

    public void setCobranca(Long cobranca) {
        this.cobranca = cobranca;
    }

    public Long getRecebimentoamostra() {
        return this.recebimentoamostra;
    }

    public void setRecebimentoamostra(Long recebimentoamostra) {
        this.recebimentoamostra = recebimentoamostra;
    }

    public Long getOrcamento() {
        return this.orcamento;
    }

    public void setOrcamento(Long orcamento) {
        this.orcamento = orcamento;
    }

    public Long getFazenda() {
        return this.fazenda;
    }

    public void setFazenda(Long fazenda) {
        this.fazenda = fazenda;
    }

    public Long getCultura() {
        return this.cultura;
    }

    public void setCultura(Long cultura) {
        this.cultura = cultura;
    }

    public Long getFrota() {
        return this.frota;
    }

    public void setFrota(Long frota) {
        this.frota = frota;
    }

    public Long getMecanismofrota() {
        return this.mecanismofrota;
    }

    public void setMecanismofrota(Long mecanismofrota) {
        this.mecanismofrota = mecanismofrota;
    }

    public Long getOleomarca() {
        return this.oleomarca;
    }

    public void setOleomarca(Long oleomarca) {
        this.oleomarca = oleomarca;
    }

    public Long getOleo() {
        return this.oleo;
    }

    public void setOleo(Long oleo) {
        this.oleo = oleo;
    }

    public Long getFatura() {
        return this.fatura;
    }

    public void setFatura(Long fatura) {
        this.fatura = fatura;
    }

    public Long getConvenio() {
        return this.convenio;
    }

    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    public Long getIntegracao() {
        return this.integracao;
    }

    public void setIntegracao(Long integracao) {
        this.integracao = integracao;
    }

    public Long getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(Long solicitacao) {
        this.solicitacao = solicitacao;
    }

    public String getLaudoresouce_modelos() {
        return this.laudoresouce_modelos;
    }

    public void setLaudoresouce_modelos(String laudoresouce_modelos) {
        this.laudoresouce_modelos = laudoresouce_modelos;
    }

    public boolean isView_analise_profundidade() {
        return this.view_analise_profundidade;
    }

    public void setView_analise_profundidade(boolean view_analise_profundidade) {
        this.view_analise_profundidade = view_analise_profundidade;
    }

    public List<Laudomodelo_onedesk> getLaudos_modelo() {
        return this.laudos_modelo;
    }

    public void setLaudos_modelo(List<Laudomodelo_onedesk> laudos_modelo) {
        this.laudos_modelo = laudos_modelo;
    }

    public boolean isView_analise_laudoporamostra() {
        return this.view_analise_laudoporamostra;
    }

    public void setView_analise_laudoporamostra(boolean view_analise_laudoporamostra) {
        this.view_analise_laudoporamostra = view_analise_laudoporamostra;
    }

    public Pedido_resumo getResumo() {
        return this.resumo;
    }

    public void setResumo(Pedido_resumo resumo) {
        this.resumo = resumo;
    }

    public Long getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Long solicitante) {
        this.solicitante = solicitante;
    }

    public String getDataceres_id() {
        return this.dataceres_id;
    }

    public void setDataceres_id(String dataceres_id) {
        this.dataceres_id = dataceres_id;
    }

    public Date getDataceres_envio() {
        return this.dataceres_envio;
    }

    public void setDataceres_envio(Date dataceres_envio) {
        this.dataceres_envio = dataceres_envio;
    }

    public String getDataceres_log() {
        return this.dataceres_log;
    }

    public void setDataceres_log(String dataceres_log) {
        this.dataceres_log = dataceres_log;
    }

    public Pessoa getCliente_obj() {
        return this.cliente_obj;
    }

    public void setCliente_obj(Pessoa cliente_obj) {
        this.cliente_obj = cliente_obj;
    }

    public Pessoa getSolicitante_obj() {
        return this.solicitante_obj;
    }

    public void setSolicitante_obj(Pessoa solicitante_obj) {
        this.solicitante_obj = solicitante_obj;
    }

    public Pessoa getCobranca_obj() {
        return this.cobranca_obj;
    }

    public void setCobranca_obj(Pessoa cobranca_obj) {
        this.cobranca_obj = cobranca_obj;
    }

    public Fazenda getFazenda_obj() {
        return this.fazenda_obj;
    }

    public void setFazenda_obj(Fazenda fazenda_obj) {
        this.fazenda_obj = fazenda_obj;
    }

    public List<Pedido_tipos_analise_resumo> getTipos_analise_resumo() {
        return this.tipos_analise_resumo;
    }

    public void setTipos_analise_resumo(List<Pedido_tipos_analise_resumo> tipos_analise_resumo) {
        this.tipos_analise_resumo = tipos_analise_resumo;
    }

    public String getView_analise_dataceres_id() {
        return this.view_analise_dataceres_id;
    }

    public void setView_analise_dataceres_id(String view_analise_dataceres_id) {
        this.view_analise_dataceres_id = view_analise_dataceres_id;
    }

    public boolean isDataceres_aguardar_pagamento() {
        return this.dataceres_aguardar_pagamento;
    }

    public void setDataceres_aguardar_pagamento(boolean dataceres_aguardar_pagamento) {
        this.dataceres_aguardar_pagamento = dataceres_aguardar_pagamento;
    }

    public float getView_valor_aditivos() {
        return this.view_valor_aditivos;
    }

    public void setView_valor_aditivos(float view_valor_aditivos) {
        this.view_valor_aditivos = view_valor_aditivos;
    }

    public Date getIntegracao_envio() {
        return this.integracao_envio;
    }

    public void setIntegracao_envio(Date integracao_envio) {
        this.integracao_envio = integracao_envio;
    }

    public String getIntegracao_log() {
        return this.integracao_log;
    }

    public void setIntegracao_log(String integracao_log) {
        this.integracao_log = integracao_log;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public float getView_fatura_valorliquido() {
        return this.view_fatura_valorliquido;
    }

    public void setView_fatura_valorliquido(float view_fatura_valorliquido) {
        this.view_fatura_valorliquido = view_fatura_valorliquido;
    }

    public float getView_fatura_valorbruto() {
        return this.view_fatura_valorbruto;
    }

    public void setView_fatura_valorbruto(float view_fatura_valorbruto) {
        this.view_fatura_valorbruto = view_fatura_valorbruto;
    }

    public float getView_fatura_frete() {
        return this.view_fatura_frete;
    }

    public void setView_fatura_frete(float view_fatura_frete) {
        this.view_fatura_frete = view_fatura_frete;
    }

    public float getView_fatura_desconto() {
        return this.view_fatura_desconto;
    }

    public void setView_fatura_desconto(float view_fatura_desconto) {
        this.view_fatura_desconto = view_fatura_desconto;
    }

    public float getView_fatura_valorpago() {
        return this.view_fatura_valorpago;
    }

    public void setView_fatura_valorpago(float view_fatura_valorpago) {
        this.view_fatura_valorpago = view_fatura_valorpago;
    }

    public String getLocker() {
        return this.locker;
    }

    public void setLocker(String locker) {
        this.locker = locker;
    }
}

