/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import ceresonemodel.analise.CurvaCalibracaoPonto;
import ceresonemodel.utils.CampoData;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class CurvaCalibracao
implements Serializable {
    private long id;
    private float a;
    private float b;
    private float r2;
    private Date data;
    private Long campoconfiguracao;
    private String nome;
    @JsonIgnore
    private boolean editado = false;

    public boolean equals(Object o) {
        try {
            CurvaCalibracao tmp = (CurvaCalibracao)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return CampoData.dataToString(this.data) + (this.getNome() == null ? "" : " - " + this.getNome());
    }

    public void calculaCurva(List<CurvaCalibracaoPonto> pontos) {
        float somaX = 0.0f;
        float somaY = 0.0f;
        float somaX2 = 0.0f;
        float somaY2 = 0.0f;
        float somaSXxSX = 0.0f;
        float somaSYxSY = 0.0f;
        float somaXxY = 0.0f;
        float mediaX = 0.0f;
        float mediaY = 0.0f;
        float curvaA = 0.0f;
        float curvaB = 0.0f;
        float r2 = 0.0f;
        float ra1 = 0.0f;
        float ra2 = 0.0f;
        float n = 0.0f;
        if (pontos == null || pontos.size() == 0) {
            curvaA = 0.0f;
            curvaB = 0.0f;
            r2 = 0.0f;
        } else {
            n = pontos.size();
            for (CurvaCalibracaoPonto ponto : pontos) {
                somaX = (float)((double)somaX + ponto.getX());
                somaY = (float)((double)somaY + ponto.getY());
                somaX2 = (float)((double)somaX2 + ponto.getX() * ponto.getX());
                somaY2 = (float)((double)somaY2 + ponto.getY() * ponto.getY());
                somaXxY = (float)((double)somaXxY + ponto.getX() * ponto.getY());
            }
            somaSXxSX = somaX * somaX;
            somaSYxSY = somaY * somaY;
            mediaX = somaX / n;
            mediaY = somaY / n;
            curvaB = (somaXxY * n - somaX * somaY) / (somaX2 * n - somaSXxSX);
            curvaA = mediaY - mediaX * curvaB;
            r2 = somaXxY * n - somaX * somaY;
            ra1 = (float)Math.sqrt(somaX2 * n - somaSXxSX);
            ra2 = (float)Math.sqrt(somaY2 * n - somaSYxSY);
            if (ra1 != 0.0f && ra2 != 0.0f) {
                r2 /= ra1 * ra2;
            }
        }
        this.setA(curvaA);
        this.setB(curvaB);
        this.setR2(r2);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
    }

    public float getR2() {
        return this.r2;
    }

    public void setR2(float r2) {
        this.r2 = r2;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Long getCampoconfiguracao() {
        return this.campoconfiguracao;
    }

    public void setCampoconfiguracao(Long campoconfiguracao) {
        this.campoconfiguracao = campoconfiguracao;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean isEditado() {
        return this.editado;
    }

    public void setEditado(boolean editado) {
        this.editado = editado;
    }
}

