/*
 * Decompiled with CFR 0.152.
 */
package ceresonemodel.analise;

import calculo.CalculaExpressoes;
import ceresonemodel.analise.AmostraGrupoPacote;
import ceresonemodel.analise.AmostraPacotePreco;
import ceresonemodel.analise.Pedido;
import ceresonemodel.analise.Pedido_aditivo;
import ceresonemodel.campos.AnaliseParametro;
import ceresonemodel.campos.CampoLancamentoAnaliseParametro;
import ceresonemodel.campos.CampoSupervisao;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.utils.CampoData;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Amostra
implements Serializable {
    private long id;
    private int ano;
    private Date cancelamento;
    private Date data;
    private Date data_aloc_caxaitem;
    private Date data_aprovacao;
    private boolean descartada;
    private String descricao;
    private String justificativa;
    private long numero;
    private Long amostracontrole;
    private Long analise;
    private Long caixaitem;
    private Long laudo;
    private Long pedido;
    private Long profundidade;
    private Long talhao;
    private float valor;
    private Date recebimento;
    private String codlab;
    private boolean calculado;
    private long progresso;
    private String integracao;
    private Long locale;
    private Date data_coleta;
    private Date datatriggervalor;
    private Date data_add_relcao;
    private float valor_aditivo;
    private String view_pedido_numero_ano;
    private long view_cliente;
    private Date view_pedido_liberadolab;
    private String view_cliente_nome;
    private long view_cultura;
    private String view_cultura_nome;
    private long view_fazenda;
    private String view_fazenda_nome;
    private String view_laudo_numero_ano;
    private String view_talhao_nome;
    private String view_profundidade_nome;
    private String view_fazenda_proprietario;
    private String view_locale_nome;
    private String view_tipo_analise;
    private String view_analise_nome;
    private Date view_pedido_previsao;
    private String view_amostracontrole_nome;
    private Date view_pedido_entrada;
    @JsonIgnore
    private boolean editado = false;
    @JsonIgnore
    private Pedido pedido_obj;
    @JsonIgnore
    private boolean verificacao_erro;
    @JsonIgnore
    private String verificacao_log;
    @JsonIgnore
    private List<CampoLancamentoAnaliseParametro> camposLancamentoAnaliseParametro;
    @JsonIgnore
    private List<CampoSupervisao> camposSupervisao = new ArrayList<CampoSupervisao>();
    @JsonIgnore
    private String log_pendencias_aprovacao = null;
    @JsonIgnore
    private List<AmostraPacotePreco> amostrasPacotePreco = new ArrayList<AmostraPacotePreco>();
    @JsonIgnore
    private List<AmostraGrupoPacote> amostrasGrupoPacote = new ArrayList<AmostraGrupoPacote>();

    public boolean equals(Object o) {
        try {
            Amostra tmp = (Amostra)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getNumero() > 0L ? this.getNumero() + "/" + this.getAno() : "?";
    }

    public String recalcularRelacoes() {
        String log = "\n" + CampoData.dataHoraToString(new Date()) + " - Calulando Rela\u00e7\u00f5es amostra :" + this.toString();
        this.camposSupervisao = CalculaExpressoes.ordenarCalculosRelacoes(this.camposSupervisao);
        for (CampoSupervisao campo : this.camposSupervisao) {
            if (!campo.isRelacao()) continue;
            log = log + "\n" + campo.getLabel() + " : ";
            log = log + CalculaExpressoes.calculaExpressao(campo, this.camposSupervisao);
            log = log + "\n================================";
        }
        log = log + "\n";
        return log;
    }

    public String[] verificarResultados(List<AnaliseParametro> verificadores, DAO_LAB dao) throws Exception {
        String log = "";
        String tmp_log_aprovada = "<b>Amostra " + this.toString() + "</b>";
        String tmp_log_reprovada = "<b>Amostra " + this.toString() + "</b>";
        String tmp_log_erro = "<b>Amostra " + this.toString() + "</b>";
        boolean tem_aprovada = false;
        boolean tem_reprovada = false;
        boolean tem_erro = false;
        for (CampoSupervisao cp : this.camposSupervisao) {
            cp.setVerificacao_erro(false);
            cp.setVerificacao_log("");
        }
        boolean reprovado = false;
        for (AnaliseParametro verificador : verificadores) {
            String tmp;
            if (verificador.getView_campoconfiguracao_formula() == null) continue;
            log = log + "<br>" + verificador.getNome() + " : ";
            CampoSupervisao campo = new CampoSupervisao();
            campo.setCampolancamento(this.getId() + verificador.getId());
            campo.setForcarcalculo(verificador.isView_campoconfiguracao_forcarcalculo());
            campo.setFormula(verificador.getView_campoconfiguracao_formula());
            campo.setFormulaid(verificador.getView_campoconfiguracao_formulaid());
            String log_verif = CalculaExpressoes.calculaExpressao(campo, this.camposSupervisao);
            log = log + log_verif + "<br>";
            reprovado = campo.getValor().equalsIgnoreCase("false");
            List<CampoSupervisao> deps = CalculaExpressoes.getDependencias4Expressao(campo, this.camposSupervisao);
            if (deps != null) {
                for (CampoSupervisao dep : deps) {
                    if (reprovado) {
                        dep.setVerificacao_erro(true);
                    }
                    dep.setVerificacao_log(dep.getVerificacao_log() + log_verif + "<hr>");
                }
            }
            if ((tmp = campo.getValor()) != null && tmp.equalsIgnoreCase("")) continue;
            if (tmp != null && tmp.equalsIgnoreCase("true")) {
                tem_aprovada = true;
                tmp_log_aprovada = tmp_log_aprovada + "<br>" + verificador.getNome() + ": <span style=\"color: darkgreen;\">aprovada</span>";
                continue;
            }
            if (tmp != null && tmp.equalsIgnoreCase("false")) {
                tem_reprovada = true;
                tmp_log_reprovada = tmp_log_reprovada + "<br>" + verificador.getNome() + ": <span style=\"color: red;\">reprovada</span>";
                continue;
            }
            tem_erro = true;
            tmp_log_erro = tmp_log_erro + "<br>" + verificador.getNome() + ": <span style=\"color: red;\">erro</span>";
        }
        tmp_log_aprovada = tem_aprovada ? tmp_log_aprovada : null;
        tmp_log_reprovada = tem_reprovada ? tmp_log_reprovada : null;
        tmp_log_erro = tem_erro ? tmp_log_erro : null;
        log = log + "<br>";
        this.setVerificacao_log(log);
        this.setVerificacao_erro(reprovado);
        return new String[]{tmp_log_aprovada, tmp_log_reprovada, tmp_log_erro};
    }

    public String getValorCampoSupervisao(long id_campo_configuracao) {
        String valor = "";
        int leituras = 0;
        for (CampoSupervisao campo : this.camposSupervisao) {
            String color;
            if (campo.getCampoconfiguracao() != id_campo_configuracao) continue;
            String string = color = campo.isVerificacao_erro() ? "<span style=\"color:red\">" : "<span style=\"color:#006600\">";
            if (campo.isRelacao()) {
                return campo.getValor() == null ? "" : "<i>" + color + campo.getValor() + "</span></i>";
            }
            ++leituras;
            valor = valor + (valor.equals("") ? "" : " | ");
            valor = valor + (campo.getValor() == null ? "<span style=\"color:red\">?</span>" : (campo.isResultado() ? "<strong>" + color + campo.getValor() + "</span></strong>" : "<span style=\"color:#787878\">" + campo.getValor() + "</span>"));
        }
        if (leituras <= 1) {
            valor = valor.replace("?", "");
        }
        return valor;
    }

    public List<CampoSupervisao> getCampos4Repeticao(long id_campo_configuracao) {
        ArrayList<CampoSupervisao> resultado = new ArrayList<CampoSupervisao>();
        for (CampoSupervisao campo : this.camposSupervisao) {
            if (campo.getCampoconfiguracao() != id_campo_configuracao) continue;
            if (campo.isRelacao()) {
                return resultado;
            }
            resultado.add(campo);
        }
        return resultado;
    }

    public void carregaLogPendenciasAprovacao() {
        String tmp = "";
        for (CampoSupervisao campo : this.camposSupervisao) {
            if (campo.isRelacao() || campo.getData_aprovacao() != null) continue;
            tmp = tmp + (tmp.equals("") ? "" : "\n");
            tmp = tmp + CampoData.dataToString(campo.getData()) + ": " + campo.getLabel() + " - " + campo.getAnalista();
        }
        this.log_pendencias_aprovacao = tmp;
    }

    public void carregaTipoAnaliseDados(DAO_LAB dao) throws Exception {
        this.amostrasPacotePreco = Arrays.asList((AmostraPacotePreco[])dao.listObject(AmostraPacotePreco[].class, "view_amostrapacotepreco?amostra=eq." + this.getId()));
        this.amostrasGrupoPacote = Arrays.asList((AmostraGrupoPacote[])dao.listObject(AmostraGrupoPacote[].class, "view_amostragrupopacote?amostra=eq." + this.getId()));
    }

    public String getAnaliseTipoDaodosOriginal(Pedido_aditivo aditivo) {
        String saida = "";
        if (aditivo != null) {
            for (AmostraGrupoPacote ag : this.amostrasGrupoPacote) {
                if (ag.getAditivo() != null && ag.getAditivo().longValue() == aditivo.getId()) continue;
                saida = saida + (saida.equals("") ? "" : " | ");
                saida = saida + ag.getView_grupopacote_nome();
            }
            for (AmostraPacotePreco ap : this.amostrasPacotePreco) {
                if (ap.getAditivo() != null && ap.getAditivo().longValue() == aditivo.getId()) continue;
                saida = saida + (saida.equals("") ? "" : " | ");
                saida = saida + ap.getView_pacotepreco_nome();
            }
        }
        return saida;
    }

    public String getAnaliseTipoDaodosAditivo(Pedido_aditivo aditivo) {
        String saida = "";
        if (aditivo != null) {
            for (AmostraGrupoPacote ag : this.amostrasGrupoPacote) {
                if (ag.getAditivo() == null || ag.getAditivo().longValue() != aditivo.getId()) continue;
                saida = saida + (saida.equals("") ? "" : " | ");
                saida = saida + ag.getView_grupopacote_nome();
            }
            for (AmostraPacotePreco ap : this.amostrasPacotePreco) {
                if (ap.getAditivo() == null || ap.getAditivo().longValue() != aditivo.getId()) continue;
                saida = saida + (saida.equals("") ? "" : " | ");
                saida = saida + ap.getView_pacotepreco_nome();
            }
        }
        return saida;
    }

    public double getAnaliseTipoDaodosAditivoValor(Pedido_aditivo aditivo) {
        double valor = 0.0;
        if (aditivo != null) {
            for (AmostraGrupoPacote ag : this.amostrasGrupoPacote) {
                if (ag.getAditivo() == null || ag.getAditivo().longValue() != aditivo.getId()) continue;
                valor += (double)ag.getValor();
            }
            for (AmostraPacotePreco ap : this.amostrasPacotePreco) {
                if (ap.getAditivo() == null || ap.getAditivo().longValue() != aditivo.getId()) continue;
                valor += (double)ap.getValor();
            }
        }
        return valor;
    }

    @JsonIgnore
    public boolean isAprovavel() {
        return this.log_pendencias_aprovacao.equals("");
    }

    @JsonIgnore
    public String label() {
        String tmp = this.descricao != null ? this.descricao : "";
        tmp = tmp + (this.view_profundidade_nome != null && !this.view_profundidade_nome.equals("") ? " - " + this.view_profundidade_nome : "");
        tmp = tmp + (this.view_talhao_nome != null && !this.view_talhao_nome.equals("") ? " - " + this.view_talhao_nome : "");
        return tmp;
    }

    @JsonIgnore
    public String getLabel() {
        return this.label();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getAno() {
        return this.ano;
    }

    public void setAno(int ano) {
        this.ano = ano;
    }

    public Date getCancelamento() {
        return this.cancelamento;
    }

    public void setCancelamento(Date cancelamento) {
        this.cancelamento = cancelamento;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Date getData_aloc_caxaitem() {
        return this.data_aloc_caxaitem;
    }

    public void setData_aloc_caxaitem(Date data_aloc_caxaitem) {
        this.data_aloc_caxaitem = data_aloc_caxaitem;
    }

    public Date getData_aprovacao() {
        return this.data_aprovacao;
    }

    public void setData_aprovacao(Date data_aprovacao) {
        this.data_aprovacao = data_aprovacao;
    }

    public boolean isDescartada() {
        return this.descartada;
    }

    public void setDescartada(boolean descartada) {
        this.descartada = descartada;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    public long getNumero() {
        return this.numero;
    }

    public void setNumero(long numero) {
        this.numero = numero;
    }

    public Long getAmostracontrole() {
        return this.amostracontrole;
    }

    public void setAmostracontrole(Long amostracontrole) {
        this.amostracontrole = amostracontrole;
    }

    public Long getAnalise() {
        return this.analise;
    }

    public void setAnalise(Long analise) {
        this.analise = analise;
    }

    public Long getCaixaitem() {
        return this.caixaitem;
    }

    public void setCaixaitem(Long caixaitem) {
        this.caixaitem = caixaitem;
    }

    public Long getLaudo() {
        return this.laudo;
    }

    public void setLaudo(Long laudo) {
        this.laudo = laudo;
    }

    public Long getPedido() {
        return this.pedido;
    }

    public void setPedido(Long pedido) {
        this.pedido = pedido;
    }

    public Long getProfundidade() {
        return this.profundidade;
    }

    public void setProfundidade(Long profundidade) {
        this.profundidade = profundidade;
    }

    public Long getTalhao() {
        return this.talhao;
    }

    public void setTalhao(Long talhao) {
        this.talhao = talhao;
    }

    public float getValor() {
        return this.valor;
    }

    public void setValor(float valor) {
        this.valor = valor;
    }

    public Date getRecebimento() {
        return this.recebimento;
    }

    public void setRecebimento(Date recebimento) {
        this.recebimento = recebimento;
    }

    public String getCodlab() {
        return this.codlab;
    }

    public void setCodlab(String codlab) {
        this.codlab = codlab;
    }

    public boolean isCalculado() {
        return this.calculado;
    }

    public void setCalculado(boolean calculado) {
        this.calculado = calculado;
    }

    public long getProgresso() {
        return this.progresso;
    }

    public void setProgresso(long progresso) {
        this.progresso = progresso;
    }

    public String getIntegracao() {
        return this.integracao;
    }

    public void setIntegracao(String integracao) {
        this.integracao = integracao;
    }

    public Long getLocale() {
        return this.locale;
    }

    public void setLocale(Long locale) {
        this.locale = locale;
    }

    public Date getData_coleta() {
        return this.data_coleta;
    }

    public void setData_coleta(Date data_coleta) {
        this.data_coleta = data_coleta;
    }

    public Date getDatatriggervalor() {
        return this.datatriggervalor;
    }

    public void setDatatriggervalor(Date datatriggervalor) {
        this.datatriggervalor = datatriggervalor;
    }

    public String getView_pedido_numero_ano() {
        return this.view_pedido_numero_ano;
    }

    public void setView_pedido_numero_ano(String view_pedido_numero_ano) {
        this.view_pedido_numero_ano = view_pedido_numero_ano;
    }

    public long getView_cliente() {
        return this.view_cliente;
    }

    public void setView_cliente(long view_cliente) {
        this.view_cliente = view_cliente;
    }

    public String getView_cliente_nome() {
        return this.view_cliente_nome;
    }

    public void setView_cliente_nome(String view_cliente_nome) {
        this.view_cliente_nome = view_cliente_nome;
    }

    public long getView_cultura() {
        return this.view_cultura;
    }

    public void setView_cultura(long view_cultura) {
        this.view_cultura = view_cultura;
    }

    public String getView_cultura_nome() {
        return this.view_cultura_nome;
    }

    public void setView_cultura_nome(String view_cultura_nome) {
        this.view_cultura_nome = view_cultura_nome;
    }

    public long getView_fazenda() {
        return this.view_fazenda;
    }

    public void setView_fazenda(long view_fazenda) {
        this.view_fazenda = view_fazenda;
    }

    public String getView_fazenda_nome() {
        return this.view_fazenda_nome;
    }

    public void setView_fazenda_nome(String view_fazenda_nome) {
        this.view_fazenda_nome = view_fazenda_nome;
    }

    public String getView_talhao_nome() {
        return this.view_talhao_nome;
    }

    public void setView_talhao_nome(String view_talhao_nome) {
        this.view_talhao_nome = view_talhao_nome;
    }

    public String getView_profundidade_nome() {
        return this.view_profundidade_nome;
    }

    public void setView_profundidade_nome(String view_profundidade_nome) {
        this.view_profundidade_nome = view_profundidade_nome;
    }

    public String getView_laudo_numero_ano() {
        return this.view_laudo_numero_ano;
    }

    public void setView_laudo_numero_ano(String view_laudo_numero_ano) {
        this.view_laudo_numero_ano = view_laudo_numero_ano;
    }

    public String getView_locale_nome() {
        return this.view_locale_nome;
    }

    public void setView_locale_nome(String view_locale_nome) {
        this.view_locale_nome = view_locale_nome;
    }

    public boolean isEditado() {
        return this.editado;
    }

    public void setEditado(boolean editado) {
        this.editado = editado;
    }

    public String getView_tipo_analise() {
        return this.view_tipo_analise;
    }

    public void setView_tipo_analise(String view_tipo_analise) {
        this.view_tipo_analise = view_tipo_analise;
    }

    public List<CampoLancamentoAnaliseParametro> getCamposLancamentoAnaliseParametro() {
        return this.camposLancamentoAnaliseParametro;
    }

    public void setCamposLancamentoAnaliseParametro(List<CampoLancamentoAnaliseParametro> camposLancamentoAnaliseParametro) {
        this.camposLancamentoAnaliseParametro = camposLancamentoAnaliseParametro;
    }

    public Date getData_add_relcao() {
        return this.data_add_relcao;
    }

    public void setData_add_relcao(Date data_add_relcao) {
        this.data_add_relcao = data_add_relcao;
    }

    public List<CampoSupervisao> getCamposSupervisao() {
        return this.camposSupervisao;
    }

    public void setCamposSupervisao(List<CampoSupervisao> camposSupervisao) {
        this.camposSupervisao = camposSupervisao;
    }

    public String getView_analise_nome() {
        return this.view_analise_nome;
    }

    public void setView_analise_nome(String view_analise_nome) {
        this.view_analise_nome = view_analise_nome;
    }

    public Date getView_pedido_previsao() {
        return this.view_pedido_previsao;
    }

    public void setView_pedido_previsao(Date view_pedido_previsao) {
        this.view_pedido_previsao = view_pedido_previsao;
    }

    public Date getView_pedido_liberadolab() {
        return this.view_pedido_liberadolab;
    }

    public void setView_pedido_liberadolab(Date view_pedido_liberadolab) {
        this.view_pedido_liberadolab = view_pedido_liberadolab;
    }

    public Pedido getPedido_obj() {
        return this.pedido_obj;
    }

    public void setPedido_obj(Pedido pedido_obj) {
        this.pedido_obj = pedido_obj;
    }

    public String getLog_pendencias_aprovacao() {
        return this.log_pendencias_aprovacao;
    }

    public void setLog_pendencias_aprovacao(String log_pendencias_aprovacao) {
        this.log_pendencias_aprovacao = log_pendencias_aprovacao;
    }

    public List<AmostraPacotePreco> getAmostrasPacotePreco() {
        return this.amostrasPacotePreco;
    }

    public void setAmostrasPacotePreco(List<AmostraPacotePreco> amostrasPacotePreco) {
        this.amostrasPacotePreco = amostrasPacotePreco;
    }

    public List<AmostraGrupoPacote> getAmostrasGrupoPacote() {
        return this.amostrasGrupoPacote;
    }

    public void setAmostrasGrupoPacote(List<AmostraGrupoPacote> amostrasGrupoPacote) {
        this.amostrasGrupoPacote = amostrasGrupoPacote;
    }

    public String getView_fazenda_proprietario() {
        return this.view_fazenda_proprietario;
    }

    public void setView_fazenda_proprietario(String view_fazenda_proprietario) {
        this.view_fazenda_proprietario = view_fazenda_proprietario;
    }

    public float getValor_aditivo() {
        return this.valor_aditivo;
    }

    public void setValor_aditivo(float valor_aditivo) {
        this.valor_aditivo = valor_aditivo;
    }

    public boolean isVerificacao_erro() {
        return this.verificacao_erro;
    }

    public void setVerificacao_erro(boolean verificacao_erro) {
        this.verificacao_erro = verificacao_erro;
    }

    public String getVerificacao_log() {
        return this.verificacao_log;
    }

    public void setVerificacao_log(String verificacao_log) {
        this.verificacao_log = verificacao_log;
    }

    public String getView_amostracontrole_nome() {
        return this.view_amostracontrole_nome;
    }

    public void setView_amostracontrole_nome(String view_amostracontrole_nome) {
        this.view_amostracontrole_nome = view_amostracontrole_nome;
    }

    public Date getView_pedido_entrada() {
        return this.view_pedido_entrada;
    }

    public void setView_pedido_entrada(Date view_pedido_entrada) {
        this.view_pedido_entrada = view_pedido_entrada;
    }
}

