/*
 * Decompiled with CFR 0.152.
 */
package ceresjel.jel;

class IntegerStack {
    private int[] data;
    private int count = 0;

    public IntegerStack(int initCapacity) {
        this.data = new int[initCapacity];
    }

    public IntegerStack() {
        this(30);
    }

    public IntegerStack copy() {
        IntegerStack res = new IntegerStack(this.data.length);
        res.count = this.count;
        for (int i = 0; i < this.count; ++i) {
            res.data[i] = this.data[i];
        }
        return res;
    }

    public final void push(int what) {
        if (this.count >= this.data.length) {
            this.incCap(this.count + 1);
        }
        this.data[this.count++] = what;
    }

    public final int peek() {
        return this.data[this.count - 1];
    }

    public final int pop() {
        return this.data[--this.count];
    }

    public final int size() {
        return this.count;
    }

    public static void swap(IntegerStack one, int oneLim, IntegerStack other, int otherLim) {
        IntegerStack temp = null;
        if (one.size() > oneLim) {
            temp = new IntegerStack();
        }
        while (one.size() > oneLim) {
            temp.push(one.pop());
        }
        while (other.size() > otherLim) {
            one.push(other.pop());
        }
        while (temp != null && temp.size() > 0) {
            other.push(temp.pop());
        }
    }

    private void incCap(int minCapacity) {
        int[] old_data = this.data;
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        if (newSize < minCapacity) {
            newSize = minCapacity;
        }
        this.data = new int[newSize];
        System.arraycopy(old_data, 0, this.data, 0, this.count);
    }
}

