/*
 * Decompiled with CFR 0.152.
 */
package ceresjel.jel;

import ceresjel.jel.IntegerStack;
import ceresjel.jel.Library;
import ceresjel.jel.LocalField;
import ceresjel.jel.LocalMethod;
import ceresjel.jel.OP;
import ceresjel.jel.TableKeeper;
import ceresjel.jel.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private HashMap<Object, Integer> Items = new HashMap();
    private HashMap<String, Integer> UTFs = new HashMap();
    private int nMethods = 0;
    private int nMethodsPatch;
    private byte[] text;
    int tsize = 0;
    private boolean isInterface;
    private IntegerStack[] cstk = new IntegerStack[6];
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
    private LocalMethod currMethod = null;
    int[] paramsVars = null;
    private int cW = 0;
    private int mW = 0;
    private static final Class[] specialClasses;
    private static final Member[] specialMethods;
    private IntegerStack branchStack = new IntegerStack();
    int currJump = 0;
    private boolean iNJ = false;

    void write(int b) {
        try {
            this.text[this.tsize++] = (byte)b;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            byte[] new_text = new byte[this.text.length << 1];
            System.arraycopy(this.text, 0, new_text, 0, this.tsize - 1);
            this.text = new_text;
            this.text[this.tsize - 1] = (byte)b;
        }
    }

    void writeShort(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public ClassFile(int modifiers, String name, Class superClass, Class[] interfaces, LocalField[] fields) {
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.text = new byte[256];
        Debug.check(this.cstk.length == 6);
        for (int i = 0; i < 6; ++i) {
            this.cstk[i] = new IntegerStack();
        }
        try {
            Debug.check(name.indexOf(46) == -1);
            this.getUTFIndex(name);
            Debug.check((modifiers & 0xFFFFF9EE) == 0);
            this.isInterface = (modifiers & 0x200) > 0;
            this.writeShort(modifiers | 0x20);
            Debug.check(this.poolEntries == 2);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.writeShort(2);
            this.writeShort(this.getIndex(superClass, 9));
            int nInterfaces = interfaces == null ? 0 : interfaces.length;
            this.writeShort(nInterfaces);
            for (int i = 0; i < nInterfaces; ++i) {
                Debug.check(interfaces[i].isInterface());
                this.writeShort(this.getIndex(interfaces[i], 9));
            }
            int nFields = fields == null ? 0 : fields.length;
            this.writeShort(nFields);
            for (int i = 0; i < nFields; ++i) {
                LocalField cLF = fields[i];
                Debug.check(!(cLF instanceof LocalMethod));
                this.writeShort(cLF.getModifiers());
                this.writeShort(this.getUTFIndex(cLF.getName()));
                this.writeShort(this.getUTFIndex(Library.getSignature(cLF.getType())));
                this.writeShort(0);
            }
            this.nMethodsPatch = this.tsize;
            this.writeShort(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClassFile clone() {
        ClassFile res = null;
        try {
            res = (ClassFile)super.clone();
            res.Items = new HashMap<Object, Integer>(res.Items);
            res.UTFs = new HashMap<String, Integer>(res.UTFs);
            res.paramsVars = (int[])res.paramsVars.clone();
            res.branchStack = res.branchStack.copy();
            Debug.check(this.cstk.length == 6);
            res.cstk = new IntegerStack[6];
            for (int i = 0; i < 6; ++i) {
                res.cstk[i] = this.cstk[i].copy();
            }
            res.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(res.constPoolData);
            res.constPool = new DataOutputStream(res.constPoolData);
            res.text = (byte[])res.text.clone();
        }
        catch (IOException exc) {
            Debug.reportThrowable(exc);
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public void newMethod(LocalMethod m, Class[] vars) {
        Debug.check(this.cW == 0);
        for (int i = 0; i < 6; ++i) {
            Debug.check(this.cstk[i].size() == 0);
        }
        Debug.check(this.currJump == 0);
        this.finishMethod();
        ++this.nMethods;
        int mdfrs = m.getModifiers();
        if (this.isInterface) {
            mdfrs |= 0x400;
        }
        boolean isAbstract = (mdfrs & 0x400) > 0;
        this.writeShort(mdfrs);
        this.writeShort(this.getUTFIndex(m.getName()));
        this.writeShort(this.getUTFIndex(Library.getSignature(m)));
        int temp = 0;
        Class[] exceptions = m.getExceptionTypes();
        if (exceptions != null) {
            ++temp;
        }
        if (!isAbstract) {
            ++temp;
        }
        this.writeShort(temp);
        if (exceptions != null) {
            temp = exceptions.length;
            this.writeShort(this.getUTFIndex("Exceptions"));
            this.writeInt((temp + 1) * 2);
            this.writeShort(temp);
            for (int i = 0; i < temp; ++i) {
                this.writeShort(this.getIndex(exceptions[i], 9));
            }
        }
        if (!isAbstract) {
            this.startCodeAttr = this.tsize;
            this.writeShort(this.getUTFIndex("Code"));
            this.writeInt(0);
            this.writeShort(0);
            Class[] params = m.getParameterTypes();
            int parlen = params == null ? 0 : params.length;
            int varlen = vars == null ? 0 : vars.length;
            int this_num = (mdfrs & 8) == 0 ? 1 : 0;
            int nLocalVars = parlen + varlen + this_num;
            this.paramsVars = new int[nLocalVars];
            Debug.check(this.cW == 0);
            for (int i = 0; i < this.paramsVars.length; ++i) {
                int j = i - this_num;
                this.paramsVars[i] = this.cW;
                this.noteStk(-1, i < this_num ? 8 : OP.typeID(j < parlen ? params[j] : vars[j - parlen]));
            }
            this.writeShort(this.cW);
            this.cW = 0;
            this.writeInt(0);
            this.startCode = this.tsize;
        }
        this.mW = 0;
        if (!isAbstract) {
            this.currMethod = m;
        }
    }

    private void finishMethod() {
        if (this.currMethod != null) {
            int codeEnd = this.tsize;
            this.writeShort(0);
            this.writeShort(0);
            int currPos = this.tsize;
            this.tsize = this.startCodeAttr + 2;
            this.writeInt(currPos - this.startCodeAttr - 6);
            this.tsize = this.startCodeAttr + 6;
            this.writeShort(this.mW);
            this.tsize = this.startCode - 2;
            this.writeShort(codeEnd - this.startCode);
            this.tsize = currPos;
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            int otsize = this.tsize;
            this.tsize = this.nMethodsPatch;
            this.writeShort(this.nMethods);
            this.tsize = otsize;
            image.write(prologue);
            image.write(this.poolEntries >>> 8 & 0xFF);
            image.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(image);
            image.write(this.text, 0, this.tsize);
            image.write(0);
            image.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image.toByteArray();
    }

    public void noteStk(int s, int a) {
        Debug.check(this.cW <= this.mW);
        if (s >= 0 && s != 9) {
            --this.cW;
            if ((s & 0xFFFFFFFD) == 5) {
                --this.cW;
            }
            Debug.check(this.cW >= 0);
        }
        if (a >= 0 && a != 9) {
            ++this.cW;
            if ((a & 0xFFFFFFFD) == 5) {
                ++this.cW;
            }
            if (this.cW > this.mW) {
                this.mW = this.cW;
            }
        }
    }

    public final void codeB(long op) {
        while (op != 0L) {
            this.write((byte)(op & 0xFFL));
            op >>>= 8;
        }
    }

    public final void codeM(Member m) {
        int modifiers = m.getModifiers();
        if (Library.isField(m)) {
            if ((modifiers & 8) > 0) {
                this.code(178L);
            } else {
                this.code(180L);
            }
            this.writeShort(this.getIndex(m, 12));
        } else {
            boolean inInterface = false;
            int cfID = 10;
            if (m instanceof Constructor) {
                this.code(183L);
                ++cfID;
            } else if ((modifiers & 8) > 0) {
                this.code(184L);
            } else {
                Class<?> dClass = m.getDeclaringClass();
                inInterface = dClass != null && dClass.isInterface();
                if (inInterface) {
                    this.code(185L);
                } else {
                    this.code(182L);
                }
            }
            this.writeShort(this.getIndex(m, cfID));
            if (inInterface) {
                this.writeShort(1 + ((Method)m).getParameterTypes().length << 8);
            }
        }
    }

    public final void code(long op) {
        while (op != 0L) {
            char opc = (char)(op & 0xFFL);
            Debug.check(opc != '\u00ff');
            int mc = 228;
            switch (opc - 228) {
                case 0: {
                    this.code(244L);
                    this.branchStack.push(this.cW);
                    break;
                }
                case 1: {
                    this.code(59386L);
                    int beforeStk = this.branchStack.pop();
                    this.branchStack.push(this.cW);
                    Debug.check(this.cW >= beforeStk);
                    this.cW = beforeStk;
                    this.code(3991728807L);
                    break;
                }
                case 2: {
                    this.code(250L);
                    Debug.check(this.branchStack.pop() == this.cW, "Stack mismatch when compiling conditional");
                    this.code(61417L);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.cstk[opc - 228].pop();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.cstk[opc - 231].push(this.cstk[opc - 234].size());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    int blocked_at = 0;
                    IntegerStack blk = this.cstk[opc - 234];
                    IntegerStack jmp = this.cstk[opc - 237];
                    if (blk.size() > 0) {
                        blocked_at = blk.peek();
                    }
                    while (jmp.size() > blocked_at) {
                        int addrpos;
                        int currpos = this.tsize;
                        this.tsize = addrpos = jmp.pop();
                        this.writeShort(currpos - addrpos + 1);
                        this.tsize = currpos;
                    }
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.cstk[opc - 240].push(this.tsize);
                    this.writeShort(0);
                    break;
                }
                case 15: {
                    this.currJump = (int)((op >>>= 8) & 0xFFL);
                    break;
                }
                case 16: 
                case 17: {
                    int s = opc - 244;
                    this.code(249L);
                    if (this.iNJ ^ s == 0) {
                        Debug.check(this.currJump >= 153 && this.currJump <= 166, "Attempt to invert non jump bytecode (" + this.currJump + ")");
                        this.currJump = (this.currJump - 1 ^ 1) + 1;
                    }
                    this.iNJ = false;
                    this.code(62208 + this.currJump);
                    this.code(15396336 + (s << 16) + ((s ^ 1) << 8) + s);
                    break;
                }
                case 18: 
                case 19: {
                    this.cstk[opc - 243].pop();
                    break;
                }
                case 20: {
                    this.code(15198441L);
                    break;
                }
                case 21: {
                    if (this.currJump != 0) break;
                    this.noteStk(0, -1);
                    this.currJump = 157;
                    break;
                }
                case 22: {
                    boolean noPendingJumps = false;
                    if (this.currJump == 0) {
                        int blocked0 = 0;
                        if (this.cstk[3].size() > 0) {
                            blocked0 = this.cstk[3].peek();
                        }
                        int blocked1 = 0;
                        if (this.cstk[4].size() > 0) {
                            blocked1 = this.cstk[4].peek();
                        }
                        boolean bl = noPendingJumps = this.cstk[0].size() == blocked0 && this.cstk[1].size() == blocked1;
                    }
                    if (noPendingJumps) break;
                    this.code(228L);
                    this.codeLDC(Boolean.TRUE, 0);
                    this.code(229L);
                    this.codeLDC(Boolean.FALSE, 0);
                    this.code(230L);
                    break;
                }
                case 23: {
                    this.code(15395820L);
                    break;
                }
                case 24: {
                    this.code(249L);
                    IntegerStack.swap(this.cstk[1], this.cstk[4].pop(), this.cstk[0], this.cstk[3].pop());
                    this.cstk[5].pop();
                    this.iNJ = !this.iNJ;
                    break;
                }
                case 25: {
                    this.writeShort(this.getIndex(specialClasses[(int)((op >>>= 8) & 0xFFL)], 9));
                    break;
                }
                case 26: {
                    this.codeM(specialMethods[(int)((op >>>= 8) & 0xFFL)]);
                    break;
                }
                default: {
                    Debug.check(opc != '\u00ff');
                    this.write(opc);
                }
            }
            op >>>= 8;
        }
    }

    public final void codeLDC(Object o, int primitiveID) {
        Debug.check(primitiveID >= 0 && primitiveID < 8 || primitiveID == 8 && o == null || primitiveID == 10 && o instanceof StringBuffer || primitiveID == 11 && o instanceof String);
        int short_opcodes = 0;
        boolean tsb_store = false;
        int iv = -1;
        switch (primitiveID) {
            case 0: {
                iv = (Boolean)o != false ? 1 : 0;
            }
            case 2: {
                if (iv < 0) {
                    iv = ((Character)o).charValue();
                }
            }
            case 1: 
            case 3: 
            case 4: {
                if (iv < 0) {
                    iv = ((Number)o).intValue();
                }
                if (iv >= -1 && iv <= 5) {
                    short_opcodes = iv + 3;
                    break;
                }
                if (iv < -128 || iv > 127) break;
                short_opcodes = 0x10 | (iv & 0xFF) << 8;
                break;
            }
            case 5: {
                long lv = (Long)o;
                if (((lv | 1L) ^ 1L) == 0L) {
                    short_opcodes = 9 + (int)lv;
                    break;
                }
                if (lv < -1L || lv > 5L) break;
                short_opcodes = 34051 + (int)lv;
                break;
            }
            case 6: {
                float fv = ((Float)o).floatValue();
                if (fv == 0.0f) {
                    short_opcodes = 11;
                    break;
                }
                if (fv == 1.0f) {
                    short_opcodes = 12;
                    break;
                }
                if (fv != 2.0f) break;
                short_opcodes = 13;
                break;
            }
            case 7: {
                double dv = (Double)o;
                if (dv == 0.0) {
                    short_opcodes = 14;
                    break;
                }
                if (dv != 1.0) break;
                short_opcodes = 15;
                break;
            }
            case 8: {
                if (o != null) break;
                short_opcodes = 1;
                break;
            }
            case 10: {
                tsb_store = true;
            }
            case 11: {
                short_opcodes = 0;
                primitiveID = 8;
                break;
            }
            default: {
                Debug.check(false, "Loading of object constants is not supported by the Java class files.");
            }
        }
        if (short_opcodes == 0) {
            int cpindex;
            boolean dword_const;
            boolean bl = dword_const = primitiveID == 5 || primitiveID == 7;
            if (tsb_store) {
                this.code(2191928458683L);
                this.noteStk(-1, 10);
                cpindex = this.getIndex(o.toString(), primitiveID);
            } else {
                cpindex = this.getIndex(o, primitiveID);
            }
            Debug.check(cpindex >= 0 && cpindex <= 65535);
            if (!dword_const && cpindex <= 255) {
                this.write(18);
                this.write(cpindex);
            } else {
                int opc = 19;
                if (dword_const) {
                    ++opc;
                }
                this.write(opc);
                this.writeShort(cpindex);
            }
        } else {
            this.codeB(short_opcodes);
        }
        this.noteStk(-1, primitiveID);
        if (tsb_store) {
            this.code(2302L);
            this.noteStk(11, -1);
        }
    }

    int getUTFIndex(String str) {
        Integer index = this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int typeID(Object item) {
        int id = OP.typeIDObject(item);
        if (id < 8) {
            return id;
        }
        if (item instanceof String) {
            return 8;
        }
        if (item instanceof Class) {
            return 9;
        }
        if (item instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object item) {
        return this.getIndex(item, this.typeID(item));
    }

    public int getIndex(Object item, int typeid) {
        Integer index = this.Items.get(item);
        if (index == null) {
            int newIndex = -1;
            try {
                int ival = -1;
                switch (typeid) {
                    case 0: {
                        ival = (Boolean)item != false ? 1 : 0;
                    }
                    case 2: {
                        if (ival < 0) {
                            ival = ((Character)item).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (ival < 0) {
                            ival = ((Number)item).intValue();
                        }
                        newIndex = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(ival);
                        break;
                    }
                    case 5: {
                        newIndex = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        newIndex = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)item).floatValue());
                        break;
                    }
                    case 7: {
                        newIndex = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int UTFIndex = this.getUTFIndex((String)item);
                        newIndex = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 9: {
                        String histNameStr = Library.toHistoricalForm(((Class)item).getName());
                        int UTFIndex = this.getUTFIndex(histNameStr);
                        newIndex = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)item;
                        Class<?> dClass = member.getDeclaringClass();
                        int entryType = Library.isField(member) ? 9 : (dClass != null && dClass.isInterface() ? 11 : 10);
                        newIndex = this.writeMemberRef(member, entryType);
                        break;
                    }
                    default: {
                        Debug.println("Can't place an item of type \"" + item.getClass().getName() + "\" to the constant pool.");
                        break;
                    }
                }
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            index = new Integer(newIndex);
            this.Items.put(item, index);
        }
        return index;
    }

    private int writeMemberRef(Member member, int entry) throws IOException {
        Debug.check(entry == 10 || entry == 9 || entry == 11);
        int name_ind = this.getUTFIndex(member instanceof Constructor ? "<init>" : member.getName());
        int sign_ind = this.getUTFIndex(Library.getSignature(member));
        Class<?> dClass = member.getDeclaringClass();
        int cls_ind = dClass == null ? 2 : this.getIndex(dClass, 9);
        int nat_ind = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(name_ind);
        this.constPool.writeShort(sign_ind);
        int index = this.poolEntries++;
        this.constPool.write(entry);
        this.constPool.writeShort(cls_ind);
        this.constPool.writeShort(nat_ind);
        return index;
    }

    static {
        Debug.check(OP.specialTypes.length == 29, "You changed special types in TypesStack please update specialClasses array in ClassFile.");
        specialClasses = (Class[])TableKeeper.getTable("specialClasses");
        char[][] specialMds = (char[][])TableKeeper.getTable("specialMds");
        String[] specialMdsN = (String[])TableKeeper.getTable("specialMdsN");
        specialMethods = new Member[specialMds.length];
        Class definingClass = null;
        String name = null;
        Class[] params = null;
        int i = 0;
        try {
            block7: for (i = 0; i < specialMds.length; ++i) {
                int defClassID = specialMds[i][0] % 100;
                definingClass = specialClasses[defClassID];
                name = specialMdsN[specialMds[i][1]];
                params = new Class[specialMds[i].length - 2];
                for (int j = 0; j < params.length; ++j) {
                    params[j] = specialClasses[specialMds[i][2 + j]];
                }
                switch (specialMds[i][0] / 100) {
                    case 0: {
                        ClassFile.specialMethods[i] = definingClass.getMethod(name, params);
                        continue block7;
                    }
                    case 1: {
                        ClassFile.specialMethods[i] = definingClass.getConstructor(params);
                        continue block7;
                    }
                    case 2: {
                        Debug.check(params.length == 0);
                        ClassFile.specialMethods[i] = definingClass.getField(name);
                        continue block7;
                    }
                    default: {
                        throw new Exception("JEL: Wrong class ID modifier.");
                    }
                }
            }
        }
        catch (Exception exc) {
            Debug.println("JEL: Problem with special method [" + i + "] " + name + " in " + definingClass);
            for (int j = 0; j < params.length; ++j) {
                Debug.println("parameter[" + j + "]=" + params[j]);
            }
            Debug.reportThrowable(exc);
        }
    }
}

