/*
 * Decompiled with CFR 0.152.
 */
package ceresjel;

import ceresjel.jel.CompilationException;
import ceresjel.jel.CompiledExpression;
import ceresjel.jel.Evaluator;
import ceresjel.jel.Library;
import ceresonemodel.utils.Estatistica;

public class CalculatorCeres {
    public static final String NS = "NS";
    public static final String NS_COD = "-255";
    static final String[] help = new String[]{" This is a simple calculator, based on JEL.", "", "", "", "", "", "", "", "", ""};

    public static String resultado(String expr) throws Exception {
        int ind;
        expr = expr.replace(NS, NS_COD);
        expr = CalculatorCeres.formatarNumeros(expr);
        expr = CalculatorCeres.outrasFuncoes(expr);
        StringBuffer buf = new StringBuffer(expr);
        for (int x = 0; x < buf.length() && (ind = buf.indexOf("pow (", x)) >= 0; ++x) {
            int ind1;
            x = ind1 = buf.indexOf(",", ind);
            if (ind1 > 0) break;
            int ind2 = buf.indexOf(")", ind);
            if (ind2 <= 0) continue;
            buf.insert(ind2, ",2");
            x = ind2;
        }
        expr = buf.toString();
        Class[] staticLib = new Class[1];
        try {
            staticLib[0] = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e.getMessage());
        }
        Library lib = new Library(staticLib, null, null, null, null);
        try {
            lib.markStateDependent("random", null);
        }
        catch (CompilationException e) {
            throw new Exception(e.getMessage());
        }
        CompiledExpression expr_c = null;
        try {
            expr_c = Evaluator.compile(expr, lib);
        }
        catch (CompilationException ce) {
            System.err.print("--- COMPILATION ERROR :");
            System.err.println(ce.getMessage());
            System.err.print("                       ");
            System.err.println(expr);
            int column = ce.getColumn();
            for (int i = 0; i < column + 23 - 1; ++i) {
                System.err.print(' ');
            }
            System.err.println('^');
            throw new Exception(ce.getMessage());
        }
        if (expr_c != null) {
            Object result = null;
            try {
                result = expr_c.evaluate(null);
            }
            catch (Throwable e) {
                System.err.println("Exception emerged from JEL compiled code (IT'S OK) :");
                System.err.print(e);
                throw new Exception(e.getMessage());
            }
            if (result == null) {
                System.out.println("void");
                return null;
            }
            String res = result.toString();
            return res.startsWith(NS_COD) ? "" : res;
        }
        return null;
    }

    private static String outrasFuncoes(String expr) {
        String res;
        String[] vs;
        String ex;
        while (expr.indexOf("Arredondar (") >= 0) {
            ex = expr.substring(expr.indexOf("Arredondar") + 13);
            ex = ex.substring(0, ex.indexOf(")")).trim();
            vs = ex.split(",");
            float f = Float.parseFloat(vs[0]);
            int i = (int)Float.parseFloat(vs[1]);
            res = String.valueOf(Estatistica.arredondar(f, i));
            expr = expr.replace("Arredondar ( " + ex + " )", res);
        }
        while (expr.indexOf("Format (") >= 0) {
            ex = expr.substring(expr.indexOf("Format") + 9);
            ex = ex.substring(0, ex.indexOf(")")).trim();
            vs = ex.split(",");
            String mask = vs[0];
            mask = mask.replace("\"", "");
            String term = vs[1];
            if (term.startsWith("\"")) {
                res = String.format(mask, term);
            } else {
                float f = Float.parseFloat(term);
                res = String.format(mask, Float.valueOf(f)).replace(",", ".");
            }
            expr = expr.replace("Format ( " + ex + " )", "\"" + res + "\"");
        }
        return expr;
    }

    public static String formatarNumeros(String texto) {
        String[] partes = texto.split(";");
        StringBuilder resultado = new StringBuilder();
        for (String parte : partes) {
            if ((parte = parte.trim()).matches("\\d+")) {
                resultado.append(parte).append(".0");
            } else {
                resultado.append(parte);
            }
            resultado.append(" ");
        }
        return resultado.toString().trim();
    }

    public static void main(String[] args) {
        try {
            String texto = "Arredondar;(;99.99;,;1;) * 2";
            System.out.println("resultado : " + CalculatorCeres.resultado(texto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

