/*
 * Decompiled with CFR 0.152.
 */
package ceres_fert;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Parametro {
    public static final String NUMERICO = "Numerico";
    public static final String SELECAO_UNICA = "Selecao_Unica";
    public static final String CALCULO = "Calculo";
    private long id;
    private Long recomendacao;
    private String descricao;
    private String formula;
    private String formulaid;
    private String tipo;
    private String opcoes;
    private String padrao;
    @JsonIgnore
    private String valor;
    @JsonIgnore
    private List<Parametro> dependencias = new ArrayList<Parametro>();

    public boolean equals(Object o) {
        try {
            Parametro tmp = (Parametro)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.descricao;
    }

    @JsonIgnore
    public boolean isResultado() {
        return this.tipo.equals(CALCULO);
    }

    @JsonIgnore
    public List<String> getValorOpcoes() {
        if (this.opcoes != null) {
            return Arrays.asList(this.opcoes.split(";"));
        }
        return new ArrayList<String>();
    }

    @JsonIgnore
    public void setValorOpcoes(List<String> opcoes_) {
        this.opcoes = "";
        for (String opcao : opcoes_) {
            this.opcoes = this.opcoes + (this.opcoes.equals("") ? "" : ";");
            this.opcoes = this.opcoes + opcao;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormulaid() {
        return this.formulaid;
    }

    public void setFormulaid(String formulaid) {
        this.formulaid = formulaid;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public Long getRecomendacao() {
        return this.recomendacao;
    }

    public void setRecomendacao(Long recomendacao) {
        this.recomendacao = recomendacao;
    }

    public String getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(String opcoes) {
        this.opcoes = opcoes;
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public List<Parametro> getDependencias() {
        return this.dependencias;
    }

    public void setDependencias(List<Parametro> dependencias) {
        this.dependencias = dependencias;
    }
}

