/*
 * Decompiled with CFR 0.152.
 */
package ceres_fert;

import ceresonemodel.dao.DAO_CERES_FERT;
import ceresonemodel.utils.Estatistica;
import com.fasterxml.jackson.annotation.JsonFilter;
import java.util.Arrays;
import java.util.List;

@JsonFilter(value="insert_update_filter")
public class Formula_npk {
    private long id;
    private String descricao;
    private long n;
    private long p;
    private long k;

    public boolean equals(Object o) {
        try {
            Formula_npk tmp = (Formula_npk)o;
            return tmp.getId() == this.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.descricao;
    }

    public static String buscaFormula(List<Formula_npk> formulas, long targetN, long targetP, long targetK) {
        if (formulas == null || formulas.isEmpty()) {
            return "Nenhuma f\u00f3rmula dispon\u00edvel";
        }
        Formula_npk melhorFormula = null;
        double menorQuantidade = Double.MAX_VALUE;
        for (Formula_npk formula : formulas) {
            if (targetN > 0L && formula.getN() == 0L || targetP > 0L && formula.getP() == 0L || targetK > 0L && formula.getK() == 0L) continue;
            double quantidadeN = formula.getN() == 0L ? 0.0 : (double)targetN / ((double)formula.getN() / 100.0);
            double quantidadeP = formula.getP() == 0L ? 0.0 : (double)targetP / ((double)formula.getP() / 100.0);
            double quantidadeK = formula.getK() == 0L ? 0.0 : (double)targetK / ((double)formula.getK() / 100.0);
            double quantidade = Math.max(quantidadeN, Math.max(quantidadeP, quantidadeK));
            double fornecidoN = quantidade * ((double)formula.getN() / 100.0);
            double fornecidoP = quantidade * ((double)formula.getP() / 100.0);
            double fornecidoK = quantidade * ((double)formula.getK() / 100.0);
            if (!(fornecidoN >= (double)targetN) || !(fornecidoP >= (double)targetP) || !(fornecidoK >= (double)targetK) || !(quantidade < menorQuantidade)) continue;
            menorQuantidade = quantidade;
            melhorFormula = formula;
        }
        if (melhorFormula == null) {
            return "Nenhuma f\u00f3rmula comercial atende completamente \u00e0s exig\u00eancias de N, P e K.";
        }
        String n_ = String.valueOf(Estatistica.arredondar((double)targetN / 10.0, 0)).replace(".0", "");
        String p_ = String.valueOf(Estatistica.arredondar((double)targetP / 10.0, 0)).replace(".0", "");
        String k_ = String.valueOf(Estatistica.arredondar((double)targetK / 10.0, 0)).replace(".0", "");
        return "<b>" + Estatistica.arredondar(menorQuantidade, 2) + "</b> kg/ha da formula\u00e7\u00e3o comercial " + melhorFormula.toString() + "<br>Ou <b>1.000</b> kg/ha da formula\u00e7\u00e3o calculada como ideal " + n_ + "-" + p_ + "-" + k_;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public long getN() {
        return this.n;
    }

    public void setN(long n) {
        this.n = n;
    }

    public long getP() {
        return this.p;
    }

    public void setP(long p) {
        this.p = p;
    }

    public long getK() {
        return this.k;
    }

    public void setK(long k) {
        this.k = k;
    }

    public static void main(String[] args) {
        try {
            DAO_CERES_FERT dao = new DAO_CERES_FERT();
            List<Formula_npk> npks = Arrays.asList((Formula_npk[])dao.listObject(Formula_npk[].class, "formula_npk?order=descricao"));
            String saida = Formula_npk.buscaFormula(npks, 60L, 80L, 150L);
            System.out.println("saida : " + saida);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

