/*
 * Decompiled with CFR 0.152.
 */
package calculo;

import ceres_fert.Parametro;
import ceres_fert.Recomendacao;
import ceresjel.CalculatorCeres;
import ceresonemodel.dataceres.ResultadoSolo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalculaRecomendacoes {
    public static List<Parametro> ordenarCalculos(List<Parametro> campos) {
        ArrayList<Parametro> ordenados = new ArrayList<Parametro>();
        for (Parametro campo : campos) {
            campo.getDependencias().clear();
            for (Parametro cp : campos) {
                if (campo.getFormulaid() == null || !campo.isResultado() || !campo.getFormulaid().contains("@" + cp.getId())) continue;
                campo.getDependencias().add(cp);
            }
        }
        ArrayList<Parametro> campos_ordenar = new ArrayList<Parametro>();
        campos_ordenar.addAll(campos);
        while (campos_ordenar.size() > 0) {
            Parametro campo;
            campo = (Parametro)campos_ordenar.get(0);
            if (campo.getDependencias().isEmpty()) {
                ordenados.add(ordenados.size(), campo);
                campos_ordenar.remove(0);
                continue;
            }
            if (ordenados.containsAll(campo.getDependencias())) {
                ordenados.add(ordenados.size(), campo);
                campos_ordenar.remove(0);
                continue;
            }
            campos_ordenar.add(campos_ordenar.size(), campo);
            campos_ordenar.remove(0);
        }
        return ordenados;
    }

    public static void calculaExpressao(Recomendacao recomendacao, List<Parametro> campos, ResultadoSolo resultados_solo) throws Exception {
        Map dcs = CalculaRecomendacoes.getValoresDataCeres(recomendacao, resultados_solo);
        for (Parametro calculando : campos) {
            String expressao;
            if (!calculando.isResultado() || (expressao = calculando.getFormulaid()) == null) continue;
            String[] termos = expressao.split(";");
            int index = 0;
            for (String termo : termos) {
                ++index;
                if (termo.startsWith("DC")) {
                    String key = termo.replace("DC@", "");
                    if (!dcs.containsKey(key)) continue;
                    expressao = expressao.replace(termo, String.valueOf(dcs.get(key)));
                    continue;
                }
                if (!termo.startsWith("CP")) continue;
                for (Parametro campo : campos) {
                    if (!termo.contains(String.valueOf(campo.getId()))) continue;
                    if (campo.getTipo().equals("Numerico")) {
                        expressao = expressao.replace("CP@" + campo.getId(), campo.getValor());
                        continue;
                    }
                    if (campo.getTipo().equals("Selecao_Unica")) {
                        String[] opcoes;
                        String prOpcoes = campo.getOpcoes();
                        expressao = expressao.replace("CP@" + campo.getId(), "\"" + campo.getValor() + "\"");
                        if (prOpcoes == null || prOpcoes.equals("")) continue;
                        for (String opcao : opcoes = prOpcoes.split(";")) {
                            expressao = expressao.replace("CP-" + opcao + "@" + campo.getId(), "\"" + opcao + "\"");
                        }
                        continue;
                    }
                    if (!campo.getTipo().equals("Calculo")) continue;
                    expressao = expressao.replace("CP@" + campo.getId(), campo.getValor() != null ? campo.getValor() : "");
                }
            }
            calculando.setValor(CalculatorCeres.resultado(expressao));
        }
    }

    public static Map getValoresDataCeres(Recomendacao recomendacao, ResultadoSolo resultados_solo) throws Exception {
        HashMap<String, String> dcs = new HashMap<String, String>();
        String[] dcs_pr = recomendacao.getParametros_dataceres_solo_array();
        Class<ResultadoSolo> clazz = ResultadoSolo.class;
        Field[] fields = clazz.getDeclaredFields();
        block0: for (String tmp : dcs_pr) {
            for (Field field : fields) {
                if (!field.getName().equalsIgnoreCase(tmp)) continue;
                field.setAccessible(true);
                Object v = field.get(resultados_solo);
                dcs.put(tmp, String.valueOf(v).replace(",", "."));
                continue block0;
            }
        }
        return dcs;
    }
}

