/*
 * Decompiled with CFR 0.152.
 */
package calculo;

import ceresjel.CalculatorCeres;
import ceresonemodel.campos.CampoLancamentoAnaliseParametro;
import ceresonemodel.campos.CampoSupervisao;
import ceresonemodel.utils.Estatistica;
import java.util.ArrayList;
import java.util.List;

public class CalculaExpressoes {
    public static String calculaExpressao(CampoLancamentoAnaliseParametro calcular, List<CampoLancamentoAnaliseParametro> campos) {
        try {
            String log = "\n" + calcular.getView_formula();
            String expressao = calcular.getView_formulaid();
            log = log + "\nTermos da f\u00f3rmula:";
            String[] termos = expressao.split(";");
            int index = 0;
            for (String termo : termos) {
                if (!termo.startsWith("CP")) continue;
                ++index;
                boolean encontrado = false;
                for (CampoLancamentoAnaliseParametro campo : campos) {
                    if (!termo.contains(String.valueOf(campo.getCampoconfiguracao()))) continue;
                    encontrado = true;
                    if (campo.getView_tipo().equals("Texto")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), "\"" + campo.getValor() + "\"");
                        log = log + "\n\t" + campo.getView_parametro_nome() + " = \"" + campo.getValor() + "\"";
                        continue;
                    }
                    if (campo.getView_tipo().equals("Numerico")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor());
                        log = log + "\n\t" + campo.getView_parametro_nome() + " = " + campo.getValor();
                        continue;
                    }
                    if (campo.getView_tipo().equals("Constante")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor());
                        log = log + "\n\t" + campo.getView_parametro_nome() + " = " + campo.getValor();
                        continue;
                    }
                    if (campo.getView_tipo().equals("Curva_Calibracao")) {
                        expressao = expressao.replace("CP-A@" + campo.getCampoconfiguracao(), String.valueOf(campo.getView_curva_a()));
                        expressao = expressao.replace("CP-B@" + campo.getCampoconfiguracao(), String.valueOf(campo.getView_curva_b()));
                        expressao = expressao.replace("CP-R2@" + campo.getCampoconfiguracao(), String.valueOf(campo.getView_curva_r2()));
                        log = log + "\n\t" + campo.getView_parametro_nome() + " " + campo.getView_curva_nome();
                        log = log + " | A = " + String.valueOf(campo.getView_curva_a());
                        log = log + " | B = " + String.valueOf(campo.getView_curva_b());
                        log = log + " | R2 = " + String.valueOf(campo.getView_curva_r2());
                        continue;
                    }
                    if (campo.getView_tipo().equals("Selecao_Unica")) {
                        String[] opcoes;
                        String prOpcoes = campo.obterParametroValor("opcoes");
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), "\"" + campo.getValor() + "\"");
                        log = log + "\n\t" + campo.getView_parametro_nome() + " = \"" + campo.getValor() + "\"";
                        if (prOpcoes == null || prOpcoes.equals("")) continue;
                        for (String opcao : opcoes = prOpcoes.split(";")) {
                            expressao = expressao.replace("CP-" + opcao + "@" + campo.getCampoconfiguracao(), "\"" + opcao + "\"");
                        }
                        continue;
                    }
                    if (!campo.getView_tipo().equals("Calculo")) continue;
                    expressao = campo.obterParametroValor("tipo").equals("Numerico") ? expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor()) : expressao.replace("CP@" + campo.getCampoconfiguracao(), "\"" + campo.getValor() + "\"");
                    log = log + "\n\t" + campo.getView_parametro_nome() + " = " + campo.getValor();
                }
                if (encontrado) continue;
                log = log + "\n\t" + index + " termo n\u00e3o encontrao! (" + termo + ")";
            }
            log = log + "\nEXPRESS\u00c3O FINAL = " + expressao.replace(";", "");
            if (expressao.contains("n.s.") || expressao.contains("CP")) {
                log = log + "\nN\u00c3O PODE SER CALCULADA, FALTA TERMO(S)!";
                calcular.setEditado(true);
                calcular.setValor("");
            } else {
                String resultado = null;
                try {
                    String prDecimal;
                    resultado = CalculatorCeres.resultado(expressao);
                    String prTipo = calcular.obterParametroValor("tipo");
                    if (prTipo.equals("Numerico") && (prDecimal = calcular.obterParametroValor("casas_decimal")) != null && !prDecimal.equals("") && resultado != null && !resultado.equals("")) {
                        float l = Float.parseFloat(resultado);
                        int decimal = Integer.parseInt(prDecimal);
                        resultado = String.valueOf(Estatistica.arredondar(l, decimal)).replace(",", ".");
                    }
                    calcular.setMenor_lq(CalculaExpressoes.checaLQ(resultado, calcular));
                    log = log + " = " + resultado + (calcular.isMenor_lq() ? " <L.Q." : "");
                }
                catch (Exception e) {
                    log = log + " = ERRO: " + e.getMessage();
                    resultado = "ERRO!";
                }
                calcular.setEditado(true);
                calcular.setValor(resultado);
                log = log + " = " + resultado;
            }
            return log;
        }
        catch (Exception e) {
            System.out.println("erro calculo: " + e.getMessage());
            return "ERRO!";
        }
    }

    public static String calculaExpressao(CampoSupervisao calcular, List<CampoSupervisao> campos) {
        String log = "<p><strong>" + calcular.getFormula2Append() + "</strong>";
        try {
            if (calcular.isForcarcalculo()) {
                log = log + " (For\u00e7ar c\u00e1lculo ativado) ";
            }
            String expressao = calcular.getFormulaid();
            log = log + "</p>";
            log = log + "<p>Termos da f\u00f3rmula:</p><ul>";
            String[] termos = expressao.split(";");
            int index = 0;
            for (String termo : termos) {
                if (!termo.startsWith("CP")) continue;
                ++index;
                boolean encontrado = false;
                for (CampoSupervisao campo : campos) {
                    if (!termo.contains(String.valueOf(campo.getCampoconfiguracao()))) continue;
                    encontrado = true;
                    if (!campo.isResultado()) {
                        log = log + "<li><span style=\"color: gray;\">" + index + " <strong>" + campo.getLabel() + "</strong> = " + (campo.getValor() == null || campo.getValor().equals("") ? "sem valor" : campo.getValor()) + " : Leitura/Repeti\u00e7\u00e3o ignorada.</span></li>";
                        continue;
                    }
                    if (campo.getValor() == null || campo.getValor().equals("")) {
                        if (calcular.isForcarcalculo()) {
                            log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = termo n\u00e3o calculado! Ser\u00e1 substituido por 0(Zero)</li>";
                            continue;
                        }
                        log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = <span style=\"color: red;\">termo n\u00e3o calculado!</span></li>";
                        continue;
                    }
                    if (campo.getTipo().equals("Texto")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), "\"" + campo.getValor() + "\"");
                        log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = \"" + campo.getValor() + "\"</li>";
                        continue;
                    }
                    if (campo.getTipo().equals("Numerico")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor());
                        log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = " + campo.getValor() + "</li>";
                        continue;
                    }
                    if (campo.getTipo().equals("Constante")) {
                        expressao = expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor());
                        log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = " + campo.getValor() + "</li>";
                        continue;
                    }
                    if (!campo.getTipo().equals("Calculo")) continue;
                    expressao = campo.obterParametroValor("tipo").equals("Numerico") ? expressao.replace("CP@" + campo.getCampoconfiguracao(), campo.getValor()) : expressao.replace("CP@" + campo.getCampoconfiguracao(), "\"" + campo.getValor() + "\"");
                    log = log + "<li>" + index + " <strong>" + campo.getLabel() + "</strong> = " + campo.getValor() + "</li>";
                }
                if (encontrado) continue;
                log = calcular.isForcarcalculo() ? log + "<li>" + index + " termo n\u00e3o encontrao! (" + termo + ") > Ser\u00e1 substituido por 0(Zero)</li>" : log + "<li>" + index + "<span style=\"color: red;\"> termo n\u00e3o encontrao! (" + termo + ")</span></li>";
            }
            log = log + "</ul></p>";
            if (calcular.isForcarcalculo()) {
                expressao = CalculaExpressoes.forcaCalculo(expressao);
            }
            log = log + "<p>C\u00e1lculos:</p><ul><li>Express\u00e3o: " + expressao.replace(";", "") + "</li>";
            if (expressao.contains("n.s.") || expressao.contains("CP")) {
                log = log + "<li>Resultado: <span style=\"color: gray;\">Alguns termos n\u00e3o solicitados dessa amostra!</sapn></li>";
                calcular.setEditado(true);
                calcular.setValor("");
                calcular.setLog_erro(false);
                calcular.setLog(log);
            } else if (expressao.contains("CAMPO N\u00c3O CALCULADO!")) {
                log = log + "<li>Resultado: <span style=\"color: red;\">N\u00e3o pode ser calculado, falta termo(s)!</sapn></li>";
                calcular.setEditado(true);
                calcular.setValor("ERRO!");
                calcular.setLog_erro(true);
                calcular.setLog(log);
            } else {
                String resultado = null;
                try {
                    String prDecimal;
                    resultado = CalculatorCeres.resultado(expressao);
                    String prTipo = calcular.obterParametroValor("tipo");
                    if (prTipo != null && prTipo.equals("Numerico") && (prDecimal = calcular.obterParametroValor("casas_decimal")) != null && !prDecimal.equals("") && resultado != null && !resultado.equals("")) {
                        float l = Float.parseFloat(resultado);
                        int decimal = Integer.parseInt(prDecimal);
                        resultado = String.valueOf(Estatistica.arredondar(l, decimal)).replace(",", ".");
                    }
                }
                catch (Exception e) {
                    resultado = "ERRO!";
                    calcular.setLog_erro(true);
                }
                calcular.setEditado(true);
                calcular.setValor(resultado);
                log = log + "<li>Resultado: <strong>" + (resultado.equals("ERRO!") ? "<span style=\"color: red;\">ERRO!</span>" : resultado) + "</strong></li>";
                calcular.setLog_erro(false);
                calcular.setLog(log);
            }
            log = log + "</ul>";
            return log;
        }
        catch (Exception e) {
            log = log + "<span style=\"color: red;\">ERRO INESPERADO: " + e.getMessage() + "</span>";
            calcular.setLog_erro(true);
            calcular.setLog(log);
            return "ERRO!";
        }
    }

    public static List<CampoSupervisao> getDependencias4Expressao(CampoSupervisao calcular, List<CampoSupervisao> campos) {
        ArrayList<CampoSupervisao> dependencias = new ArrayList<CampoSupervisao>();
        String expressao = calcular.getFormulaid();
        String[] termos = expressao.split(";");
        int index = 0;
        for (String termo : termos) {
            if (!termo.startsWith("CP")) continue;
            ++index;
            for (CampoSupervisao campo : campos) {
                if (!termo.contains(String.valueOf(campo.getCampoconfiguracao())) || !campo.isResultado() || campo.getValor() == null || campo.getValor().equals("")) continue;
                dependencias.add(campo);
            }
        }
        return dependencias;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CampoSupervisao> ordenarCalculosRelacoes(List<CampoSupervisao> campos) {
        System.out.println("C\u00e1lculos Rela\u00e7\u00f5es");
        System.out.println("Ordena\u00e7\u00e3o original ----------------------------");
        for (CampoSupervisao campoSupervisao : campos) {
            System.out.println("        " + campoSupervisao.getLabel());
        }
        System.out.println("----------------------------------------------");
        ArrayList<CampoSupervisao> ordenados = new ArrayList<CampoSupervisao>();
        for (CampoSupervisao campo : campos) {
            campo.getDependencias().clear();
            for (CampoSupervisao cp : campos) {
                if (campo.getFormulaid() == null || !campo.isRelacao() || !campo.getFormulaid().contains("CP@" + cp.getCampoconfiguracao())) continue;
                campo.getDependencias().add(cp);
            }
        }
        while (campos.size() > 0) {
            CampoSupervisao campoSupervisao = campos.get(0);
            if (campoSupervisao.getDependencias().isEmpty()) {
                ordenados.add(ordenados.size(), campoSupervisao);
                campos.remove(0);
                continue;
            }
            if (ordenados.containsAll(campoSupervisao.getDependencias())) {
                ordenados.add(ordenados.size(), campoSupervisao);
                campos.remove(0);
                continue;
            }
            campos.remove(0);
            campos.add(campos.size(), campoSupervisao);
        }
        System.out.println("Ordena\u00e7\u00e3o corrigida ----------------------------");
        boolean bl = true;
        for (CampoSupervisao campo : ordenados) {
            if (campo.isRelacao()) {
                void var2_7;
                campo.setOrdem_calculo((int)(++var2_7));
            }
            System.out.println("        " + campo.getLabel());
        }
        System.out.println("----------------------------------------------");
        return ordenados;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CampoLancamentoAnaliseParametro> ordenarCalculos(List<CampoLancamentoAnaliseParametro> campos) {
        System.out.println("C\u00e1lculos Rela\u00e7\u00f5es");
        System.out.println("Ordena\u00e7\u00e3o original ----------------------------");
        for (CampoLancamentoAnaliseParametro campoLancamentoAnaliseParametro : campos) {
            System.out.println("        " + campoLancamentoAnaliseParametro.getView_parametro_nome());
        }
        System.out.println("----------------------------------------------");
        ArrayList<CampoLancamentoAnaliseParametro> ordenados = new ArrayList<CampoLancamentoAnaliseParametro>();
        for (CampoLancamentoAnaliseParametro campo : campos) {
            campo.getDependencias().clear();
            for (CampoLancamentoAnaliseParametro cp : campos) {
                if (campo.getView_formulaid() == null || !campo.getView_formulaid().contains("CP@" + cp.getCampoconfiguracao())) continue;
                campo.getDependencias().add(cp);
            }
        }
        while (campos.size() > 0) {
            CampoLancamentoAnaliseParametro campoLancamentoAnaliseParametro = campos.get(0);
            if (campoLancamentoAnaliseParametro.getDependencias().isEmpty()) {
                ordenados.add(ordenados.size(), campoLancamentoAnaliseParametro);
                campos.remove(0);
                continue;
            }
            if (ordenados.containsAll(campoLancamentoAnaliseParametro.getDependencias())) {
                ordenados.add(ordenados.size(), campoLancamentoAnaliseParametro);
                campos.remove(0);
                continue;
            }
            campos.remove(0);
            campos.add(campos.size(), campoLancamentoAnaliseParametro);
        }
        System.out.println("Ordena\u00e7\u00e3o corrigida ----------------------------");
        boolean bl = true;
        for (CampoLancamentoAnaliseParametro campo : ordenados) {
            void var2_7;
            campo.setOrdem_calculo((int)(++var2_7));
            System.out.println("        " + campo.getView_parametro_nome());
        }
        System.out.println("----------------------------------------------");
        return ordenados;
    }

    private static String forcaCalculo(String expressao) {
        String[] saida;
        for (String x : saida = expressao.split(";")) {
            if (!x.startsWith("CP@")) continue;
            expressao = expressao.replace(x, "0");
        }
        return expressao;
    }

    private static boolean checaLQ(String valor, CampoLancamentoAnaliseParametro cpoConfig) {
        float lq = Float.parseFloat(cpoConfig.obterParametroValor("lq"));
        boolean menor_lq = false;
        if (lq > 0.0f) {
            try {
                float v = Float.parseFloat(valor);
                if (v < lq) {
                    valor = "0";
                    menor_lq = true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return menor_lq;
    }
}

