/*
 * Decompiled with CFR 0.152.
 */
package ceresgis.endpoints;

import ceresonemodel.ceresgis.Grid_geo;
import ceresonemodel.ceresgis.Talhao_geo;
import ceresonemodel.dao.DAO_CERES_GIS;
import ceresonemodel.dao.DAO_DATACERES;
import ceresonemodel.dataceres.Fazenda;
import ceresonemodel.dataceres.Talhao;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class MapaController {
    @GetMapping(value={"/"})
    public String abrirIndex() {
        return "index";
    }

    @GetMapping(value={"/apps/maps/mapa"})
    public String abrirMapa(@RequestParam(value="fazendaId") String fazendaId, @RequestParam(value="token") String token, HttpServletRequest request, Model model) {
        String segredo = "04d@t@cer3sM@p$0206xyzPx123dcz62@";
        if (!MapaController.validarJWT(token, segredo, fazendaId)) {
            model.addAttribute("mensagem", (Object)"Acesso negado.");
            return "erro";
        }
        request.getSession(true).setAttribute("fazendaIdAutorizada", (Object)fazendaId);
        DAO_DATACERES dao_dataceres = new DAO_DATACERES();
        DAO_CERES_GIS dao_gis = new DAO_CERES_GIS();
        Fazenda fazenda = null;
        try {
            fazenda = Fazenda.carregaFazenda((String)fazendaId, (DAO_DATACERES)dao_dataceres);
            if (fazenda == null) {
                model.addAttribute("mensagem", (Object)"Propriedade n\u00e3o encontrada.");
                return "erro";
            }
            List<Talhao> talhoes_dataceres = Arrays.asList((Talhao[])dao_dataceres.listObject(Talhao[].class, "talhao?fazendaid=eq." + fazenda.getId()));
            dao_gis.func_sincronizar_talhoes(talhoes_dataceres, fazenda.getId());
            List<Talhao_geo> talhoes_geo = Arrays.asList((Talhao_geo[])dao_gis.listObject(Talhao_geo[].class, "view_talhao_geo?fazenda_id=eq." + fazenda.getId()));
            model.addAttribute("propriedadeId", (Object)fazendaId);
            model.addAttribute("propriedadeNome", (Object)fazenda.getNome());
            model.addAttribute("proprietario", (Object)fazenda.getProprietario());
            model.addAttribute("municipio", (Object)fazenda.getCidade());
            model.addAttribute("estado", (Object)fazenda.getEstado());
            model.addAttribute("talhoes", talhoes_geo);
            return "mapa";
        }
        catch (Exception ex) {
            model.addAttribute("mensagem", (Object)("Erro ao carregar a propriedade: " + ex.getMessage()));
            return "erro";
        }
    }

    @PostMapping(value={"/apps/maps/importar"})
    @ResponseBody
    public ResponseEntity<String> importarArquivo(@RequestParam(value="arquivo") MultipartFile arquivo) {
        try {
            File tempDir = Files.createTempDirectory("shapefile_zip", new FileAttribute[0]).toFile();
            File zipFile = new File(tempDir, arquivo.getOriginalFilename());
            arquivo.transferTo(zipFile);
            this.unzip(zipFile, tempDir);
            File shpFile = Files.walk(tempDir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(f -> f.getName().toLowerCase().endsWith(".shp")).findFirst().orElseThrow(() -> new Exception("Arquivo .shp n\u00e3o encontrado no .zip"));
            ShapefileDataStore store = new ShapefileDataStore(shpFile.toURI().toURL());
            store.setCharset(StandardCharsets.UTF_8);
            String typeName = store.getTypeNames()[0];
            ContentFeatureSource featureSource = store.getFeatureSource(typeName);
            SimpleFeatureCollection collection = featureSource.getFeatures();
            FeatureJSON fjson = new FeatureJSON();
            StringWriter writer = new StringWriter();
            fjson.writeFeatureCollection((FeatureCollection)collection, (Object)writer);
            store.dispose();
            return ResponseEntity.ok((Object)writer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body((Object)("Erro ao processar o arquivo: " + e.getMessage()));
        }
    }

    private void unzip(File zipFile, File destDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = new File(entry.getName()).getName();
                File newFile = new File(destDir, fileName);
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
            }
        }
    }

    @PostMapping(value={"/apps/maps/salvar-geo"})
    @ResponseBody
    public ResponseEntity<String> salvarGeometriaTalhao(@RequestBody Map<String, Object> body) {
        try {
            DAO_CERES_GIS dao_gis = new DAO_CERES_GIS();
            String talhaoId = (String)body.get("talhaoId");
            String geojsonStr = new ObjectMapper().writeValueAsString(body.get("geojson"));
            dao_gis.func_update_talhao_geometry(talhaoId, geojsonStr);
            return ResponseEntity.ok((Object)"Salvo com sucesso");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)("Erro: " + ex.getMessage()));
        }
    }

    @PostMapping(value={"/apps/maps/talhao_cor"})
    public ResponseEntity<String> atualizarCorTalhao(@RequestBody Map<String, String> dados) {
        try {
            String id = dados.get("id");
            String cor = dados.get("cor");
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            dao.func_update_talhao_cor(id, cor);
            return ResponseEntity.ok((Object)"Cor atualizada");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao atualizar cor: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/apps/maps/grids/incluir"})
    public ResponseEntity<Map<String, String>> incluirGrid(@RequestBody Grid_geo grid) {
        try {
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            grid.setId(dao.nanoid());
            grid.setCriado_em(dao.func_server_time());
            dao.includeObject((Object)grid, "grid_geo");
            dao.func_gerar_pontos_do_grid(grid.getId());
            HashMap<String, String> resposta = new HashMap<String, String>();
            resposta.put("id", grid.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(resposta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body(null);
        }
    }

    @PostMapping(value={"/apps/maps/grids/editar"})
    public ResponseEntity<Map<String, String>> editarGrid(@RequestBody Grid_geo grid) {
        try {
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            grid.setCriado_em(dao.func_server_time());
            dao.updateObject((Object)grid, "grid_geo?id=eq." + grid.getId());
            dao.func_gerar_pontos_do_grid(grid.getId());
            HashMap<String, String> resposta = new HashMap<String, String>();
            resposta.put("id", grid.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(resposta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body(null);
        }
    }

    @GetMapping(value={"/apps/maps/grids/por-talhao"})
    @ResponseBody
    public ResponseEntity<String> listarGridsPorTalhao(@RequestParam(value="talhaoId") String talhaoId) {
        try {
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            String json = dao.getJSon("GET", "grid_geo?talhao_id=eq." + talhaoId + "&order=nome", null);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao buscar grids: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/apps/maps/grids/pontos"})
    @ResponseBody
    public ResponseEntity<String> listarPontosDoGrid(@RequestParam(value="gridId") String gridId) {
        try {
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            String json = dao.getJSon("GET", "view_grid_ponto_geo?grid_id=eq." + gridId + "&order=rotulo", null);
            return ResponseEntity.ok((Object)this.montarFeatureCollection(json));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"erro\":\"" + e.getMessage() + "\"}"));
        }
    }

    private String montarFeatureCollection(String jsonArray) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"type\":\"FeatureCollection\",\"features\":[");
        try {
            JSONArray array = new JSONArray(jsonArray);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{\"type\":\"Feature\",\"geometry\":").append(obj.getString("view_ponto")).append(",\"properties\":{\"id\":\"").append(obj.getString("id")).append("\",\"rotulo\":\"").append(obj.optString("rotulo", "")).append("\"}}");
            }
        }
        catch (Exception e) {
            return "{\"type\":\"FeatureCollection\",\"features\":[]}";
        }
        sb.append("]}");
        return sb.toString();
    }

    @PostMapping(value={"/apps/maps/grids/salvar-pontos"})
    @ResponseBody
    public ResponseEntity<String> salvarPontosDoGrid(@RequestBody Map<String, Object> body) {
        try {
            String gridId = (String)body.get("gridId");
            List geometrias = (List)body.get("geometrias");
            if (gridId == null || geometrias == null) {
                return ResponseEntity.badRequest().body((Object)"Par\u00e2metros inv\u00e1lidos.");
            }
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            dao.func_update_grid_pontos(gridId, geometrias);
            return ResponseEntity.ok((Object)"Pontos salvos com sucesso.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao salvar pontos: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/apps/maps/grids/excluir"})
    @ResponseBody
    public ResponseEntity<String> excluirGrid(@RequestParam(value="gridId") String gridId) {
        try {
            DAO_CERES_GIS dao = new DAO_CERES_GIS();
            Grid_geo gg = new Grid_geo();
            gg.setId(gridId);
            dao.excludeObject((Object)gg, "grid_geo?id=eq." + gg.getId());
            return ResponseEntity.ok((Object)"Exclu\u00eddo");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao excluir: " + e.getMessage()));
        }
    }

    public static boolean validarJWT(String token, String segredoEsperado, String fazendaEsperada) {
        try {
            long exp;
            String[] partes = token.split("\\.");
            if (partes.length != 3) {
                return false;
            }
            String header = partes[0];
            String payload = partes[1];
            String assinaturaRecebida = partes[2];
            String dadosAssinados = header + "." + payload;
            Mac hmac = Mac.getInstance("HmacSHA256");
            hmac.init(new SecretKeySpec(segredoEsperado.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] assinaturaBytes = hmac.doFinal(dadosAssinados.getBytes(StandardCharsets.UTF_8));
            String assinaturaCalculada = Base64.getUrlEncoder().withoutPadding().encodeToString(assinaturaBytes);
            if (!assinaturaCalculada.equals(assinaturaRecebida)) {
                return false;
            }
            String payloadJson = new String(Base64.getUrlDecoder().decode(payload), StandardCharsets.UTF_8);
            Map<String, String> claims = MapaController.extrairClaims(payloadJson);
            long agora = System.currentTimeMillis() / 1000L;
            if (agora > (exp = Long.parseLong(claims.getOrDefault("exp", "0")))) {
                return false;
            }
            String fazendaId = claims.get("fazendaId");
            return fazendaEsperada.equals(fazendaId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Map<String, String> extrairClaims(String json) {
        String[] pares;
        HashMap<String, String> mapa = new HashMap<String, String>();
        json = json.trim().replaceAll("[{}\"]", "");
        for (String par : pares = json.split(",")) {
            String[] kv = par.split(":", 2);
            if (kv.length != 2) continue;
            mapa.put(kv[0].trim(), kv[1].trim());
        }
        return mapa;
    }
}

