/*
 * Decompiled with CFR 0.152.
 */
package ceresfert.endpoints;

import calculo.CalculaRecomendacoes;
import ceres_fert.Formula_npk;
import ceres_fert.Parametro;
import ceres_fert.Recomendacao;
import ceres_fert.RecomendacaoRequest;
import ceres_fert.Recomendacao_parametro;
import ceresfert.dao.DAO_FERT;
import ceresfert.dao.DAO_FERT_DATACERES;
import ceresfert.utils.HtmlToPdf;
import ceresonemodel.dao.DAO_DATACERES;
import ceresonemodel.dataceres.Laboratorio;
import ceresonemodel.dataceres.Pedido;
import ceresonemodel.dataceres.Pedido_doc;
import ceresonemodel.dataceres.ResultadoSolo;
import ceresonemodel.utils.CampoData;
import ceresonemodel.utils.FormatadorHTML;
import ceresonemodel.utils.RetiraAcento;
import ceresonemodel.utils.S3Aws;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FertController {
    @GetMapping(value={"/recomendacoes"})
    public ResponseEntity<String> getCultivares() {
        DAO_FERT dao = new DAO_FERT();
        try {
            String json = dao.getJSon("GET", "recomendacao?ativo=eq.true&order=cultivar", null);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/recomendacoes_parametros"})
    public ResponseEntity<String> getCultivaresParametros(long recomendacao_id) {
        DAO_FERT dao = new DAO_FERT();
        try {
            String json = dao.getJSon("GET", "recomendacao_parametro?recomendacao=eq." + recomendacao_id, null);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/resultados_solo"})
    public ResponseEntity<String> getResultadosSolo(String pedido_id) {
        DAO_FERT_DATACERES dao = new DAO_FERT_DATACERES();
        try {
            String json = dao.getJSon("GET", "resultados_solos?pedidoid=eq." + pedido_id + "&order=numerolab", null);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/gerar_recomendacoes"})
    public ResponseEntity<String> gerarRecomendacoes(@RequestBody RecomendacaoRequest request) {
        try {
            DAO_DATACERES dao_dataceres = new DAO_DATACERES();
            Recomendacao recomendacao = request.getRecomendacao();
            List resultados_solo = request.getResultados_solo();
            List rps = request.getParametros();
            if (request.getOpcoes_amostras() != null) {
                int x = 0;
                for (String op : request.getOpcoes_amostras()) {
                    ((ResultadoSolo)resultados_solo.get(x)).setOpcoes_amostra(op);
                    ++x;
                }
            }
            ArrayList<byte[]> pdf_pgs = new ArrayList<byte[]>();
            Pedido pedido = null;
            Laboratorio lab = null;
            List<Parametro> parametros = this.getParametrosCalculos(recomendacao, rps);
            for (ResultadoSolo rs : resultados_solo) {
                if (pedido == null) {
                    pedido = Pedido.carregaPedido((String)rs.getPedidoid(), (DAO_DATACERES)dao_dataceres);
                    lab = Laboratorio.carregaLaboratorio((String)pedido.getLaboratorio(), (DAO_DATACERES)dao_dataceres);
                }
                Parametro opcoes_amostra = new Parametro();
                opcoes_amostra.setId(-1L);
                opcoes_amostra.setDescricao("Op\u00e7\u00f5es espec\u00edficas por amostras");
                opcoes_amostra.setValorOpcoes(Arrays.asList(recomendacao.getOpcoes_amostra_array()));
                opcoes_amostra.setRecomendacao(Long.valueOf(recomendacao.getId()));
                opcoes_amostra.setTipo("Selecao_Unica");
                opcoes_amostra.setValor(rs.getOpcoes_amostra());
                ArrayList<Parametro> tmps = new ArrayList<Parametro>();
                tmps.addAll(parametros);
                tmps.add(opcoes_amostra);
                byte[] b = this.getPaginaRecomendacao(recomendacao, rs, tmps, pedido, lab);
                if (b == null) continue;
                pdf_pgs.add(b);
            }
            String id = dao_dataceres.nanoid();
            byte[] b = HtmlToPdf.mergePDFs(pdf_pgs);
            S3Aws.salvar((byte[])b, (String)(id + ".pdf"), (String)"application/pdf", (String)"ceresfert");
            Pedido_doc doc = new Pedido_doc();
            doc.setId(id);
            doc.setArquivo(id + ".pdf");
            doc.setAtualizadoem(new Date());
            doc.setBucket("ceresfert");
            doc.setCriadoem(new Date());
            doc.setDescricao(recomendacao.getCultivar());
            doc.setEnviado(new Date());
            doc.setMime_type("application/pdf");
            doc.setNumero(CampoData.dataToString((Date)new Date()));
            doc.setTipo("Recomendacao");
            doc.setPedido(pedido.getId());
            doc.setS3(true);
            dao_dataceres.includeObject((Object)doc, "pedido_doc");
            String jsonResponse = "{\"file\": \"" + id + ".pdf\",\"bucket\": \"" + "ceresfert" + "\"}";
            return new ResponseEntity((Object)jsonResponse, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Erro ao processar recomenda\u00e7\u00f5es: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private byte[] getPaginaRecomendacao(Recomendacao recomendacao, ResultadoSolo resultado_solo, List<Parametro> parametros, Pedido pedido, Laboratorio lab) {
        try {
            String valor;
            CalculaRecomendacoes.calculaExpressao((Recomendacao)recomendacao, parametros, (ResultadoSolo)resultado_solo);
            byte[] b = null;
            String html = recomendacao.getRelatorio();
            Map cds = CalculaRecomendacoes.getValoresDataCeres((Recomendacao)recomendacao, (ResultadoSolo)resultado_solo);
            for (Object key : cds.keySet()) {
                valor = String.valueOf(cds.get(key));
                valor = valor.startsWith("-") ? "n\u00e3o analisado" : valor;
                html = FertController.substituirTexto(html, "DC@" + key, valor);
            }
            for (Parametro parametro : parametros) {
                String string = valor = parametro.getValor() != null ? parametro.getValor() : "";
                if (valor.matches("\\d+\\.?\\d*")) {
                    double num = Double.parseDouble(valor);
                    DecimalFormat formatador = new DecimalFormat("#.##");
                    valor = formatador.format(num).replace(",", ".");
                }
                html = FertController.substituirTexto(html, "CP@" + parametro.getId(), valor);
            }
            while (html.indexOf("@NPK(") >= 0) {
                String ex = html.substring(html.indexOf("@NPK("));
                ex = ex.substring(0, ex.indexOf(")") + 1);
                html = html.replace(ex, FertController.replaceFormuaNPK(ex));
            }
            InputStream inputStream = this.getClass().getResourceAsStream("template.html");
            String template = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            template = this.replace(template, "@laboratorio", lab.getNome_completo());
            template = this.replace(template, "@cultivar", recomendacao.getCultivar());
            template = this.replace(template, "@fonte", recomendacao.getFonte());
            template = this.replace(template, "@data", CampoData.dataToString((Date)new Date()));
            template = this.replace(template, "@numero", pedido.getNumero());
            template = this.replace(template, "@descricao", pedido.getDescricao());
            template = this.replace(template, "@fazenda", pedido.getFazenda());
            template = this.replace(template, "@proprietario", pedido.getProprietario());
            template = this.replace(template, "@am_numerolab", resultado_solo.getNumerolab());
            template = this.replace(template, "@am_descricao", resultado_solo.getDescricao());
            template = this.replace(template, "@talhao", resultado_solo.getTalhao());
            template = this.replace(template, "@enviado", CampoData.dataToString((Date)resultado_solo.getEnviado()));
            template = this.replace(template, "@profundidade", resultado_solo.getProfundidade());
            template = template.replace("@html", html);
            b = HtmlToPdf.convertHtmlToPdf(template);
            return b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Parametro> getParametrosCalculos(Recomendacao recomendacao, List<Recomendacao_parametro> rps) throws Exception {
        DAO_FERT dao = new DAO_FERT();
        ArrayList<Parametro> prs = new ArrayList<Parametro>();
        prs.addAll(Arrays.asList((Parametro[])dao.listObject(Parametro[].class, "parametro?recomendacao=eq." + recomendacao.getId() + "&order=descricao")));
        block0: for (Parametro pr : prs) {
            if (pr.isResultado()) continue;
            for (Recomendacao_parametro rp : rps) {
                if (pr.getId() != rp.getId()) continue;
                pr.setValor(rp.getValor());
                continue block0;
            }
        }
        return CalculaRecomendacoes.ordenarCalculos(prs);
    }

    public static String substituirTexto(String texto, String chave, String valor) {
        String padrao = "<span data-codigo=\"" + chave + "\">(\\s*<b>)?\\{[^}]*\\}(</b>)?\\s*</span>";
        Pattern pattern = Pattern.compile(padrao);
        Matcher matcher = pattern.matcher(texto);
        return matcher.replaceAll(valor);
    }

    private String replace(String souce, String target, String replacement) {
        replacement = replacement == null ? "" : replacement;
        try {
            replacement = FormatadorHTML.addScape((String)replacement);
        }
        catch (Exception e) {
            replacement = RetiraAcento.removeEspeciais((String)replacement);
        }
        return souce.replace(target, replacement);
    }

    private static String replaceFormuaNPK(String formula) throws Exception {
        String f = formula.replace("@NPK(", "").replace(")", "");
        String[] vals = f.split(",", -1);
        if (vals == null || vals.length < 3) {
            return "ERRO FORMULA";
        }
        long n = vals[0].isEmpty() ? 0L : Long.parseLong(vals[0]);
        long p = vals[1].isEmpty() ? 0L : Long.parseLong(vals[1]);
        long k = vals[2].isEmpty() ? 0L : Long.parseLong(vals[2]);
        DAO_FERT dao = new DAO_FERT();
        List<Formula_npk> npks = Arrays.asList((Formula_npk[])dao.listObject(Formula_npk[].class, "formula_npk?order=descricao"));
        return Formula_npk.buscaFormula(npks, (long)n, (long)p, (long)k).toString();
    }
}

