/*
 * Decompiled with CFR 0.152.
 */
package ceresfert;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private final String SECRET_KEY;

    public JwtUtil() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] key = new byte[32];
        secureRandom.nextBytes(key);
        this.SECRET_KEY = Base64.getEncoder().encodeToString(key);
    }

    public String generateToken(String username) {
        Algorithm algorithm = Algorithm.HMAC256((byte[])this.SECRET_KEY.getBytes(StandardCharsets.UTF_8));
        return JWT.create().withSubject(username).withIssuedAt(new Date(System.currentTimeMillis())).withExpiresAt(new Date(System.currentTimeMillis() + 36000000L)).sign(algorithm);
    }

    public boolean validateToken(String token, String username) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((byte[])this.SECRET_KEY.getBytes(StandardCharsets.UTF_8))).withSubject(username).build();
            DecodedJWT decodedJWT = verifier.verify(token);
            return !this.isTokenExpired(decodedJWT);
        }
        catch (JWTVerificationException e) {
            return false;
        }
    }

    public String extractUsername(String token) {
        return JWT.decode((String)token).getSubject();
    }

    private boolean isTokenExpired(DecodedJWT decodedJWT) {
        return decodedJWT.getExpiresAt().before(new Date());
    }
}

