/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.ArrayList;
import org.jets3t.service.model.StorageBucket;

public class S3Bucket
extends StorageBucket {
    public static final String LOCATION_US = null;
    public static final String LOCATION_US_STANDARD = null;
    public static final String LOCATION_US_WEST = "us-west-1";
    public static final String LOCATION_US_WEST_NORTHERN_CALIFORNIA = "us-west-1";
    public static final String LOCATION_US_WEST_OREGON = "us-west-2";
    public static final String LOCATION_EUROPE = "EU";
    public static final String LOCATION_EU_IRELAND = "eu-west-1";
    public static final String LOCATION_EU_FRANKFURT = "eu-central-1";
    public static final String LOCATION_ASIA_PACIFIC_SOUTHEAST = "ap-southeast-1";
    public static final String LOCATION_ASIA_PACIFIC_SYDNEY = "ap-southeast-2";
    public static final String LOCATION_ASIA_PACIFIC_NORTHEAST = "ap-northeast-1";
    public static final String LOCATION_ASIA_PACIFIC = "ap-southeast-1";
    public static final String LOCATION_ASIA_PACIFIC_SINGAPORE = "ap-southeast-1";
    public static final String LOCATION_ASIA_PACIFIC_TOKYO = "ap-northeast-1";
    public static final String LOCATION_SOUTH_AMERICA_SAO_PAULO = "sa-east-1";
    public static final String LOCATION_SOUTH_AMERICA_EAST = "sa-east-1";
    public static final String LOCATION_GOVCLOUD_US_WEST = "s3-us-gov-west-1";
    public static final String LOCATION_GOVCLOUD_FIPS_US_WEST = "s3-fips-us-gov-west-1";
    private boolean requesterPays = false;
    private boolean isRequesterPaysKnown = false;

    public S3Bucket() {
    }

    public S3Bucket(String name) {
        super(name, null);
    }

    public S3Bucket(String name, String location) {
        super(name, location);
    }

    public String toString() {
        return "S3Bucket [name=" + this.getName() + ",location=" + this.getLocation() + ",creationDate=" + this.getCreationDate() + ",owner=" + this.getOwner() + "] Metadata=" + this.getMetadataMap();
    }

    public void setRequesterPays(boolean requesterPays) {
        this.requesterPays = requesterPays;
        this.isRequesterPaysKnown = true;
    }

    public boolean isRequesterPaysKnown() {
        return this.isRequesterPaysKnown;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }

    public static S3Bucket[] cast(StorageBucket[] buckets) {
        ArrayList<S3Bucket> results = new ArrayList<S3Bucket>();
        for (StorageBucket bucket : buckets) {
            results.add((S3Bucket)bucket);
        }
        return results.toArray(new S3Bucket[results.size()]);
    }
}

