/*
 * Decompiled with CFR 0.152.
 */
package ceresbot.utils;

import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HtmlToPdf {
    public static byte[] convertHtmlToPdf(String html) throws Exception {
        html = html.replace("<br>", "<br />");
        Document document = Jsoup.parse((String)html);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        String sanitizedHtml = document.html();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfRendererBuilder builder = new PdfRendererBuilder();
        builder.useFastMode();
        builder.withHtmlContent(sanitizedHtml, null);
        builder.toStream((OutputStream)os);
        builder.run();
        os.close();
        return os.toByteArray();
    }

    public static byte[] mergePDFs(List<byte[]> pdfs) throws IOException {
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (byte[] pdf : pdfs) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdf);
            pdfMerger.addSource((InputStream)inputStream);
        }
        pdfMerger.setDestinationStream((OutputStream)outputStream);
        pdfMerger.mergeDocuments(null);
        return outputStream.toByteArray();
    }

    public static void salvar(byte[] arquivo, String salvar_em) throws Exception {
        FileOutputStream os = new FileOutputStream(salvar_em);
        ((OutputStream)os).write(arquivo);
        os.flush();
        ((OutputStream)os).close();
    }
}

