/*
 * Decompiled with CFR 0.152.
 */
package ceresbot.endpoints;

import ceresbot.endpoints.BotIA;
import ceresbot.node.NodeInterface;
import ceresonemodel.bot.Bot_config;
import ceresonemodel.bot.MensagemBot;
import ceresonemodel.bot.Protocolo;
import ceresonemodel.dao.DAO_CERES_BOT;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class JobEncerramentoProtocolos {
    private final Set<Long> protocolosComAlertaEnviado = new HashSet<Long>();

    @Scheduled(fixedRate=120000L)
    public void verificarInatividadeProtocolos() {
        try {
            DAO_CERES_BOT dao_bot = new DAO_CERES_BOT();
            List<Protocolo> protocolosAtivos = Arrays.asList((Protocolo[])dao_bot.listObject(Protocolo[].class, "view_protocolo?view_inatividade=not.eq.OK"));
            HashSet<Long> protocolosAtivosIds = new HashSet<Long>();
            for (Protocolo p : protocolosAtivos) {
                MensagemBot msg;
                protocolosAtivosIds.add(p.getId());
                Bot_config config = BotIA.getConfig(p.getBot_config(), dao_bot);
                if (!NodeInterface.isConectado(config.getNumero())) continue;
                if ("ENCERRAR".equals(p.getView_inatividade())) {
                    msg = JobEncerramentoProtocolos.criaResposta(p, config.getMensagem_encerrado_inatividade(), config);
                    NodeInterface.sendMessage(msg);
                    p.setStatus(Protocolo.ENCERRADO_INATIVIDADE);
                    dao_bot.updateObject((Object)p, "protocolo?id=eq." + p.getId());
                    this.protocolosComAlertaEnviado.remove(p.getId());
                    continue;
                }
                if (!"ALERTA".equals(p.getView_inatividade()) || this.protocolosComAlertaEnviado.contains(p.getId())) continue;
                msg = JobEncerramentoProtocolos.criaResposta(p, "Ainda podemos te ajudar? Responda essa mensagem para n\u00e3o encerrar o atendimento.", config);
                NodeInterface.sendMessage(msg);
                this.protocolosComAlertaEnviado.add(p.getId());
            }
            this.protocolosComAlertaEnviado.removeIf(id -> !protocolosAtivosIds.contains(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static MensagemBot criaResposta(Protocolo protocolo, String texto, Bot_config config) {
        MensagemBot resposta = new MensagemBot();
        resposta.setBot_config(Long.valueOf(config.getId()));
        resposta.setNumero(protocolo.getNumero_usuario());
        resposta.setSender_name("BOT");
        resposta.setSender_number(config.getNumero());
        resposta.setText(texto);
        resposta.setType("chat");
        return resposta;
    }
}

