/*
 * Decompiled with CFR 0.152.
 */
package ceresbot.endpoints;

import ceresbot.node.NodeInterface;
import ceresonemodel.analise.LaudoAnexo;
import ceresonemodel.analise.Pedido;
import ceresonemodel.bot.Bot_config;
import ceresonemodel.bot.MensagemBot;
import ceresonemodel.bot.Protocolo;
import ceresonemodel.bot.Setor_bot;
import ceresonemodel.cadastro.Pessoa;
import ceresonemodel.dao.DAO_CERES;
import ceresonemodel.dao.DAO_CERES_BOT;
import ceresonemodel.dao.DAO_LAB;
import ceresonemodel.fatura.Fatura;
import ceresonemodel.users.Cliente;
import ceresonemodel.utils.CampoData;
import ceresonemodel.utils.Cripto;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class BotIA {
    private static final String IP = "187.108.197.201";
    private static final DAO_CERES dao_ceres = new DAO_CERES("187.108.197.201");
    private static final Map<Long, Bot_config> configCache = new ConcurrentHashMap<Long, Bot_config>();
    private static final int numero_tentativas_laudos = 3;
    public static final String PATH_QRCODE_VALIDADOR = "http://ceresone.com.br/validador";

    public static void processarMensagemRecebida(MensagemBot mensagem) {
        try {
            boolean segunda_via_ativa;
            System.out.println("\ud83e\udd16 [IA] Pensando sobre a mensagem recebida: " + mensagem.getText());
            DAO_CERES_BOT dao_bot = new DAO_CERES_BOT();
            Protocolo protocolo = Protocolo.carregaProtocolo((long)mensagem.getProtocolo(), (DAO_CERES_BOT)dao_bot);
            Bot_config config = BotIA.getConfig(mensagem.getBot_config(), dao_bot);
            String msg_recebida = mensagem.getText();
            boolean bl = segunda_via_ativa = protocolo.getTentativas_segunda_via() < 3;
            if (protocolo.getResponsavel().equals("BOT")) {
                if (protocolo.getFluxo().equals(Protocolo.FLUXO_INICIAL)) {
                    boolean menu_inicial = true;
                    Setor_bot opcao_selecioada = null;
                    if (msg_recebida == null || msg_recebida.trim().isEmpty()) {
                        menu_inicial = true;
                    } else if (msg_recebida.trim().matches("\\d+")) {
                        int opcao = Integer.parseInt(msg_recebida.trim());
                        for (Setor_bot sb : config.getOpcoes()) {
                            if (sb.getNumero() != opcao) continue;
                            opcao_selecioada = sb;
                            menu_inicial = false;
                            break;
                        }
                        if (!segunda_via_ativa && opcao_selecioada.getTipo().equals("Segunda via laudo")) {
                            opcao_selecioada = null;
                        }
                    } else {
                        menu_inicial = true;
                    }
                    if (menu_inicial) {
                        BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                    } else if (opcao_selecioada != null) {
                        MensagemBot resposta;
                        if (opcao_selecioada.getTipo().equalsIgnoreCase("Setor")) {
                            MensagemBot resposta2;
                            String msg;
                            String resultado = BotIA.verificarDisponibilidadeAtendimento(config);
                            if (!resultado.equals("OK")) {
                                msg = resultado;
                                protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                                resposta2 = BotIA.criaResposta(mensagem, msg, "BOT", config);
                                NodeInterface.sendMessage(resposta2);
                                BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                            } else {
                                protocolo.setResponsavel("*" + opcao_selecioada.getNome() + ":" + opcao_selecioada.getView_usuarios());
                                protocolo.setFluxo(Protocolo.FLUXO_CHAT_USUARIO);
                                msg = "Aguarde um momento por favor.";
                                resposta2 = BotIA.criaResposta(mensagem, msg, "BOT", config);
                                NodeInterface.sendMessage(resposta2);
                            }
                            dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                        } else if (opcao_selecioada.getTipo().equalsIgnoreCase("Encerrar")) {
                            protocolo.setStatus(Protocolo.ENCERRADO_USUARIO);
                            MensagemBot resposta3 = BotIA.criaResposta(mensagem, config.getMensagem_encerrado_cliente(), "BOT", config);
                            NodeInterface.sendMessage(resposta3);
                            dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                        } else if (opcao_selecioada.getTipo().equalsIgnoreCase("Segunda via laudo")) {
                            if (protocolo.getIdentificacao() == null || protocolo.getIdentificacao().equals("")) {
                                protocolo.setFluxo(Protocolo.FLUXO_AUTENTICANDO_LAUDO);
                                String msg = "Digite sua identifica\u00e7\u00e3o CPF ou CNPJ (apenas n\u00fameros).";
                                resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
                                NodeInterface.sendMessage(resposta);
                                dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                            }
                        } else if (opcao_selecioada.getTipo().equalsIgnoreCase("Segunda via fatura")) {
                            protocolo.setFluxo(Protocolo.FLUXO_SEGUNDAVIA_FATURA);
                            String msg = "Digite sua identifica\u00e7\u00e3o CPF ou CNPJ (apenas n\u00fameros).";
                            resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
                            NodeInterface.sendMessage(resposta);
                            dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                        }
                    } else {
                        BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                    }
                } else if (protocolo.getFluxo().equals(Protocolo.FLUXO_AUTENTICANDO_LAUDO)) {
                    DAO_LAB dao_lab = config.getCliente_obj().getDao();
                    String cod = BotIA.formataCPF_CNPJ(msg_recebida);
                    List<Pessoa> pessoas = Arrays.asList((Pessoa[])dao_lab.listObject(Pessoa[].class, "view_pessoa?cod1=eq." + cod));
                    String msg = "";
                    boolean inicial = false;
                    if (pessoas == null || pessoas.isEmpty()) {
                        protocolo.setIdentificacao(null);
                        protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                        protocolo.setTentativas_segunda_via(0);
                        msg = "Cadastro n\u00e3o encontrado.";
                        inicial = true;
                    } else {
                        protocolo.setIdentificacao(String.valueOf(pessoas.get(0).getId()));
                        protocolo.setTentativas_segunda_via(0);
                        protocolo.setFluxo(Protocolo.FLUXO_SEGUNDAVIA_LAUDO);
                        msg = "Cadastro localizado.\nDigite o n\u00famero do pedido que deseja consultar (numero/ano).";
                    }
                    MensagemBot resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
                    NodeInterface.sendMessage(resposta);
                    dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                    if (inicial) {
                        BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                    }
                } else if (protocolo.getFluxo().equals(Protocolo.FLUXO_SEGUNDAVIA_LAUDO)) {
                    DAO_LAB dao_lab;
                    List<Pedido> pedidos;
                    Pedido pedido = null;
                    if (msg_recebida != null && (pedidos = Arrays.asList((Pedido[])(dao_lab = config.getCliente_obj().getDao()).listObject(Pedido[].class, "view_pedido?view_numero_ano=eq." + msg_recebida.trim()))) != null && !pedidos.isEmpty()) {
                        pedido = pedidos.get(0);
                    }
                    String msg = null;
                    if (pedido == null) {
                        msg = "Pedido n\u00e3o encontrado!";
                        protocolo.setTentativas_segunda_via(protocolo.getTentativas_segunda_via() + 1);
                        if (protocolo.getTentativas_segunda_via() >= 3) {
                            msg = msg + "\nVoc\u00ea atingiou o limite de tentativas!";
                            protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                            protocolo.setIdentificacao(null);
                        }
                    } else {
                        msg = "Pedido encontrado " + pedido.toString() + "\nPessoa: " + pedido.getView_cliente_nome() + (pedido.getView_fazenda_nome() != null && !pedido.getView_fazenda_nome().equals("") ? "\nPropriedade: " + pedido.getView_fazenda_nome() : "") + (pedido.getView_fazenda_proprietario() != null && !pedido.getView_fazenda_proprietario().equals("") ? "\nPropriet\u00e1rio: " + pedido.getView_fazenda_proprietario() : "");
                        protocolo.setTentativas_segunda_via(0);
                        protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                        protocolo.setIdentificacao(null);
                    }
                    MensagemBot resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
                    NodeInterface.sendMessage(resposta);
                    if (protocolo.getTentativas_segunda_via() >= 3) {
                        BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                    }
                    if (msg.startsWith("Pedido encontrado") && pedido != null) {
                        String laudos_msg = BotIA.getOpcoesLaudo(config, pedido);
                        MensagemBot resp_laudos = BotIA.criaResposta(mensagem, laudos_msg, "BOT", config);
                        NodeInterface.sendMessage(resp_laudos);
                    }
                    dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                } else if (protocolo.getFluxo().equals(Protocolo.FLUXO_SEGUNDAVIA_FATURA)) {
                    DAO_LAB dao_lab = config.getCliente_obj().getDao();
                    String cod = BotIA.formataCPF_CNPJ(msg_recebida);
                    List<Pessoa> pessoas = Arrays.asList((Pessoa[])dao_lab.listObject(Pessoa[].class, "view_pessoa?cod1=eq." + cod));
                    String msg = "";
                    boolean inicial = false;
                    if (pessoas == null || pessoas.isEmpty()) {
                        protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                        msg = "Cadastro n\u00e3o encontrado.";
                        inicial = true;
                    } else {
                        Pessoa pessoa = pessoas.get(0);
                        List<Fatura> faturas = Arrays.asList((Fatura[])dao_lab.listObject(Fatura[].class, "view_fatura?cobranca=eq." + pessoa.getId() + "&saldodevedor=gt.0&dataceres_id=not.is.null&order=data"));
                        if (faturas == null || faturas.isEmpty()) {
                            protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                            msg = "No momento n\u00e3o existe faturas pendentes para o n\u00famero digitado.";
                            inicial = true;
                        } else {
                            for (Fatura fatura : faturas) {
                                protocolo.setFluxo(Protocolo.FLUXO_INICIAL);
                                msg = BotIA.getFaturas(config, faturas);
                                inicial = false;
                            }
                        }
                    }
                    MensagemBot resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
                    NodeInterface.sendMessage(resposta);
                    dao_bot.updateObject((Object)protocolo, "protocolo?id=eq." + protocolo.getId());
                    if (inicial) {
                        BotIA.envia_mensagem_inicial(config, mensagem, protocolo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static MensagemBot criaResposta(MensagemBot mensagem, String texto, String responsavel, Bot_config config) {
        MensagemBot resposta = new MensagemBot();
        resposta.setBot_config(Long.valueOf(config.getId()));
        resposta.setNumero(mensagem.getSender_number());
        resposta.setSender_name(responsavel);
        resposta.setSender_number(config.getNumero());
        resposta.setText((responsavel.equals("BOT") ? "" : responsavel + ": ") + texto);
        resposta.setType("chat");
        return resposta;
    }

    private static String getOpcoesLaudo(Bot_config config, Pedido pedido) throws Exception {
        DAO_LAB dao_lab = config.getCliente_obj().getDao();
        String resposta = "";
        List<LaudoAnexo> anexos = Arrays.asList((LaudoAnexo[])dao_lab.listObject(LaudoAnexo[].class, "view_laudoanexo?view_pedido_id=eq." + pedido.getId() + "&view_laudo_cancelado=eq.false&view_laudo_aprovacao=not.is.null&order=view_laudo_data,view_laudo_ano,view_laudo_numero"));
        if (anexos != null && !anexos.isEmpty()) {
            if (pedido.isDataceres_aguardar_pagamento() && pedido.getView_fatura_datapagamento() == null) {
                resposta = "Pedido aguardando pagamento para libera\u00e7\u00e3o.";
            } else {
                for (LaudoAnexo anexo : anexos) {
                    resposta = resposta + "\n\ud83d\udcc4Laudo " + anexo.getView_laudo_numero_ano() + " - " + anexo.getNome();
                    resposta = resposta + "\n  \ud83d\udcce" + BotIA.getLink2QR(anexo.getBucket(), anexo.getView_s3()) + "\n";
                }
            }
        } else {
            resposta = "Nenhum laudo dispon\u00edvel para esse pedido a previs\u00e3o \u00e9 " + CampoData.dataToString((Date)pedido.getPrevisao());
        }
        return resposta;
    }

    private static String getFaturas(Bot_config config, List<Fatura> faturas) throws Exception {
        DAO_LAB dao_lab = config.getCliente_obj().getDao();
        String resposta = "";
        if (faturas != null && !faturas.isEmpty()) {
            for (Fatura fatura : faturas) {
                if (fatura.getDataceres_id() == null) continue;
                resposta = resposta + "\n\ud83d\udcc4Fatura " + fatura.toString() + " - " + CampoData.dataToString((Date)fatura.getData());
                resposta = resposta + "\n  \ud83d\udcce" + BotIA.getFaturaLikDataCeres(fatura.getDataceres_id()) + "\n";
            }
        }
        return resposta;
    }

    private static String getLink2QR(String bucket, String id) {
        try {
            String path = "http://ceresone.com.br/validador?doc=";
            String key = bucket + ";" + id;
            key = Cripto.encriptar((String)key);
            return path + key;
        }
        catch (Exception e) {
            return "erro ao obter arquivo!";
        }
    }

    public static void processarMensagemEnviada(MensagemBot mensagem) {
        System.out.println("\ud83d\udce4 [IA] Mensagem enviada processada: " + mensagem.getText());
    }

    public static Bot_config getConfig(Long botConfigId, DAO_CERES_BOT dao_bot) {
        Bot_config config = configCache.get(botConfigId);
        if (config == null) {
            try {
                config = Bot_config.carregaBot_Config((long)botConfigId, (DAO_CERES_BOT)dao_bot);
                Cliente cliente = Cliente.carregaCliente((String)config.getCliente(), (DAO_CERES)dao_ceres);
                DAO_LAB dao = new DAO_LAB(IP, cliente.getCodlab_nome());
                cliente.setDao(dao);
                config.setCliente_obj(cliente);
                if (config != null) {
                    configCache.put(botConfigId, config);
                    System.out.println("Configura\u00e7\u00e3o carregada e cacheada para bot_config_id=" + botConfigId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public static void limparConfigCache(Long botConfigId) {
        configCache.remove(botConfigId);
        System.out.println("?Configura\u00e7\u00e3o removida do cache para bot_config_id=" + botConfigId);
    }

    private static void envia_mensagem_inicial(Bot_config config, MensagemBot mensagem, Protocolo protocolo) throws Exception {
        String msg = config.getMensagem_inicial() + "\n";
        for (Setor_bot sb : config.getOpcoes()) {
            if (sb.getTipo().equals("Segunda via laudo")) {
                if (protocolo.getTentativas_segunda_via() >= 3) continue;
                msg = msg + "\n" + sb.toString();
                continue;
            }
            msg = msg + "\n" + sb.toString();
        }
        MensagemBot resposta = BotIA.criaResposta(mensagem, msg, "BOT", config);
        NodeInterface.sendMessage(resposta);
    }

    private static String formataCPF_CNPJ(String cpf_cnpj) {
        String apenasNumeros = cpf_cnpj.replaceAll("\\D", "");
        String cod1Formatado = apenasNumeros.length() == 11 ? apenasNumeros.replaceFirst("(\\d{3})(\\d{3})(\\d{3})(\\d{2})", "$1.$2.$3-$4") : (apenasNumeros.length() == 14 ? apenasNumeros.replaceFirst("(\\d{2})(\\d{3})(\\d{3})(\\d{4})(\\d{2})", "$1.$2.$3/$4-$5") : apenasNumeros);
        return cod1Formatado;
    }

    public static String verificarDisponibilidadeAtendimento(Bot_config config) {
        if (!config.isHabilitar_verificacao_horario()) {
            return "OK";
        }
        LocalDateTime agora = LocalDateTime.now();
        DayOfWeek diaSemana = agora.getDayOfWeek();
        LocalTime horarioAtual = agora.toLocalTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String manhaInicio = null;
        String manhaFim = null;
        String tardeInicio = null;
        String tardeFim = null;
        switch (diaSemana) {
            case MONDAY: {
                manhaInicio = config.getSegunda_manha_inicio();
                manhaFim = config.getSegunda_manha_fim();
                tardeInicio = config.getSegunda_tarde_inicio();
                tardeFim = config.getSegunda_tarde_fim();
                break;
            }
            case TUESDAY: {
                manhaInicio = config.getTerca_manha_inicio();
                manhaFim = config.getTerca_manha_fim();
                tardeInicio = config.getTerca_tarde_inicio();
                tardeFim = config.getTerca_tarde_fim();
                break;
            }
            case WEDNESDAY: {
                manhaInicio = config.getQuarta_manha_inicio();
                manhaFim = config.getQuarta_manha_fim();
                tardeInicio = config.getQuarta_tarde_inicio();
                tardeFim = config.getQuarta_tarde_fim();
                break;
            }
            case THURSDAY: {
                manhaInicio = config.getQuinta_manha_inicio();
                manhaFim = config.getQuinta_manha_fim();
                tardeInicio = config.getQuinta_tarde_inicio();
                tardeFim = config.getQuinta_tarde_fim();
                break;
            }
            case FRIDAY: {
                manhaInicio = config.getSexta_manha_inicio();
                manhaFim = config.getSexta_manha_fim();
                tardeInicio = config.getSexta_tarde_inicio();
                tardeFim = config.getSexta_tarde_fim();
                break;
            }
            case SATURDAY: {
                manhaInicio = config.getSabado_manha_inicio();
                manhaFim = config.getSabado_manha_fim();
                tardeInicio = config.getSabado_tarde_inicio();
                tardeFim = config.getSabado_tarde_fim();
                break;
            }
            case SUNDAY: {
                manhaInicio = config.getDomingo_manha_inicio();
                manhaFim = config.getDomingo_manha_fim();
                tardeInicio = config.getDomingo_tarde_inicio();
                tardeFim = config.getDomingo_tarde_fim();
            }
        }
        boolean dentroHorario = false;
        try {
            LocalTime fim;
            LocalTime inicio;
            if (manhaInicio != null && !manhaInicio.isEmpty() && manhaFim != null && !manhaFim.isEmpty()) {
                inicio = LocalTime.parse(manhaInicio, formatter);
                fim = LocalTime.parse(manhaFim, formatter);
                if (!horarioAtual.isBefore(inicio) && !horarioAtual.isAfter(fim)) {
                    dentroHorario = true;
                }
            }
            if (!(dentroHorario || tardeInicio == null || tardeInicio.isEmpty() || tardeFim == null || tardeFim.isEmpty())) {
                inicio = LocalTime.parse(tardeInicio, formatter);
                fim = LocalTime.parse(tardeFim, formatter);
                if (!horarioAtual.isBefore(inicio) && !horarioAtual.isAfter(fim)) {
                    dentroHorario = true;
                }
            }
        }
        catch (Exception e) {
            dentroHorario = false;
        }
        if (dentroHorario) {
            return "OK";
        }
        StringBuilder horarios = new StringBuilder();
        if (manhaInicio != null && !manhaInicio.isEmpty()) {
            horarios.append("Manh\u00e3: ").append(manhaInicio).append(" \u00e0s ").append(manhaFim).append("\n");
        }
        if (tardeInicio != null && !tardeInicio.isEmpty()) {
            horarios.append("Tarde: ").append(tardeInicio).append(" \u00e0s ").append(tardeFim).append("\n");
        }
        return config.getMensagem_fora_de_horario() + "\n\nHor\u00e1rios de atendimento hoje:\n" + horarios.toString().trim();
    }

    public static String getFaturaLikDataCeres(String fatura_id) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)("{\r\n  \"faturaId\": \"" + fatura_id + "\"\r\n}"));
        Request request = new Request.Builder().url("https://dataceres.com.br/backend/app/v1/finance/generate-url").method("POST", body).addHeader("Content-Type", "application/json").addHeader("Authorization", "C3r3s@040206#XYZ9900").build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new Exception("Erro na requisi\u00e7\u00e3o: " + response.code());
            }
            String responseBody = response.body().string();
            JSONObject json = new JSONObject(responseBody);
            String string = json.getString("short_url");
            return string;
        }
    }

    public static String getPedidoLikDataCeres(String pedido_id) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)("{\r\n  \"pedidoId\": \"" + pedido_id + "\"\r\n}"));
        Request request = new Request.Builder().url("https://dataceres.com.br/backend/app/v1/order/generate-url").method("POST", body).addHeader("Content-Type", "application/json").addHeader("Authorization", "C3r3s@040206#XYZ9900").build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new Exception("Erro na requisi\u00e7\u00e3o: " + response.code());
            }
            String responseBody = response.body().string();
            JSONObject json = new JSONObject(responseBody);
            String string = json.getString("short_url");
            return string;
        }
    }
}

