/*
 * Decompiled with CFR 0.152.
 */
package ceresbot.endpoints;

import ceresbot.endpoints.BotIA;
import ceresbot.node.NodeInterface;
import ceresonemodel.bot.MensagemBot;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BotController {
    @GetMapping(value={"/status"})
    public ResponseEntity<String> getStatus(@RequestParam(value="fone") String fone) {
        try {
            boolean conectado = NodeInterface.isConectado(fone);
            String json = this.getMesageJson(conectado ? "CONECTADO" : "DESCONECTADO");
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String errorJson = this.getMesageJson("ERRO: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorJson);
        }
    }

    @PostMapping(value={"/start"})
    public ResponseEntity<String> startSession(@RequestBody Map<String, String> requestBody) {
        try {
            String fone = requestBody.get("phoneNumber");
            if (fone == null || fone.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)this.getMesageJson("ERRO: N\u00famero de telefone \u00e9 obrigat\u00f3rio!"));
            }
            NodeInterface.conecta(fone);
            String json = this.getMesageJson("OK");
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String errorJson = this.getMesageJson("ERRO: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorJson);
        }
    }

    @GetMapping(value={"/qrcode"})
    public ResponseEntity<String> getQrCode(@RequestParam(value="fone") String fone) {
        try {
            String qrCodeBase64 = NodeInterface.getQrCodeString(fone);
            String json = this.getMesageJson(qrCodeBase64);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String errorJson = this.getMesageJson("ERRO: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorJson);
        }
    }

    @PostMapping(value={"/forceremove"})
    public ResponseEntity<String> forceRemove(@RequestBody Map<String, String> requestBody) {
        try {
            String fone = requestBody.get("phoneNumber");
            if (fone == null || fone.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)this.getMesageJson("ERRO: N\u00famero de telefone \u00e9 obrigat\u00f3rio!"));
            }
            boolean ok = NodeInterface.forceRemove(fone);
            String json = this.getMesageJson(ok ? "OK: sess\u00e3o removida" : "ERRO: sess\u00e3o n\u00e3o encontrada");
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String errorJson = this.getMesageJson("ERRO: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorJson);
        }
    }

    @PostMapping(value={"/stop"})
    public ResponseEntity<String> stop(@RequestBody Map<String, String> requestBody) {
        try {
            String fone = requestBody.get("phoneNumber");
            if (fone == null || fone.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)this.getMesageJson("ERRO: N\u00famero de telefone \u00e9 obrigat\u00f3rio!"));
            }
            boolean ok = NodeInterface.stop(fone);
            String json = this.getMesageJson(ok ? "OK: sess\u00e3o encerrada" : "ERRO: sess\u00e3o n\u00e3o encontrada");
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String errorJson = this.getMesageJson("ERRO: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorJson);
        }
    }

    @PostMapping(value={"/mensagens"})
    public ResponseEntity<String> receberMensagem(@RequestBody MensagemBot mensagem) {
        try {
            String textoCorrigido = new String(mensagem.getText().getBytes(), "UTF-8");
            System.out.println("\ud83d\udce9 Mensagem recebida (" + mensagem.getMessageid() + ") " + mensagem.getSender_number() + ": " + textoCorrigido);
            mensagem.setId(NodeInterface.DAO_CERES_BOT_.getSeq());
            mensagem.setBot_config(Long.valueOf(NodeInterface.DAO_CERES_BOT_.getBot_config(mensagem.getNumero()).getId()));
            mensagem.setTimestamp(NodeInterface.DAO_CERES_BOT_.func_server_time());
            mensagem.setProtocolo(Long.valueOf(NodeInterface.DAO_CERES_BOT_.fnc_obter_ou_criar_protocolo(mensagem.getBot_config().longValue(), mensagem.getSender_number())));
            NodeInterface.DAO_CERES_BOT_.includeObject((Object)mensagem, "mensagem_bot");
            CompletableFuture.runAsync(() -> BotIA.processarMensagemRecebida(mensagem));
            return ResponseEntity.ok((Object)"{\"message\": \"Mensagem recebida com sucesso\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"{\"message\": \"Erro ao processar mensagem\"}");
        }
    }

    @PostMapping(value={"/send"}, consumes={"application/json"})
    public ResponseEntity<String> send(@RequestBody MensagemBot mensagem) {
        try {
            NodeInterface.sendMessage(mensagem);
            CompletableFuture.runAsync(() -> BotIA.processarMensagemEnviada(mensagem));
            return ResponseEntity.ok((Object)"{\"message\": \"Mensagem enviada com sucesso\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao enviar mensagem: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/limpar-cache"})
    public ResponseEntity<String> limparCache(@RequestBody Map<String, String> requestBody) {
        try {
            String botConfigIdStr = requestBody.get("botConfigId");
            if (botConfigIdStr == null || botConfigIdStr.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)this.getMesageJson("ERRO: botConfigId \u00e9 obrigat\u00f3rio!"));
            }
            Long botConfigId = Long.parseLong(botConfigIdStr);
            BotIA.limparConfigCache(botConfigId);
            return ResponseEntity.ok((Object)this.getMesageJson("Cache limpo para botConfigId=" + botConfigId));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getMesageJson("Erro ao limpar cache: " + e.getMessage()));
        }
    }

    private String getMesageJson(String mensagem) {
        return "{ \n  \"message\": \"" + mensagem + "\"\n}";
    }
}

