/*
 * Decompiled with CFR 0.152.
 */
package ceresbot;

import ceresbot.AuthRequest;
import ceresbot.JwtUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private UserDetailsService myUserDetailsService;

    @PostMapping(value={"/authenticate"})
    public String createAuthenticationToken(@RequestBody AuthRequest authRequest) throws Exception {
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)authRequest.getUsername(), (Object)authRequest.getPassword()));
        }
        catch (Exception e) {
            throw new Exception("Invalid username or password", e);
        }
        UserDetails userDetails = this.myUserDetailsService.loadUserByUsername(authRequest.getUsername());
        return this.jwtUtil.generateToken(userDetails.getUsername());
    }
}

